/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceDescription;
import org.junit.Assert;

public class TestEventListener
implements IResourceDescription.Event.Listener {
    private volatile boolean eventFired = false;
    private final IFile file;
    private final String context;

    public TestEventListener(String context, IFile file) {
        this.file = file;
        this.context = context;
    }

    public void descriptionsChanged(IResourceDescription.Event event) {
        URI expectedURI = URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true);
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            URI deltaURI = delta.getUri();
            if (!expectedURI.equals(deltaURI)) continue;
            this.eventFired = true;
        }
    }

    public void waitForFiredEvent() {
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        long span = end - start;
        while (!this.eventFired && span < 5000L) {
            end = System.currentTimeMillis();
            span = end - start;
        }
        if (!this.eventFired && span > 5000L) {
            Assert.fail((String)("DirtyStateManager event not produced for " + this.context + "."));
        }
    }
}

