/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.eclipse.xtext.xbase.lib.Functions;

@GwtCompatible
public final class KeyComparator<T, C extends Comparable<? super C>>
implements Comparator<T> {
    private final Functions.Function1<? super T, C> keyFunction;

    public KeyComparator(Functions.Function1<? super T, C> keyFunction) {
        this.keyFunction = (Functions.Function1)Preconditions.checkNotNull(keyFunction, (Object)"keyFunction");
    }

    @Override
    public int compare(T a, T b) {
        Comparable c2;
        Comparable c1 = (Comparable)this.keyFunction.apply(a);
        if (c1 == (c2 = (Comparable)this.keyFunction.apply(b))) {
            return 0;
        }
        if (c1 != null) {
            return c1.compareTo(c2);
        }
        return -c2.compareTo(c1);
    }
}

