/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.SourceLocationKey;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.project.BundleProjectService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferenceNode;
import org.eclipse.pde.internal.ui.wizards.imports.AlternateSourceLocations;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardExpressPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class PluginImportWizardFirstPage
extends WizardPage {
    private static final String SETTINGS_IMPORTTYPE = "importType";
    private static final String SETTINGS_FROM = "importFrom";
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_SCAN_ALL = "scanAll";
    private static final int FROM_ACTIVE_PLATFORM = 1;
    private static final int FROM_TARGET_DEFINITION = 2;
    private static final int FROM_DIRECTORY = 3;
    private Button importActiveTargetButton;
    private Button browseButton;
    private Button importDirectoryButton;
    private Button importTargetDefinitionButton;
    private Combo targetDefinitionCombo;
    private List<ITargetDefinition> targetDefinitions;
    private Combo importDirectory;
    private Link openTargetPrefsLink;
    private Button importButton;
    private Button scanButton;
    private Button binaryButton;
    private Button binaryWithLinksButton;
    private Button sourceButton;
    private Button repositoryButton;
    public static String TARGET_PLATFORM = "targetPlatform";
    private IPluginModelBase[] models = new IPluginModelBase[0];
    private SourceLocationManager alternateSource;
    private PDEState state;
    private boolean canceled = false;
    protected Set<Object> repositoryModels = new HashSet<Object>();
    private Map<IBundleImporter, ScmUrlImportDescription[]> importerToInstructions = new HashMap<IBundleImporter, ScmUrlImportDescription[]>();
    private Map<String, IScmUrlImportWizardPage> importIdToWizardPage = new HashMap<String, IScmUrlImportWizardPage>();
    private List<IScmUrlImportWizardPage> nextPages = new ArrayList<IScmUrlImportWizardPage>();

    public PluginImportWizardFirstPage(String name) {
        super(name);
        this.setTitle(PDEUIMessages.ImportWizard_FirstPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 1808);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createImportFromGroup(container);
        this.createImportChoicesGroup(container);
        this.createImportOptionsGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.initialize();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_first_page");
    }

    private void createImportChoicesGroup(Composite container) {
        Group importChoices = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importGroup, 1, 1, 768);
        this.scanButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_scanAll);
        this.importButton = SWTFactory.createRadioButton((Composite)importChoices, PDEUIMessages.ImportWizard_FirstPage_importPrereqs);
    }

    private void createImportOptionsGroup(Composite container) {
        Group options = SWTFactory.createGroup(container, PDEUIMessages.ImportWizard_FirstPage_importAs, 1, 1, 768);
        this.binaryButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binary);
        this.binaryWithLinksButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_binaryLinks);
        this.sourceButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.ImportWizard_FirstPage_source);
        this.repositoryButton = SWTFactory.createRadioButton((Composite)options, PDEUIMessages.PluginImportWizardFirstPage_3);
    }

    private void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            String curr = settings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.importDirectory.setItems(items.toArray(new String[items.size()]));
        this.refreshTargetDropDown();
        int source = 1;
        try {
            source = settings.getInt(SETTINGS_FROM);
        }
        catch (NumberFormatException numberFormatException) {}
        this.importDirectory.select(0);
        this.targetDefinitionCombo.select(0);
        this.updateSourceGroup(source);
        int importType = 1;
        try {
            importType = settings.getInt(SETTINGS_IMPORTTYPE);
        }
        catch (NumberFormatException numberFormatException) {}
        if (importType == 1) {
            this.binaryButton.setSelection(true);
        } else if (importType == 2) {
            this.binaryWithLinksButton.setSelection(true);
        } else if (importType == 3) {
            this.sourceButton.setSelection(true);
        } else {
            this.repositoryButton.setSelection(true);
        }
        boolean scan = true;
        if (settings.get(SETTINGS_SCAN_ALL) != null) {
            scan = settings.getBoolean(SETTINGS_SCAN_ALL);
        }
        this.scanButton.setSelection(scan);
        this.importButton.setSelection(!scan);
    }

    private void updateSourceGroup(int source) {
        this.importActiveTargetButton.setSelection(source == 1);
        this.importTargetDefinitionButton.setSelection(source == 2);
        this.targetDefinitionCombo.setEnabled(source == 2);
        this.importDirectoryButton.setSelection(source == 3);
        this.importDirectory.setEnabled(source == 3);
        this.browseButton.setEnabled(source == 3);
        if (source == 1) {
            this.importDirectory.setText(TargetPlatform.getLocation());
        }
    }

    private void refreshTargetDropDown() {
        ITargetPlatformService service = this.getTargetPlatformService();
        if (service != null) {
            ITargetHandle[] targets = service.getTargets(null);
            this.targetDefinitions = new ArrayList<ITargetDefinition>();
            ITargetHandle[] iTargetHandleArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle target = iTargetHandleArray[n2];
                try {
                    this.targetDefinitions.add(target.getTargetDefinition());
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
                ++n2;
            }
            Collections.sort(this.targetDefinitions, (td1, td2) -> {
                String name1 = td1.getName() == null ? "" : td1.getName();
                String name2 = td2.getName() == null ? "" : td2.getName();
                return name1.compareTo(name2);
            });
            String[] names = new String[this.targetDefinitions.size()];
            int i = 0;
            while (i < this.targetDefinitions.size()) {
                ITargetDefinition currentTarget = this.targetDefinitions.get(i);
                names[i] = currentTarget.getName();
                if (names[i] == null || names[i].trim().length() == 0) {
                    names[i] = currentTarget.getHandle().toString();
                }
                ++i;
            }
            this.targetDefinitionCombo.setItems(names);
        }
    }

    private ITargetPlatformService getTargetPlatformService() {
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        return service;
    }

    private void createImportFromGroup(Composite parent) {
        Group composite = SWTFactory.createGroup(parent, PDEUIMessages.ImportWizard_FirstPage_importFrom, 3, 1, 768);
        this.importActiveTargetButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_target, 1);
        this.importActiveTargetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateSourceGroup(this.getImportOrigin());
            this.validateDropLocation();
        }));
        Composite linkComp = SWTFactory.createComposite((Composite)composite, 1, 2, 768, 0, 0);
        this.openTargetPrefsLink = new Link(linkComp, 0);
        this.openTargetPrefsLink.setText(PDEUIMessages.ImportWizard_FirstPage_goToTarget);
        this.openTargetPrefsLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        this.openTargetPrefsLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TargetPlatformPreferenceNode targetNode;
            ITargetDefinition selected = this.getTargetDefinition();
            ITargetHandle handle = null;
            if (selected != null) {
                handle = selected.getHandle();
            }
            if (this.showPreferencePage(targetNode = new TargetPlatformPreferenceNode(), this.getShell())) {
                this.refreshTargetDropDown();
                int index = -1;
                if (handle != null) {
                    int i = 0;
                    while (i < this.targetDefinitions.size()) {
                        ITargetHandle h = this.targetDefinitions.get(i).getHandle();
                        if (h.equals(handle)) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index == -1 && this.targetDefinitions.size() > 0) {
                    index = 0;
                }
                if (index >= 0) {
                    this.targetDefinitionCombo.select(index);
                }
                this.importDirectory.setText(TargetPlatform.getLocation());
            }
        }));
        this.importTargetDefinitionButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.PluginImportWizardFirstPage_0, 1);
        this.importTargetDefinitionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateSourceGroup(this.getImportOrigin());
            this.validateDropLocation();
        }));
        this.targetDefinitionCombo = SWTFactory.createCombo((Composite)composite, 12, 2, 768, null);
        this.targetDefinitionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validateDropLocation()));
        this.importDirectoryButton = SWTFactory.createRadioButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_otherFolder, 1);
        this.importDirectoryButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateSourceGroup(this.getImportOrigin());
            this.validateDropLocation();
        }));
        this.importDirectory = SWTFactory.createCombo((Composite)composite, 4, 1, 768, null);
        this.importDirectory.addModifyListener(e -> this.validateDropLocation());
        this.browseButton = SWTFactory.createPushButton((Composite)composite, PDEUIMessages.ImportWizard_FirstPage_browse, null, 256);
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IPath chosen = this.chooseDropLocation();
            if (chosen != null) {
                this.importDirectory.setText(chosen.toOSString());
            }
        }));
    }

    private boolean showPreferencePage(IPreferenceNode targetNode, Shell shell) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        PreferenceDialog dialog = new PreferenceDialog(shell, manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)shell.getDisplay(), () -> {
            dialog.create();
            dialog.setMessage(targetNode.getLabelText());
            if (dialog.open() == 0) {
                blArray[0] = true;
            }
        });
        return result[0];
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.importDirectory.getText());
        dialog.setText(PDEUIMessages.ImportWizard_messages_folder_title);
        dialog.setMessage(PDEUIMessages.ImportWizard_messages_folder_message);
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    public boolean getScanAllPlugins() {
        return this.scanButton.getSelection();
    }

    public int getImportType() {
        if (this.binaryButton.getSelection()) {
            return 1;
        }
        if (this.binaryWithLinksButton.getSelection()) {
            return 2;
        }
        if (this.repositoryButton.getSelection()) {
            return 4;
        }
        return 3;
    }

    public SourceLocationManager getAlternateSourceLocations() {
        return this.alternateSource;
    }

    public String getDropLocation() {
        return this.importActiveTargetButton.getSelection() ? TARGET_PLATFORM : this.importDirectory.getText().trim();
    }

    public void storeSettings() {
        boolean other;
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = other = !this.importActiveTargetButton.getSelection();
        if (this.importDirectory.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.importDirectory.getText().trim());
            String[] items = this.importDirectory.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        settings.put(SETTINGS_FROM, this.getImportOrigin());
        settings.put(SETTINGS_IMPORTTYPE, this.getImportType());
        settings.put(SETTINGS_SCAN_ALL, this.getScanAllPlugins());
    }

    private int getImportOrigin() {
        int source = 1;
        if (this.importTargetDefinitionButton.getSelection()) {
            source = 2;
        } else if (this.importDirectoryButton.getSelection()) {
            source = 3;
        }
        return source;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validateDropLocation() {
        if (this.importTargetDefinitionButton.getSelection() && this.targetDefinitionCombo.getText().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(PDEUIMessages.PluginImportWizardFirstPage_2);
            return;
        }
        if (this.importDirectoryButton.getSelection()) {
            Path curr = new Path(this.importDirectory.getText());
            if (curr.segmentCount() == 0 && curr.getDevice() == null) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_locationMissing);
                this.setPageComplete(false);
                return;
            }
            if (!Path.ROOT.isValidPath(this.importDirectory.getText())) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderInvalid);
                this.setPageComplete(false);
                return;
            }
            if (!curr.toFile().isDirectory()) {
                this.setErrorMessage(PDEUIMessages.ImportWizard_errors_buildFolderMissing);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(PDEUIMessages.ImportWizard_FirstPage_desc);
    }

    private void resolveArbitraryLocation(String location) {
        ITargetPlatformService service = this.getTargetPlatformService();
        if (service != null) {
            File plugins = new File(location, "plugins");
            ITargetLocation container = null;
            container = plugins.exists() ? service.newDirectoryLocation(plugins.getAbsolutePath()) : service.newDirectoryLocation(location);
            ITargetDefinition target = service.newTarget();
            target.setTargetLocations(new ITargetLocation[]{container});
            this.resolveTargetDefinition(target, this.getImportType());
        }
    }

    private void resolveTargetDefinition(ITargetDefinition target, int type) {
        IRunnableWithProgress op = monitor -> {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
            subMon.beginTask(PDEUIMessages.PluginImportWizardFirstPage_1, 100);
            if (!target.isResolved()) {
                target.resolve((IProgressMonitor)subMon.split(50));
            }
            subMon.setWorkRemaining(50);
            if (subMon.isCanceled()) {
                return;
            }
            TargetBundle[] allBundles = target.getAllBundles();
            HashMap<SourceLocationKey, TargetBundle> sourceMap = new HashMap<SourceLocationKey, TargetBundle>();
            ArrayList<URL> all = new ArrayList<URL>();
            TargetBundle[] targetBundleArray = allBundles;
            int n2 = allBundles.length;
            int n3 = 0;
            while (n3 < n2) {
                TargetBundle bundle1 = targetBundleArray[n3];
                try {
                    if (bundle1.getStatus().isOK()) {
                        all.add(new File(bundle1.getBundleInfo().getLocation()).toURI().toURL());
                        if (bundle1.isSourceBundle()) {
                            sourceMap.put(new SourceLocationKey(bundle1.getBundleInfo().getSymbolicName(), new Version(bundle1.getBundleInfo().getVersion())), bundle1);
                        }
                    }
                }
                catch (MalformedURLException e1) {
                    this.setErrorMessage(e1.getMessage());
                    subMon.setCanceled(true);
                    return;
                }
                ++n3;
            }
            this.state = new PDEState(all.toArray(new URL[0]), false, false, (IProgressMonitor)subMon.split(30));
            this.models = this.state.getTargetModels();
            ArrayList<IPluginModelBase> sourceModels = new ArrayList<IPluginModelBase>();
            ArrayList<TargetBundle> sourceBundles = new ArrayList<TargetBundle>();
            IPluginModelBase[] iPluginModelBaseArray = this.models;
            int n4 = this.models.length;
            int n5 = 0;
            while (n5 < n4) {
                IPluginModelBase model = iPluginModelBaseArray[n5];
                IPluginBase base = model.getPluginBase();
                TargetBundle bundle2 = (TargetBundle)sourceMap.get(new SourceLocationKey(base.getId(), new Version(base.getVersion())));
                if (bundle2 != null) {
                    sourceModels.add(model);
                    sourceBundles.add(bundle2);
                }
                ++n5;
            }
            this.alternateSource = new AlternateSourceLocations(sourceModels.toArray(new IPluginModelBase[sourceModels.size()]), sourceBundles.toArray(new TargetBundle[sourceBundles.size()]));
            try {
                this.buildImportDescriptions((IProgressMonitor)subMon.split(20), type);
            }
            catch (CoreException e2) {
                throw new InvocationTargetException(e2);
            }
            this.canceled = subMon.isCanceled();
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void buildImportDescriptions(IProgressMonitor monitor, int type) throws CoreException {
        BundleProjectService service = (BundleProjectService)BundleProjectService.getDefault();
        this.repositoryModels.clear();
        this.importerToInstructions.clear();
        this.nextPages.clear();
        if (type == 4) {
            if (this.models != null) {
                this.importerToInstructions = service.getImportDescriptions(this.models);
                Iterator<Map.Entry<IBundleImporter, ScmUrlImportDescription[]>> iterator = this.importerToInstructions.entrySet().iterator();
                while (iterator.hasNext()) {
                    ScmUrlImportDescription[] descriptions;
                    if (monitor.isCanceled()) continue;
                    Map.Entry<IBundleImporter, ScmUrlImportDescription[]> entry = iterator.next();
                    ScmUrlImportDescription[] scmUrlImportDescriptionArray = descriptions = entry.getValue();
                    int n = descriptions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScmUrlImportDescription desc = scmUrlImportDescriptionArray[n2];
                        this.repositoryModels.add(desc.getProperty("PLUGIN"));
                        ++n2;
                    }
                }
            }
            if (!monitor.isCanceled()) {
                for (Map.Entry<IBundleImporter, ScmUrlImportDescription[]> entry : this.importerToInstructions.entrySet()) {
                    IBundleImporter importer = entry.getKey();
                    String importerId = importer.getId();
                    IScmUrlImportWizardPage page = this.importIdToWizardPage.get(importerId);
                    if (page == null && (page = TeamUI.getPages((String)importerId)[0]) != null) {
                        this.importIdToWizardPage.put(importerId, page);
                        ((Wizard)this.getWizard()).addPage((IWizardPage)page);
                    }
                    if (page == null) continue;
                    this.nextPages.add(page);
                }
            }
        }
        if (monitor.isCanceled()) {
            this.importerToInstructions.clear();
            this.repositoryModels.clear();
            this.nextPages.clear();
        }
    }

    boolean arePagesComplete() {
        for (IScmUrlImportWizardPage page : this.nextPages) {
            if (page.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    boolean finishPages() {
        for (IScmUrlImportWizardPage page : this.nextPages) {
            if (page.finish()) continue;
            return false;
        }
        return true;
    }

    Map<IBundleImporter, ScmUrlImportDescription[]> getImportDescriptions() {
        HashMap<IBundleImporter, ScmUrlImportDescription[]> map = new HashMap<IBundleImporter, ScmUrlImportDescription[]>();
        if (this.getImportType() == 4) {
            IBundleImporter[] importers;
            IBundleImporter[] iBundleImporterArray = importers = Team.getBundleImporters();
            int n = importers.length;
            int n2 = 0;
            while (n2 < n) {
                IScmUrlImportWizardPage page;
                IBundleImporter importer = iBundleImporterArray[n2];
                if (this.importerToInstructions.containsKey(importer) && (page = this.importIdToWizardPage.get(importer.getId())) != null && this.nextPages.contains(page) && page.getSelection() != null) {
                    map.put(importer, page.getSelection());
                }
                ++n2;
            }
        }
        return map;
    }

    IWizardPage getNextPage(IWizardPage page) {
        int index;
        if (this.nextPages.isEmpty()) {
            return null;
        }
        if (page instanceof IScmUrlImportWizardPage && (index = this.nextPages.indexOf(page)) >= 0 && index < this.nextPages.size() - 1) {
            IWizardPage iWizardPage = (IWizardPage)this.nextPages.get(index + 1);
            return this.isPageEmpty(iWizardPage) ? null : iWizardPage;
        }
        if (page instanceof PluginImportWizardDetailedPage || page instanceof PluginImportWizardExpressPage) {
            for (IWizardPage iWizardPage : this.nextPages) {
                if (this.isPageEmpty(iWizardPage)) continue;
                return iWizardPage;
            }
        }
        return null;
    }

    private boolean isPageEmpty(IWizardPage page) {
        if (!(page instanceof IScmUrlImportWizardPage)) {
            return false;
        }
        ScmUrlImportDescription[] selection = ((IScmUrlImportWizardPage)page).getSelection();
        return selection == null || selection.length == 0;
    }

    IWizardPage getPreviousPage(IWizardPage page) {
        int index;
        if (page instanceof IScmUrlImportWizardPage && (index = this.nextPages.indexOf(page)) > 0) {
            return (IWizardPage)this.nextPages.get(index - 1);
        }
        return null;
    }

    public IPluginModelBase[] getModels() {
        switch (this.getImportOrigin()) {
            case 1: {
                ITargetPlatformService service = this.getTargetPlatformService();
                if (service == null) break;
                try {
                    ITargetDefinition target = service.getWorkspaceTargetDefinition();
                    this.resolveTargetDefinition(target, this.getImportType());
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
                break;
            }
            case 2: {
                this.resolveTargetDefinition(this.getTargetDefinition(), this.getImportType());
                break;
            }
            case 3: {
                this.resolveArbitraryLocation(this.getDropLocation());
            }
        }
        return this.models;
    }

    public PDEState getState() {
        return this.state;
    }

    private ITargetDefinition getTargetDefinition() {
        int index = this.targetDefinitionCombo.getSelectionIndex();
        if (index >= 0 && this.targetDefinitions.size() > 0) {
            return this.targetDefinitions.get(this.targetDefinitionCombo.getSelectionIndex());
        }
        return null;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean isRefreshNeeded() {
        if (this.canceled) {
            this.canceled = false;
            return true;
        }
        return false;
    }

    public Object getImportSource() {
        switch (this.getImportOrigin()) {
            case 2: {
                return this.getTargetDefinition();
            }
        }
        return this.getDropLocation();
    }

    public void configureBundleImportPages(IPluginModelBase[] models) {
        HashSet<IPluginModelBase> modelsSet = new HashSet<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            modelsSet.add(model);
            ++n2;
        }
        HashMap<IBundleImporter, ArrayList<ScmUrlImportDescription>> importerToImportees = new HashMap<IBundleImporter, ArrayList<ScmUrlImportDescription>>();
        for (Map.Entry<IBundleImporter, ScmUrlImportDescription[]> entry : this.importerToInstructions.entrySet()) {
            ScmUrlImportDescription[] descriptions;
            IBundleImporter importer = entry.getKey();
            ScmUrlImportDescription[] scmUrlImportDescriptionArray = descriptions = entry.getValue();
            int n3 = descriptions.length;
            int n4 = 0;
            while (n4 < n3) {
                ScmUrlImportDescription desc = scmUrlImportDescriptionArray[n4];
                IPluginModelBase model = (IPluginModelBase)desc.getProperty("PLUGIN");
                if (modelsSet.contains(model)) {
                    ArrayList<ScmUrlImportDescription> importees = (ArrayList<ScmUrlImportDescription>)importerToImportees.get(importer);
                    if (importees == null) {
                        importees = new ArrayList<ScmUrlImportDescription>();
                        importerToImportees.put(importer, importees);
                    }
                    importees.add(desc);
                }
                ++n4;
            }
        }
        Iterator<IScmUrlImportWizardPage> iterator2 = this.importIdToWizardPage.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setSelection(new ScmUrlImportDescription[0]);
        }
        for (Map.Entry entry : importerToImportees.entrySet()) {
            IBundleImporter importer = (IBundleImporter)entry.getKey();
            List list = (List)entry.getValue();
            ScmUrlImportDescription[] descriptions = list.toArray(new ScmUrlImportDescription[list.size()]);
            IScmUrlImportWizardPage page = this.importIdToWizardPage.get(importer.getId());
            if (page == null) continue;
            page.setSelection(descriptions);
        }
    }
}

