/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.compare;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.ui.compare.ProjectCompareTree;
import org.eclipse.n4js.ui.compare.ProjectCompareTreeHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class ApiCompareView
extends ViewPart {
    @Inject
    private ProjectCompareTreeHelper projectCompareTreeHelper;
    public static final String ID = "org.eclipse.n4js.ui.apicompareview";
    private ProjectCompareTree viewer;
    private Action actionUpdate;
    private Action actionOpenInEditor;
    @Inject
    private IURIEditorOpener uriOpener;

    public void createPartControl(Composite parent) {
        this.viewer = new ProjectCompareTree(parent, 770, this.projectCompareTreeHelper);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickListener();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApiCompareView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionUpdate);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUpdate);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionUpdate);
    }

    private void makeActions() {
        this.actionUpdate = new Action(){

            public void run() {
                ApiCompareView.this.updateComparison();
            }
        };
        this.actionUpdate.setText("Update");
        this.actionUpdate.setToolTipText("Recompute comparison for all API project and their implementation projects in the workspace.");
        this.actionOpenInEditor = new Action(){

            public void run() {
                ISelection selection = ApiCompareView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ProjectComparisonEntry) {
                    ApiCompareView.this.showInEditor((ProjectComparisonEntry)obj, true, true);
                }
            }
        };
        this.actionOpenInEditor.setText("Open in Editor");
        this.actionOpenInEditor.setToolTipText("Open the currently selected API element and its implementations in N4JS editors.");
    }

    private void updateComparison() {
        this.viewer.setComparison();
    }

    private void showInEditor(ProjectComparisonEntry entry, boolean showApi, boolean showImpl) {
        EObject[] elemImpls;
        EObject elemApi;
        if (showApi && (elemApi = entry.getElementAPI()) != null) {
            this.showInEditor(elemApi);
        }
        if (showImpl && (elemImpls = entry.getElementImpl()) != null) {
            EObject[] eObjectArray = elemImpls;
            int n = elemImpls.length;
            int n2 = 0;
            while (n2 < n) {
                EObject elemImpl = eObjectArray[n2];
                if (elemImpl != null) {
                    this.showInEditor(elemImpl);
                }
                ++n2;
            }
        }
    }

    private void showInEditor(EObject eobj) {
        Resource res = eobj.eResource();
        URI uriBase = res.getURI();
        String frag = res.getURIFragment(eobj);
        URI uri = uriBase.appendFragment(frag);
        this.uriOpener.open(uri, true);
    }

    private void hookDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ApiCompareView.this.actionOpenInEditor.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

