/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.StaticPolyfillValidatorExtension;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSInterfaceValidator
extends AbstractN4JSDeclarativeValidator {
    public static final String STATIC_MEMBER_IN_ROLE = "STATIC_MEMBER_IN_ROLE";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkN4InterfaceDeclaration(N4InterfaceDeclaration n4Interface) {
        boolean _tripleEquals;
        Type _definedType = n4Interface.getDefinedType();
        boolean bl = _tripleEquals = _definedType == null;
        if (_tripleEquals) {
            return;
        }
        this.holdsNoCyclicInheritance(n4Interface);
        this.internalCheckExtendedInterfaces(n4Interface);
        this.internalCheckNotFinal(n4Interface);
        this.getInternalCheckNoFieldInitizializer(n4Interface);
        StaticPolyfillValidatorExtension.internalCheckNotInStaticPolyfillModule(n4Interface, this);
    }

    public void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, issueCode, issueData);
    }

    private void internalCheckNotFinal(N4InterfaceDeclaration n4InterfaceDeclaration) {
        boolean _hasAnnotation = AnnotationDefinition.FINAL.hasAnnotation((AnnotableElement)n4InterfaceDeclaration);
        if (_hasAnnotation) {
            String msg = IssueCodes.getMessageForITF_NO_FINAL();
            this.addIssue(msg, (EObject)n4InterfaceDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "ITF_NO_FINAL", new String[0]);
        }
    }

    private void getInternalCheckNoFieldInitizializer(N4InterfaceDeclaration n4Interface) {
        boolean _tripleEquals;
        TypingStrategy _typingStrategy = n4Interface.getTypingStrategy();
        boolean bl = _tripleEquals = _typingStrategy == TypingStrategy.STRUCTURAL;
        if (_tripleEquals) {
            Consumer<N4FieldDeclaration> _function = f -> {
                boolean _tripleNotEquals;
                Expression _expression = f.getExpression();
                boolean bl = _tripleNotEquals = _expression != null;
                if (_tripleNotEquals) {
                    this.addIssue(IssueCodes.getMessageForITF_NO_FIELD_INITIALIZER(f.getName(), n4Interface.getName()), (EObject)f.getExpression(), "ITF_NO_FIELD_INITIALIZER");
                }
            };
            n4Interface.getOwnedFields().forEach(_function);
        }
    }

    private void internalCheckExtendedInterfaces(N4InterfaceDeclaration n4Interface) {
        Consumer<ParameterizedTypeRef> _function = it -> {
            Type extendedType = it.getDeclaredType();
            if (extendedType != null && extendedType.getName() != null && !(extendedType instanceof TInterface)) {
                if (extendedType instanceof PrimitiveType) {
                    String message = IssueCodes.getMessageForCLF_EXTENDS_PRIMITIVE_GENERIC_TYPE(((PrimitiveType)extendedType).getName());
                    this.addIssue(message, (EObject)it, null, "CLF_EXTENDS_PRIMITIVE_GENERIC_TYPE", new String[0]);
                } else {
                    String message_1 = IssueCodes.getMessageForCLF_WRONG_META_TYPE(this.validatorMessageHelper.description((EObject)n4Interface), "extend", this.validatorMessageHelper.description((EObject)extendedType));
                    this.addIssue(message_1, (EObject)it, null, "CLF_WRONG_META_TYPE", new String[0]);
                }
            }
        };
        n4Interface.getSuperInterfaceRefs().forEach(_function);
    }

    private boolean holdsNoCyclicInheritance(N4InterfaceDeclaration n4InterfaceDeclaration) {
        Type _definedType = n4InterfaceDeclaration.getDefinedType();
        TInterface ifc = (TInterface)_definedType;
        List<TClassifier> cycle = this.findCyclicInheritance((TClassifier)ifc);
        if (cycle != null) {
            Functions.Function1 _function = it -> {
                TClassifier _get;
                Type _declaredType = it.getDeclaredType();
                return _declaredType == (_get = (TClassifier)cycle.get(1));
            };
            ParameterizedTypeRef miscreant = (ParameterizedTypeRef)IterableExtensions.findFirst((Iterable)n4InterfaceDeclaration.getSuperInterfaceRefs(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> it.getName();
            String message = IssueCodes.getMessageForCLF_INHERITANCE_CYCLE(IterableExtensions.join((Iterable)ListExtensions.map(cycle, (Functions.Function1)_function_1), (CharSequence)", "));
            this.addIssue(message, (EObject)miscreant, "CLF_INHERITANCE_CYCLE");
            return false;
        }
        return true;
    }
}

