/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Encoder {
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static String base64Encode(String s) throws IOException {
        return Base64Encoder.encode(s.getBytes(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] in, int len) throws IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            bais = new ByteArrayInputStream(in);
            Base64Encoder.encode(bais, baos, len);
            String string = new String(baos.toByteArray());
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static void encode(InputStream in, OutputStream out, int len) throws IOException {
        int b;
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int bits = 0;
        int nbits = 0;
        int nbytes = 0;
        while ((b = in.read()) != -1) {
            bits = bits << 8 | b;
            nbits += 8;
            while (nbits >= 6) {
                out.write(encTab[0x3F & bits >> (nbits -= 6)]);
                if (len == 0 || ++nbytes < len) continue;
                out.write(13);
                out.write(10);
                nbytes -= len;
            }
        }
        switch (nbits) {
            case 2: {
                out.write(encTab[0x3F & bits << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 4: {
                out.write(encTab[0x3F & bits << 2]);
                out.write(61);
            }
        }
        if (len != 0) {
            if (nbytes != 0) {
                out.write(13);
                out.write(10);
            }
            out.write(13);
            out.write(10);
        }
    }
}

