/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.EcoreUtil2;

public class FunctionValidationHelper {
    public static <T extends EObject> void internalCheckFormalParameters(T[] fpars, Predicate<T> variadic, Predicate<T> hasInitAssgn, Function<T, String> name, TripleConsumer<String, String, EObject> issueConsumer) {
        List<EObject> fparsL = Arrays.asList(fpars);
        for (EObject fPar : fparsL) {
            boolean isInFunctionDefinition = fPar.eContainer() instanceof FunctionDefinition;
            if (!isInFunctionDefinition) {
                FunctionValidationHelper.internalCheckFormalParameter(fparsL, fPar, variadic, hasInitAssgn, issueConsumer);
            }
            if (!hasInitAssgn.test(fPar)) continue;
            int fpPos = fparsL.indexOf(fPar);
            List irs = EcoreUtil2.getAllContentsOfType((EObject)fPar, IdentifierRef.class);
            for (IdentifierRef ir : irs) {
                if (fparsL.indexOf(ir.getId()) < fpPos) continue;
                String msg = IssueCodes.getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE();
                issueConsumer.accept(msg, "FUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE", (EObject)ir);
            }
            List awaits = EcoreUtil2.getAllContentsOfType((EObject)fPar, AwaitExpression.class);
            if (awaits.isEmpty()) continue;
            String paramName = "";
            if (fPar instanceof TFormalParameter) {
                paramName = ((TFormalParameter)fPar).getName();
            }
            if (fPar instanceof FormalParameter) {
                paramName = ((FormalParameter)fPar).getName();
            }
            for (AwaitExpression await : awaits) {
                String msg = IssueCodes.getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL(paramName);
                issueConsumer.accept(msg, "FUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL", (EObject)await);
            }
        }
        boolean initAssgnVisited = false;
        Iterator<EObject> iter = fparsL.iterator();
        while (iter.hasNext() && !initAssgnVisited) {
            initAssgnVisited = hasInitAssgn.test(iter.next());
        }
        while (initAssgnVisited && iter.hasNext()) {
            EObject fpar = iter.next();
            if (hasInitAssgn.test(fpar) || variadic.test(fpar)) continue;
            String msg = IssueCodes.getMessageForFUN_PARAM_IMPLICIT_DEFAULT_PARAM(name.apply(fpar));
            issueConsumer.accept(msg, "FUN_PARAM_IMPLICIT_DEFAULT_PARAM", fpar);
        }
    }

    public static <T extends EObject> void internalCheckFormalParameter(List<T> fPars, T fPar, Predicate<T> variadic, Predicate<T> hasInitAssgn, TripleConsumer<String, String, EObject> issueConsumer) {
        if (variadic.test(fPar)) {
            String msg;
            int fpPos = fPars.indexOf(fPar);
            if (fpPos != fPars.size() - 1) {
                msg = IssueCodes.getMessageForFUN_PARAM_VARIADIC_ONLY_LAST();
                issueConsumer.accept(msg, "FUN_PARAM_VARIADIC_ONLY_LAST", fPar);
            }
            if (hasInitAssgn.test(fPar)) {
                msg = IssueCodes.getMessageForFUN_PARAM_VARIADIC_WITH_INITIALIZER();
                issueConsumer.accept(msg, "FUN_PARAM_VARIADIC_WITH_INITIALIZER", fPar);
            }
        }
    }

    public static interface TripleConsumer<U, V, W> {
        public void accept(U var1, V var2, W var3);
    }
}

