/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compileTime;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compileTime.CompileTimeEvaluationError;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.MultiplicativeOperator;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TConstableElement;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CompileTimeEvaluator {
    @Inject
    private N4JSElementKeywordProvider keywordProvider;

    public CompileTimeValue evaluateCompileTimeExpression(RuleEnvironment G, Expression expr) {
        RecursionGuard _recursionGuard = new RecursionGuard();
        return this.eval(G, expr, (RecursionGuard<EObject>)_recursionGuard);
    }

    private CompileTimeValue _eval(RuleEnvironment G, Expression expr, RecursionGuard<EObject> guard) {
        String _keywordWithIndefiniteArticle = this.keywordProvider.keywordWithIndefiniteArticle((EObject)expr);
        String _plus = String.valueOf(_keywordWithIndefiniteArticle) + " is never a compile-time expression";
        return CompileTimeValue.error(_plus, (EObject)expr);
    }

    private CompileTimeValue _eval(RuleEnvironment G, ParenExpression expr, RecursionGuard<EObject> guard) {
        boolean _tripleEquals;
        Expression _expression = expr.getExpression();
        boolean bl = _tripleEquals = _expression == null;
        if (_tripleEquals) {
            return CompileTimeValue.error();
        }
        return this.eval(G, expr.getExpression(), guard);
    }

    private CompileTimeValue _eval(RuleEnvironment G, NullLiteral expr, RecursionGuard<EObject> guard) {
        return CompileTimeValue.NULL;
    }

    private CompileTimeValue _eval(RuleEnvironment G, BooleanLiteral expr, RecursionGuard<EObject> guard) {
        return CompileTimeValue.of(expr.isTrue());
    }

    private CompileTimeValue _eval(RuleEnvironment G, NumericLiteral expr, RecursionGuard<EObject> guard) {
        return CompileTimeValue.of(expr.getValue());
    }

    private CompileTimeValue _eval(RuleEnvironment G, StringLiteral expr, RecursionGuard<EObject> guard) {
        return CompileTimeValue.of(expr.getValue());
    }

    private CompileTimeValue _eval(RuleEnvironment G, TemplateSegment expr, RecursionGuard<EObject> guard) {
        return CompileTimeValue.of(expr.getValue());
    }

    private CompileTimeValue _eval(RuleEnvironment G, TemplateLiteral expr, RecursionGuard<EObject> guard) {
        boolean _not;
        StringBuilder buff = new StringBuilder();
        ArrayList invalidValues = CollectionLiterals.newArrayList();
        EList _segments = expr.getSegments();
        for (Expression seg : _segments) {
            CompileTimeValue segValue = this.eval(G, seg, guard);
            boolean _isValid = segValue.isValid();
            if (_isValid) {
                buff.append(segValue.toString());
                continue;
            }
            invalidValues.add(segValue);
        }
        boolean _isEmpty = invalidValues.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return CompileTimeValue.combineErrors((CompileTimeValue[])Conversions.unwrapArray((Object)invalidValues, CompileTimeValue.class));
        }
        return CompileTimeValue.of(buff.toString());
    }

    private CompileTimeValue _eval(RuleEnvironment G, UnaryExpression expr, RecursionGuard<EObject> guard) {
        boolean _tripleNotEquals;
        CompileTimeValue _xifexpression = null;
        Expression _expression = expr.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            _xifexpression = this.eval(G, expr.getExpression(), guard);
        }
        CompileTimeValue value = _xifexpression;
        CompileTimeValue _switchResult = null;
        UnaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case NOT: {
                    _switchResult = CompileTimeValue.invert(value, (EObject)expr.getExpression());
                    break;
                }
                case POS: {
                    CompileTimeValue _elvis = null;
                    CompileTimeValue.ValueInvalid _requireValueType = CompileTimeValue.requireValueType(value, CompileTimeValue.ValueNumber.class, "operand must be a number", (EObject)expr.getExpression());
                    _elvis = _requireValueType != null ? _requireValueType : value;
                    _switchResult = _elvis;
                    break;
                }
                case NEG: {
                    _switchResult = CompileTimeValue.negate(value, (EObject)expr.getExpression());
                    break;
                }
                case VOID: {
                    _switchResult = CompileTimeValue.UNDEFINED;
                    break;
                }
                default: {
                    UnaryOperator _op_1 = expr.getOp();
                    String _plus = "invalid operator: " + _op_1;
                    _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
                    break;
                }
            }
        } else {
            UnaryOperator _op_1 = expr.getOp();
            String _plus = "invalid operator: " + _op_1;
            _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
        }
        return _switchResult;
    }

    private CompileTimeValue _eval(RuleEnvironment G, AdditiveExpression expr, RecursionGuard<EObject> guard) {
        Expression lhs = expr.getLhs();
        Expression rhs = expr.getRhs();
        CompileTimeValue _xifexpression = null;
        if (lhs != null) {
            _xifexpression = this.eval(G, lhs, guard);
        }
        CompileTimeValue leftValue = _xifexpression;
        CompileTimeValue _xifexpression_1 = null;
        if (rhs != null) {
            _xifexpression_1 = this.eval(G, rhs, guard);
        }
        CompileTimeValue rightValue = _xifexpression_1;
        CompileTimeValue _switchResult = null;
        AdditiveOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case ADD: {
                    _switchResult = CompileTimeValue.add(leftValue, rightValue, (EObject)expr);
                    break;
                }
                case SUB: {
                    _switchResult = CompileTimeValue.subtract(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                default: {
                    AdditiveOperator _op_1 = expr.getOp();
                    String _plus = "invalid operator: " + _op_1;
                    _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
                    break;
                }
            }
        } else {
            AdditiveOperator _op_1 = expr.getOp();
            String _plus = "invalid operator: " + _op_1;
            _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
        }
        return _switchResult;
    }

    private CompileTimeValue _eval(RuleEnvironment G, MultiplicativeExpression expr, RecursionGuard<EObject> guard) {
        Expression lhs = expr.getLhs();
        Expression rhs = expr.getRhs();
        CompileTimeValue _xifexpression = null;
        if (lhs != null) {
            _xifexpression = this.eval(G, lhs, guard);
        }
        CompileTimeValue leftValue = _xifexpression;
        CompileTimeValue _xifexpression_1 = null;
        if (rhs != null) {
            _xifexpression_1 = this.eval(G, rhs, guard);
        }
        CompileTimeValue rightValue = _xifexpression_1;
        CompileTimeValue _switchResult = null;
        MultiplicativeOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case TIMES: {
                    _switchResult = CompileTimeValue.multiply(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                case DIV: {
                    _switchResult = CompileTimeValue.divide(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                case MOD: {
                    _switchResult = CompileTimeValue.remainder(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                default: {
                    MultiplicativeOperator _op_1 = expr.getOp();
                    String _plus = "invalid operator: " + _op_1;
                    _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
                    break;
                }
            }
        } else {
            MultiplicativeOperator _op_1 = expr.getOp();
            String _plus = "invalid operator: " + _op_1;
            _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
        }
        return _switchResult;
    }

    private CompileTimeValue _eval(RuleEnvironment G, BinaryLogicalExpression expr, RecursionGuard<EObject> guard) {
        Expression lhs = expr.getLhs();
        Expression rhs = expr.getRhs();
        CompileTimeValue _xifexpression = null;
        if (lhs != null) {
            _xifexpression = this.eval(G, lhs, guard);
        }
        CompileTimeValue leftValue = _xifexpression;
        CompileTimeValue _xifexpression_1 = null;
        if (rhs != null) {
            _xifexpression_1 = this.eval(G, rhs, guard);
        }
        CompileTimeValue rightValue = _xifexpression_1;
        CompileTimeValue _switchResult = null;
        BinaryLogicalOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case AND: {
                    _switchResult = CompileTimeValue.and(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                case OR: {
                    _switchResult = CompileTimeValue.or(leftValue, rightValue, (EObject)lhs, (EObject)rhs);
                    break;
                }
                default: {
                    BinaryLogicalOperator _op_1 = expr.getOp();
                    String _plus = "invalid operator: " + _op_1;
                    _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
                    break;
                }
            }
        } else {
            BinaryLogicalOperator _op_1 = expr.getOp();
            String _plus = "invalid operator: " + _op_1;
            _switchResult = CompileTimeValue.error(_plus, (EObject)expr);
        }
        return _switchResult;
    }

    private CompileTimeValue _eval(RuleEnvironment G, ConditionalExpression expr, RecursionGuard<EObject> guard) {
        Expression condition = expr.getExpression();
        Expression trueExpr = expr.getTrueExpression();
        Expression falseExpr = expr.getFalseExpression();
        CompileTimeValue _xifexpression = null;
        if (condition != null) {
            _xifexpression = this.eval(G, condition, guard);
        }
        CompileTimeValue conditionValue = _xifexpression;
        CompileTimeValue _xifexpression_1 = null;
        if (trueExpr != null) {
            _xifexpression_1 = this.eval(G, trueExpr, guard);
        }
        CompileTimeValue trueValue = _xifexpression_1;
        CompileTimeValue _xifexpression_2 = null;
        if (falseExpr != null) {
            _xifexpression_2 = this.eval(G, falseExpr, guard);
        }
        CompileTimeValue falseValue = _xifexpression_2;
        CompileTimeValue.ValueInvalid error = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(conditionValue, CompileTimeValue.ValueBoolean.class, "condition must be a boolean", (EObject)expr.getExpression()), trueValue, falseValue);
        if (error != null) {
            return error;
        }
        CompileTimeValue _xifexpression_3 = null;
        Boolean _value = (Boolean)((CompileTimeValue.ValueBoolean)conditionValue).getValue();
        _xifexpression_3 = _value != false ? trueValue : falseValue;
        return _xifexpression_3;
    }

    private CompileTimeValue _eval(RuleEnvironment G, IdentifierRef expr, RecursionGuard<EObject> guard) {
        boolean _isUndefinedLiteral = N4JSLanguageUtils.isUndefinedLiteral(G, (Expression)expr);
        if (_isUndefinedLiteral) {
            return CompileTimeValue.UNDEFINED;
        }
        IdentifiableElement id = expr.getId();
        if (id != null && !id.eIsProxy()) {
            return this.obtainValueIfConstFieldOrVariable(G, id, (EObject)expr, guard);
        }
        return CompileTimeValue.error();
    }

    private CompileTimeValue _eval(RuleEnvironment G, ParameterizedPropertyAccessExpression expr, RecursionGuard<EObject> guard) {
        Expression targetExpr = expr.getTarget();
        IdentifiableElement _xifexpression = null;
        if (targetExpr instanceof IdentifierRef) {
            _xifexpression = ((IdentifierRef)targetExpr).getId();
        }
        IdentifiableElement targetElem = _xifexpression;
        String propName = expr.getPropertyAsText();
        TObjectPrototype sym = RuleEnvironmentExtensions.symbolObjectType(G);
        if (targetElem == sym) {
            TField memberInSym = N4JSLanguageUtils.getAccessedBuiltInSymbol(G, (Expression)expr, false);
            if (memberInSym != null) {
                return CompileTimeValue.of(memberInSym);
            }
        } else if (targetElem instanceof TEnum) {
            boolean _hasAnnotation = AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)targetElem);
            if (_hasAnnotation) {
                Functions.Function1 _function = it -> {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)propName);
                };
                TEnumLiteral litInEnum = (TEnumLiteral)IterableExtensions.findFirst((Iterable)((TEnum)targetElem).getLiterals(), (Functions.Function1)_function);
                if (litInEnum != null) {
                    return CompileTimeValue.of(litInEnum.getValueOrName());
                }
            }
        } else if (targetElem instanceof TClassifier) {
            Functions.Function1 _function_1 = it -> Objects.equal((Object)it.getName(), (Object)propName) && it.isReadable() && it.isStatic();
            TMember member = (TMember)IterableExtensions.findFirst((Iterable)IterableExtensions.filterNull((Iterable)((TClassifier)targetElem).getOwnedMembers()), (Functions.Function1)_function_1);
            if (member instanceof TField && !((TField)member).isHasComputedName()) {
                return this.obtainValueIfConstFieldOrVariable(G, (IdentifiableElement)member, (EObject)expr, guard);
            }
            UnresolvedPropertyAccessError _unresolvedPropertyAccessError = new UnresolvedPropertyAccessError(expr);
            return CompileTimeValue.error(_unresolvedPropertyAccessError);
        }
        if (targetElem != sym && !(targetElem instanceof TClassifier) && !(targetElem instanceof TEnum)) {
            return CompileTimeValue.error("target of a property access must be a direct reference to a class, interface, or enum", (EObject)expr, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Target());
        }
        return CompileTimeValue.error("property access must point to const fields, literals of @StringBased enums, or built-in symbols", (EObject)expr);
    }

    private CompileTimeValue obtainValueIfConstFieldOrVariable(RuleEnvironment G, IdentifiableElement targetElem, EObject astNodeForErrorMessage, RecursionGuard<EObject> guard) {
        boolean _tryNext = guard.tryNext((Object)targetElem);
        if (_tryNext) {
            try {
                CompileTimeValue compileTimeValue = this.obtainValueIfConstFieldOrVariableUnguarded(G, targetElem, astNodeForErrorMessage, guard);
                return compileTimeValue;
            }
            finally {
                guard.done((Object)targetElem);
            }
        }
        return CompileTimeValue.error("cyclic definition of compile-time expression", astNodeForErrorMessage);
    }

    private CompileTimeValue obtainValueIfConstFieldOrVariableUnguarded(RuleEnvironment G, IdentifiableElement targetElem, EObject astNodeForErrorMessage, RecursionGuard<EObject> guard) {
        boolean targetElemIsConst;
        boolean _switchResult = false;
        boolean _matched = false;
        if (targetElem instanceof TConstableElement) {
            _matched = true;
            _switchResult = ((TConstableElement)targetElem).isConst();
        }
        if (!_matched && targetElem instanceof N4FieldDeclaration) {
            _matched = true;
            _switchResult = ((N4FieldDeclaration)targetElem).isConst();
        }
        if (!_matched && targetElem instanceof VariableDeclaration) {
            _matched = true;
            _switchResult = ((VariableDeclaration)targetElem).isConst();
        }
        if (!(targetElemIsConst = _switchResult)) {
            String _keyword = this.keywordProvider.keyword(targetElem);
            String _plus = String.valueOf(_keyword) + " ";
            String _name = targetElem.getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            String _plus_2 = String.valueOf(_plus_1) + " is not const";
            return CompileTimeValue.error(_plus_2, astNodeForErrorMessage);
        }
        CompileTimeValue valueOfTargetElem = this.obtainCompileTimeValueOfTargetElement(G, astNodeForErrorMessage.eResource(), targetElem, guard);
        if (valueOfTargetElem != null) {
            if (valueOfTargetElem instanceof CompileTimeValue.ValueInvalid) {
                String _keyword_1 = this.keywordProvider.keyword(targetElem);
                String _plus_3 = String.valueOf(_keyword_1) + " ";
                String _name_1 = targetElem.getName();
                String _plus_4 = String.valueOf(_plus_3) + _name_1;
                String baseMsg = String.valueOf(_plus_4) + " is const but does not have a compile-time expression as initializer";
                String msg = CompileTimeEvaluator.combineErrorMessageWithNestedErrors(baseMsg, (CompileTimeEvaluationError[])Conversions.unwrapArray(((CompileTimeValue.ValueInvalid)valueOfTargetElem).getErrors(), CompileTimeEvaluationError.class));
                EReference _xifexpression = null;
                if (astNodeForErrorMessage instanceof ParameterizedPropertyAccessExpression) {
                    _xifexpression = N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property();
                }
                EReference feature = _xifexpression;
                return CompileTimeValue.error(msg, astNodeForErrorMessage, (EStructuralFeature)feature);
            }
            return valueOfTargetElem;
        }
        return CompileTimeValue.error("only references to const variables with a compile-time expression as initializer are allowed", astNodeForErrorMessage);
    }

    private CompileTimeValue obtainCompileTimeValueOfTargetElement(RuleEnvironment G, Resource currentResource, IdentifiableElement targetElem, RecursionGuard<EObject> guard) {
        if (targetElem.eResource() == currentResource || CompileTimeEvaluator.hasLoadedASTElement(targetElem)) {
            Expression expressionOfTargetElem;
            Object _xifexpression = null;
            _xifexpression = targetElem instanceof SyntaxRelatedTElement ? ((SyntaxRelatedTElement)targetElem).getAstElement() : targetElem;
            IdentifiableElement astNodeOfTargetElem = _xifexpression;
            Expression _switchResult = null;
            boolean _matched = false;
            if (astNodeOfTargetElem instanceof N4FieldDeclaration) {
                _matched = true;
                _switchResult = ((N4FieldDeclaration)astNodeOfTargetElem).getExpression();
            }
            if (!_matched && astNodeOfTargetElem instanceof VariableDeclaration) {
                _matched = true;
                _switchResult = ((VariableDeclaration)astNodeOfTargetElem).getExpression();
            }
            if ((expressionOfTargetElem = _switchResult) != null) {
                return this.eval(G, expressionOfTargetElem, guard);
            }
        } else if (targetElem instanceof TConstableElement) {
            return CompileTimeValue.deserialize(((TConstableElement)targetElem).getCompileTimeValue());
        }
        return null;
    }

    private static boolean hasLoadedASTElement(IdentifiableElement elem) {
        EObject astElemNonResolved;
        EObject _xifexpression = null;
        if (elem instanceof SyntaxRelatedTElement) {
            Object _eGet = elem.eGet((EStructuralFeature)TypesPackage.eINSTANCE.getSyntaxRelatedTElement_AstElement(), false);
            _xifexpression = (EObject)_eGet;
        }
        return (astElemNonResolved = _xifexpression) != null && !astElemNonResolved.eIsProxy();
    }

    private static String combineErrorMessageWithNestedErrors(String mainMessage, CompileTimeEvaluationError ... nestedErrors) {
        boolean _equals_1;
        boolean _equals;
        int _length = nestedErrors.length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return mainMessage;
        }
        int _length_1 = nestedErrors.length;
        boolean bl2 = _equals_1 = _length_1 == 1;
        if (_equals_1) {
            String _messageWithLocation = nestedErrors[0].getMessageWithLocation();
            return String.valueOf(mainMessage) + ": " + _messageWithLocation;
        }
        Functions.Function1 _function = it -> it.getMessageWithLocation();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)nestedErrors)), (Functions.Function1)_function), (CharSequence)"\n- ");
        return String.valueOf(mainMessage) + ":\n- " + _join;
    }

    private CompileTimeValue eval(RuleEnvironment G, Expression expr, RecursionGuard<EObject> guard) {
        if (expr instanceof BooleanLiteral) {
            return this._eval(G, (BooleanLiteral)expr, guard);
        }
        if (expr instanceof NullLiteral) {
            return this._eval(G, (NullLiteral)expr, guard);
        }
        if (expr instanceof NumericLiteral) {
            return this._eval(G, (NumericLiteral)expr, guard);
        }
        if (expr instanceof StringLiteral) {
            return this._eval(G, (StringLiteral)expr, guard);
        }
        if (expr instanceof TemplateSegment) {
            return this._eval(G, (TemplateSegment)expr, guard);
        }
        if (expr instanceof IdentifierRef) {
            return this._eval(G, (IdentifierRef)expr, guard);
        }
        if (expr instanceof ParenExpression) {
            return this._eval(G, (ParenExpression)expr, guard);
        }
        if (expr instanceof TemplateLiteral) {
            return this._eval(G, (TemplateLiteral)expr, guard);
        }
        if (expr instanceof AdditiveExpression) {
            return this._eval(G, (AdditiveExpression)expr, guard);
        }
        if (expr instanceof BinaryLogicalExpression) {
            return this._eval(G, (BinaryLogicalExpression)expr, guard);
        }
        if (expr instanceof ConditionalExpression) {
            return this._eval(G, (ConditionalExpression)expr, guard);
        }
        if (expr instanceof MultiplicativeExpression) {
            return this._eval(G, (MultiplicativeExpression)expr, guard);
        }
        if (expr instanceof ParameterizedPropertyAccessExpression) {
            return this._eval(G, (ParameterizedPropertyAccessExpression)expr, guard);
        }
        if (expr instanceof UnaryExpression) {
            return this._eval(G, (UnaryExpression)expr, guard);
        }
        if (expr != null) {
            return this._eval(G, expr, guard);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, expr, guard).toString());
    }

    public static final class UnresolvedPropertyAccessError
    extends CompileTimeEvaluationError {
        public UnresolvedPropertyAccessError(ParameterizedPropertyAccessExpression astNode) {
            super("*** UnresolvedPropertyAccessError ***", (EObject)astNode, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property());
        }

        public ParameterizedPropertyAccessExpression getAstNodeCasted() {
            return (ParameterizedPropertyAccessExpression)this.astNode;
        }
    }
}

