/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    public static final double MIN_LON_RADIANS = -Math.PI;
    public static final double MIN_LAT_RADIANS = -1.5707963267948966;
    public static final double MAX_LON_RADIANS = Math.PI;
    public static final double MAX_LAT_RADIANS = 1.5707963267948966;
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.7714;
    private static final double PIO2 = 1.5707963267948966;

    private GeoUtils() {
    }

    public static void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between " + -90.0 + " and " + 90.0);
        }
    }

    public static void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between " + -180.0 + " and " + 180.0);
        }
    }

    public static double sloppySin(double a) {
        return SloppyMath.cos(a - 1.5707963267948966);
    }

    public static double distanceQuerySortKey(double radius) {
        if (radius >= SloppyMath.haversinMeters(Double.MAX_VALUE)) {
            return SloppyMath.haversinMeters(Double.MAX_VALUE);
        }
        long lo = 0L;
        long hi = Double.doubleToRawLongBits(Double.MAX_VALUE);
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            double sortKey = Double.longBitsToDouble(mid);
            double midRadius = SloppyMath.haversinMeters(sortKey);
            if (midRadius == radius) {
                return sortKey;
            }
            if (midRadius > radius) {
                hi = mid - 1L;
                continue;
            }
            lo = mid + 1L;
        }
        double ceil = Double.longBitsToDouble(lo);
        assert (SloppyMath.haversinMeters(ceil) > radius);
        return ceil;
    }

    public static PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon, double lat, double lon, double distanceSortKey, double axisLat) {
        if (minLon > maxLon) {
            throw new IllegalArgumentException("Box crosses the dateline");
        }
        if ((lon < minLon || lon > maxLon) && (axisLat + 8.993203677616636E-7 < minLat || axisLat - 8.993203677616636E-7 > maxLat) && SloppyMath.haversinSortKey(lat, lon, minLat, minLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, minLat, maxLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, minLon) > distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, maxLon) > distanceSortKey) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (GeoUtils.within90LonDegrees(lon, minLon, maxLon) && SloppyMath.haversinSortKey(lat, lon, minLat, minLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, minLat, maxLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, minLon) <= distanceSortKey && SloppyMath.haversinSortKey(lat, lon, maxLat, maxLon) <= distanceSortKey) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    static boolean within90LonDegrees(double lon, double minLon, double maxLon) {
        if (maxLon <= lon - 180.0) {
            lon -= 360.0;
        } else if (minLon >= lon + 180.0) {
            lon += 360.0;
        }
        return maxLon - lon < 90.0 && lon - minLon < 90.0;
    }
}

