/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.workspace;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.workspace.IResourceFactory;
import org.eclipse.xpect.xtext.lib.setup.workspace.Resource;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;

public class Container<C extends IContainer>
extends Resource<C> {
    private final List<IResourceFactory<?, ? super C>> memberFactories = Lists.newArrayList();

    public void add(IResourceFactory<?, ? super C> factory) {
        this.memberFactories.add(factory);
    }

    protected void createMembers(FileSetupContext ctx, C container, Workspace.Instance instance) throws IOException, CoreException {
        for (IResourceFactory<?, C> factory : this.memberFactories) {
            factory.create(ctx, container, instance);
        }
    }

    public List<IResourceFactory<?, ? super C>> getMemberFactories() {
        return this.memberFactories;
    }

    public <T extends IResourceFactory<?, ?>> List<T> getMembers(Class<T> type) {
        ArrayList result = Lists.newArrayList();
        for (IResourceFactory<?, ? super C> iResourceFactory : this.memberFactories) {
            if (!type.isInstance(iResourceFactory)) continue;
            result.add(iResourceFactory);
        }
        return result;
    }

    public <T extends IResourceFactory<?, ?>> T getMember(Class<T> type) {
        for (IResourceFactory<?, ? super C> iResourceFactory : this.memberFactories) {
            if (!type.isInstance(iResourceFactory)) continue;
            return (T)iResourceFactory;
        }
        return null;
    }
}

