/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.packagejson.PackageJsonHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.RunnerHelper;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.tester.TestCatalogSupplier;
import org.eclipse.n4js.tester.TestDiscoveryHelper;
import org.eclipse.n4js.tester.TestTreeRegistry;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.TesterFacade;
import org.eclipse.n4js.tester.TesterFileBasedShippedCodeConfigurationHelper;
import org.eclipse.n4js.tester.TesterFrontEnd;
import org.eclipse.n4js.tester.TesterModuleDefaults;
import org.eclipse.n4js.tester.UrlDecoderService;
import org.eclipse.n4js.tester.extension.TesterRegistry;
import org.eclipse.n4js.tester.fsm.TestFsm;
import org.eclipse.n4js.tester.fsm.TestFsmImpl;
import org.eclipse.n4js.tester.fsm.TestFsmRegistry;
import org.eclipse.n4js.tester.fsm.TestFsmRegistryImpl;
import org.eclipse.n4js.tester.internal.DefaultTestTreeTransformer;
import org.eclipse.n4js.tester.internal.InternalTestTreeRegistry;
import org.eclipse.n4js.tester.internal.TestTreeRegistryImpl;
import org.eclipse.n4js.tester.internal.TesterFacadeImpl;
import org.eclipse.n4js.tester.internal.Utf8UrlDecoderService;
import org.eclipse.n4js.tester.server.HttpServerManager;
import org.eclipse.n4js.tester.server.JettyManager;
import org.eclipse.n4js.tester.server.resources.ResourceProvider;
import org.eclipse.n4js.tester.server.resources.ServletHolderBuilder;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4ExecutableExtensionFactory;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.n4js.utils.StatusHelper;

public class TesterModule
implements Module {
    private static final Logger LOGGER = Logger.getLogger(TesterModule.class);
    private final Injector n4jsInjector;

    public TesterModule(Injector n4jsInjector) {
        this.n4jsInjector = n4jsInjector;
    }

    public TesterModule() {
        this.n4jsInjector = null;
    }

    public void configure(Binder binder) {
        if (this.n4jsInjector != null) {
            this.bindListenerForN4jsSingletons(binder);
            binder.bind(ObjectMapper.class).toProvider(() -> (ObjectMapper)this.n4jsInjector.getInstance(ObjectMapper.class));
            binder.bind(RunnerFrontEnd.class).toProvider(() -> (RunnerFrontEnd)this.n4jsInjector.getInstance(RunnerFrontEnd.class));
            binder.bind(FileExtensionsRegistry.class).toProvider(() -> (FileExtensionsRegistry)this.n4jsInjector.getInstance(FileExtensionsRegistry.class));
            binder.bind(IN4JSCore.class).toProvider(() -> (IN4JSCore)this.n4jsInjector.getInstance(IN4JSCore.class));
            binder.bind(ResourceNameComputer.class).toProvider(() -> (ResourceNameComputer)this.n4jsInjector.getInstance(ResourceNameComputer.class));
            binder.bind(ContainerTypesHelper.class).toProvider(() -> (ContainerTypesHelper)this.n4jsInjector.getInstance(ContainerTypesHelper.class));
            binder.bind(N4ExecutableExtensionFactory.class).toProvider(() -> (N4ExecutableExtensionFactory)this.n4jsInjector.getInstance(N4ExecutableExtensionFactory.class));
            binder.bind(RunnerHelper.class).toProvider(() -> (RunnerHelper)this.n4jsInjector.getInstance(RunnerHelper.class));
            binder.bind(RunnerRegistry.class).toProvider(() -> (RunnerRegistry)this.n4jsInjector.getInstance(RunnerRegistry.class));
            binder.bind(StatusHelper.class).toProvider(() -> (StatusHelper)this.n4jsInjector.getInstance(StatusHelper.class));
            binder.bind(ProjectDescriptionLoader.class).toProvider(() -> (ProjectDescriptionLoader)this.n4jsInjector.getInstance(ProjectDescriptionLoader.class));
            binder.bind(PackageJsonHelper.class).toProvider(() -> (PackageJsonHelper)this.n4jsInjector.getInstance(PackageJsonHelper.class));
        }
        binder.bind(TesterRegistry.class);
        binder.bind(TesterEventBus.class);
        binder.bind(TesterFrontEnd.class);
        binder.bind(ResourceProvider.class);
        binder.bind(TestDiscoveryHelper.class);
        binder.bind(TestCatalogSupplier.class);
        binder.bind(ServletHolderBuilder.class);
        binder.bind(DefaultTestTreeTransformer.class);
        binder.bind(TesterFileBasedShippedCodeConfigurationHelper.class);
        binder.bind(TestFsm.class).to(TestFsmImpl.class);
        binder.bind(HttpServerManager.class).to(JettyManager.class);
        binder.bind(TestFsmRegistry.class).to(TestFsmRegistryImpl.class);
        binder.bind(TesterFacade.class).to(TesterFacadeImpl.class);
        binder.bind(TestTreeRegistry.class).to(InternalTestTreeRegistry.class);
        binder.bind(InternalTestTreeRegistry.class).to(TestTreeRegistryImpl.class);
        binder.bind(TestTreeTransformer.class).to(DefaultTestTreeTransformer.class);
        binder.bind(UrlDecoderService.class).to(Utf8UrlDecoderService.class);
        Names.bindProperties((Binder)binder, (Properties)this.getProperties());
    }

    private void bindListenerForN4jsSingletons(Binder binder) {
        AbstractMatcher m = new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> t) {
                this.checkAndThrowMissingBindingException(t);
                return false;
            }

            private void checkAndThrowMissingBindingException(TypeLiteral<?> t) {
                Type type = t.getType();
                if (type instanceof Class) {
                    String name = t.toString();
                    Singleton singleton = null;
                    try {
                        singleton = ((Class)type).getAnnotation(Singleton.class);
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Could not check whether injected type is @Singleton", (Throwable)e);
                    }
                    if (singleton != null) {
                        boolean allowedPrefix = false;
                        allowedPrefix |= name.startsWith("org.eclipse.n4js.tester.");
                        allowedPrefix |= name.startsWith("org.eclipse.n4js.runner.");
                        if (!(allowedPrefix |= name.startsWith("org.eclipse.n4js.utils."))) {
                            String msg = "All dependencies to @Singleton classes must be bound explicitly.";
                            throw new RuntimeException(msg);
                        }
                    }
                }
            }
        };
        TypeListener tl = new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            }
        };
        binder.bindListener((Matcher)m, tl);
    }

    private Properties getProperties() {
        Properties properties = new Properties(new DefaultModuleProperties());
        try {
            URL url = new URL("platform:/plugin/org.eclipse.n4js.tester/module.properties");
            return this.tryLoadProperties(url, properties);
        }
        catch (IOException e) {
            block8: {
                if (e instanceof MalformedURLException) {
                    LOGGER.info((Object)"Cannot locate module properties. Does the platform running? Trying to load properties for tests.");
                    try {
                        CodeSource source;
                        ProtectionDomain domain = this.getClass().getProtectionDomain();
                        if (domain != null && (source = domain.getCodeSource()) != null) {
                            String parent = new File(source.getLocation().toURI()).getParent();
                            File file = new File(String.valueOf(parent) + File.separator + "module.properties");
                            if (!file.exists() || !file.canRead()) {
                                LOGGER.info((Object)("Cannot access properties file at " + file.getPath() + "."));
                            }
                            URL url = file.toURI().toURL();
                            return this.tryLoadProperties(url, properties);
                        }
                    }
                    catch (IOException | URISyntaxException ee) {
                        if (ee instanceof FileNotFoundException) {
                            LOGGER.warn((Object)"Cannot load module properties. Falling back to defaults.");
                            break block8;
                        }
                        LOGGER.warn((Object)"Cannot load module properties. Falling back to defaults.", (Throwable)ee);
                    }
                }
            }
            return properties;
        }
    }

    private Properties tryLoadProperties(URL url, Properties properties) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = url.openStream();){
            properties.load(is);
            LOGGER.info((Object)"Module properties have been successfully loaded.");
            return properties;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final class DefaultModuleProperties
    extends Properties {
        private DefaultModuleProperties() {
            this.setProperty("httpServerPortKey", String.valueOf(9415));
            this.setProperty("setupFsmTimeoutKey", String.valueOf(TesterModuleDefaults.SETUP_FSM_TIMEOUT_VALUE));
            this.setProperty("defaultFsmTimeoutKey", String.valueOf(TesterModuleDefaults.DEFAULT_FSM_TIMEOUT_VALUE));
            this.setProperty("minThreadCountKey", String.valueOf(16));
            this.setProperty("maxThreadCountKey", String.valueOf(512));
            this.setProperty("dumpServerOnStopKey", String.valueOf(false));
            this.setProperty("testTreeTimeoutKey", String.valueOf(TesterModuleDefaults.TEST_TREE_TIMEOUT_VALUE));
            this.setProperty("threadPoolBlockingCapacityKey", String.valueOf(60000));
        }
    }
}

