/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.launcher.TracingBlock;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TracingPropertySource {
    private IPluginModelBase fModel;
    private Vector<PropertyEditor> fDescriptors;
    private Hashtable<?, ?> fTemplate;
    private Hashtable<String, Object> fValues;
    private static final String[] fBooleanChoices = new String[]{"false", "true"};
    private Properties fMasterOptions;
    private boolean fModified;
    private boolean fChanged;
    private TracingBlock fBlock;

    public TracingPropertySource(IPluginModelBase model, Properties masterOptions, Hashtable<?, ?> template, TracingBlock block) {
        this.fModel = model;
        this.fMasterOptions = masterOptions;
        this.fTemplate = template;
        this.fBlock = block;
        this.fValues = new Hashtable();
    }

    public IPluginModelBase getModel() {
        return this.fModel;
    }

    private Object[] getSortedKeys(int size) {
        Object[] keyArray = new Object[size];
        int i = 0;
        Enumeration<?> keys = this.fTemplate.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            keyArray[i++] = key;
        }
        Arrays.sort(keyArray, (o1, o2) -> this.compareKeys(o1, o2));
        return keyArray;
    }

    private int compareKeys(Object o1, Object o2) {
        String s1 = (String)o1;
        String s2 = (String)o2;
        return s1.compareTo(s2);
    }

    public void createContents(Composite parent, boolean enabled) {
        Object[] sortedKeys;
        this.fDescriptors = new Vector();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.rightMargin = 10;
        layout.leftMargin = 10;
        parent.setLayout((Layout)layout);
        boolean bordersNeeded = false;
        Object[] objectArray = sortedKeys = this.getSortedKeys(this.fTemplate.size());
        int n = sortedKeys.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyEditor editor;
            Object keyObject = objectArray[n2];
            String key = (String)keyObject;
            Path path = new Path(key);
            path = path.removeFirstSegments(1);
            String shortKey = path.toString();
            String value = (String)this.fTemplate.get(key);
            String lvalue = null;
            String masterValue = this.fMasterOptions.getProperty(key);
            String commentValue = this.fMasterOptions.getProperty("#" + key);
            if (value != null) {
                lvalue = value.toLowerCase(Locale.ENGLISH);
            }
            if (lvalue != null && (lvalue.equals("true") || lvalue.equals("false"))) {
                editor = new BooleanEditor(shortKey, shortKey, commentValue);
                if (masterValue != null) {
                    Integer mvalue = masterValue.equals("true") ? 1 : 0;
                    this.fValues.put(shortKey, mvalue);
                }
            } else {
                editor = new TextEditor(shortKey, shortKey, commentValue);
                if (masterValue != null) {
                    this.fValues.put(shortKey, masterValue);
                }
                bordersNeeded = true;
            }
            editor.create(parent, enabled);
            editor.initialize();
            this.fDescriptors.add(editor);
            if (bordersNeeded) {
                this.fBlock.getToolkit().paintBordersFor(parent);
            }
            ++n2;
        }
    }

    public void save() {
        String pid = this.fModel.getPluginBase().getId();
        Enumeration<String> keys = this.fValues.keys();
        while (keys.hasMoreElements()) {
            String shortKey = keys.nextElement();
            Object value = this.fValues.get(shortKey);
            String svalue = value.toString();
            if (value instanceof Integer) {
                svalue = fBooleanChoices[(Integer)value];
            }
            IPath path = new Path(pid).append(shortKey);
            this.fMasterOptions.setProperty(path.toString(), svalue);
        }
        this.fModified = false;
    }

    public void dispose() {
    }

    public boolean isModified() {
        return this.fModified;
    }

    public boolean isChanged() {
        return this.fChanged;
    }

    public void setChanged(boolean isChanged) {
        this.fChanged = isChanged;
    }

    private class BooleanEditor
    extends PropertyEditor {
        private Button checkbox;

        public BooleanEditor(String key, String label, String comment) {
            super(key, label, comment);
        }

        @Override
        public void create(Composite parent, boolean enabled) {
            this.checkbox = TracingPropertySource.this.fBlock.getToolkit().createButton(parent, this.getLabel(), 32);
            TableWrapData td = new TableWrapData();
            td.colspan = 2;
            this.checkbox.setLayoutData((Object)td);
            this.checkbox.setEnabled(enabled);
            this.createCommentDecorator((Control)this.checkbox, enabled);
        }

        public void update() {
            Integer value = (Integer)TracingPropertySource.this.fValues.get(this.getKey());
            this.checkbox.setSelection(value == 1);
        }

        @Override
        public void initialize() {
            this.update();
            this.checkbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                int value = this.checkbox.getSelection() ? 1 : 0;
                this.valueModified(value);
            }));
            int value = this.checkbox.getSelection() ? 1 : 0;
            this.valueModified(value);
        }
    }

    private abstract class PropertyEditor {
        private String key;
        private String label;
        private String comment;

        public PropertyEditor(String key, String label, String comment) {
            this.key = key;
            this.label = label;
            this.comment = comment;
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public String getComment() {
            return this.comment;
        }

        abstract void create(Composite var1, boolean var2);

        abstract void initialize();

        protected void valueModified(Object value) {
            TracingPropertySource.this.fValues.put(this.getKey(), value);
            TracingPropertySource.this.fModified = true;
            TracingPropertySource.this.fChanged = true;
            TracingPropertySource.this.fBlock.getTab().scheduleUpdateJob();
        }

        protected void createCommentDecorator(Control target, boolean enabled) {
            String commentText = this.getFormattedComment();
            if (!commentText.isEmpty()) {
                target.setToolTipText(commentText);
            }
        }

        protected String getFormattedComment() {
            String commentOrig = this.getComment();
            if (commentOrig == null || commentOrig.trim().isEmpty()) {
                return "";
            }
            String[] lines = commentOrig.trim().split("\\r?\\n");
            StringBuilder commentBuilder = new StringBuilder();
            boolean needsSpace = false;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if ((string = string.replaceFirst("^#", "").trim()).isEmpty()) {
                    commentBuilder.append("\n\n");
                    needsSpace = false;
                } else {
                    if (needsSpace) {
                        commentBuilder.append(" ");
                    }
                    commentBuilder.append(string);
                    needsSpace = true;
                }
                ++n2;
            }
            String processed = commentBuilder.toString().trim();
            int k = processed.lastIndexOf("\n\n");
            if (k > 0) {
                return processed.substring(k + 2);
            }
            return processed;
        }
    }

    private class TextEditor
    extends PropertyEditor {
        private Text text;

        public TextEditor(String key, String label, String comment) {
            super(key, label, comment);
        }

        @Override
        public void create(Composite parent, boolean enabled) {
            Label label = TracingPropertySource.this.fBlock.getToolkit().createLabel(parent, this.getLabel());
            label.setEnabled(enabled);
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            label.setLayoutData((Object)td);
            this.text = TracingPropertySource.this.fBlock.getToolkit().createText(parent, "");
            td = new TableWrapData(256);
            this.text.setLayoutData((Object)td);
            this.text.setEnabled(enabled);
            this.createCommentDecorator((Control)label, enabled);
        }

        public void update() {
            String value = (String)TracingPropertySource.this.fValues.get(this.getKey());
            this.text.setText(value);
        }

        @Override
        public void initialize() {
            this.update();
            this.text.addModifyListener(e -> this.valueModified(this.text.getText()));
            this.valueModified(this.text.getText());
        }
    }
}

