/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.ui.ServiceSelectorComposite;
import org.eclipse.userstorage.ui.internal.Activator;
import org.eclipse.userstorage.ui.internal.AddServiceDialog;
import org.eclipse.userstorage.ui.internal.CredentialsComposite;
import org.eclipse.userstorage.ui.internal.ServicesContentProvider;
import org.eclipse.userstorage.ui.internal.ServicesLabelProvider;

public class ServicesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.userstorage.ui.ServicesPreferencePage";
    private static final IStorageService.Registry REGISTRY = IStorageService.Registry.INSTANCE;
    private Map<IStorageService, Credentials> credentialsMap = new HashMap<IStorageService, Credentials>();
    private Map<IStorageService, Boolean> termsOfUseAgreedMap = new HashMap<IStorageService, Boolean>();
    private TableViewer servicesViewer;
    private CredentialsComposite credentialsComposite;
    private Button addButton;
    private Button removeButton;
    private Button testButton;
    private IStorageService selectedService;
    private boolean skipValidate;

    public ServicesPreferencePage() {
        super("User Storage Service");
    }

    public void init(IWorkbench workbench) {
    }

    public void applyData(Object data) {
        if (data instanceof IStorageService) {
            IStorageService service = (IStorageService)data;
            this.setSelectedService(service);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateEnablement();
    }

    protected Control createContents(Composite parent) {
        Object[] elements;
        final ServicesContentProvider contentProvider = ServiceSelectorComposite.isShowServices() ? new ServicesContentProvider() : null;
        Composite mainArea = this.createArea(parent, 2);
        mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftArea = this.createArea(mainArea, 1);
        leftArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (contentProvider != null) {
            Label servicesLabel = new Label(leftArea, 0);
            servicesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            servicesLabel.setText("Services:");
            TableColumnLayout tableLayout = new TableColumnLayout();
            Composite tableComposite = new Composite(leftArea, 0);
            tableComposite.setLayout((Layout)tableLayout);
            tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.servicesViewer = new TableViewer(tableComposite, 2048);
            this.servicesViewer.setContentProvider((IContentProvider)contentProvider);
            this.servicesViewer.setLabelProvider((IBaseLabelProvider)new ServicesLabelProvider());
            this.servicesViewer.setInput((Object)REGISTRY);
            this.servicesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ServicesPreferencePage.this.setSelectedService((IStorageService)selection.getFirstElement());
                }
            });
            TableColumn tableColumn = new TableColumn(this.servicesViewer.getTable(), 16384);
            tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100));
            new Label(leftArea, 0);
        }
        this.credentialsComposite = new CredentialsComposite(leftArea, 0, 0, 0, false){

            @Override
            protected void validate() {
                if (ServicesPreferencePage.this.selectedService != null && !ServicesPreferencePage.this.skipValidate) {
                    Credentials credentials = this.getCredentials();
                    boolean termsOfUseAgreed = this.isTermsOfUseAgreed();
                    ServicesPreferencePage.this.update(credentials, termsOfUseAgreed);
                }
            }
        };
        this.credentialsComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        if (contentProvider != null) {
            Composite rightArea = this.createArea(mainArea, 1);
            rightArea.setLayoutData((Object)new GridData(4, 4, false, false));
            new Label(rightArea, 0);
            this.addButton = new Button(rightArea, 0);
            this.addButton.setLayoutData((Object)new GridData(4, 128, true, false));
            this.addButton.setText("Add...");
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddServiceDialog dialog = new AddServiceDialog(ServicesPreferencePage.this.getShell());
                    if (dialog.open() == 0) {
                        String serviceLabel = dialog.getServiceLabel();
                        URI serviceURI = dialog.getServiceURI();
                        URI createAccountURI = dialog.getCreateAccountURI();
                        URI editAccountURI = dialog.getEditAccountURI();
                        URI recoverPasswordURI = dialog.getRecoverPasswordURI();
                        String termsOfUseLink = dialog.getTermsOfUseLink();
                        REGISTRY.addService(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
                    }
                }
            });
            this.removeButton = new Button(rightArea, 0);
            this.removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
            this.removeButton.setText("Remove");
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ServicesPreferencePage.this.selectedService instanceof IStorageService.Dynamic) {
                        IStorageService.Dynamic dynamicService = (IStorageService.Dynamic)ServicesPreferencePage.this.selectedService;
                        Object[] elements = contentProvider.getElements(null);
                        final int currentIndex = this.getCurrentIndex(elements, (IStorageService)dynamicService);
                        if (MessageDialog.openQuestion((Shell)ServicesPreferencePage.this.getShell(), (String)"Remove Service", (String)("Do you really want to remove the '" + dynamicService.getServiceLabel() + "' service?"))) {
                            dynamicService.remove();
                            final Control control = ServicesPreferencePage.this.servicesViewer.getControl();
                            control.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Object[] elements;
                                    if (!control.isDisposed() && (elements = contentProvider.getElements(null)).length != 0) {
                                        int newIndex = currentIndex;
                                        if (newIndex >= elements.length) {
                                            newIndex = elements.length - 1;
                                        }
                                        ServicesPreferencePage.this.setSelectedService((IStorageService)elements[newIndex]);
                                    }
                                }
                            });
                        }
                    }
                }

                private int getCurrentIndex(Object[] elements, IStorageService service) {
                    int i = 0;
                    while (i < elements.length) {
                        Object element = elements[i];
                        if (element == service) {
                            return i;
                        }
                        ++i;
                    }
                    return 0;
                }
            });
            Button refreshButton = new Button(rightArea, 0);
            refreshButton.setLayoutData((Object)new GridData(4, 128, true, false));
            refreshButton.setText("Refresh");
            refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    REGISTRY.refresh();
                }
            });
        }
        Object[] objectArray = elements = contentProvider == null ? REGISTRY.getServices() : contentProvider.getElements(null);
        if (elements.length != 0) {
            this.setSelectedService(elements[0]);
        }
        if (Boolean.getBoolean("org.eclipse.userstorage.ui.showTestButton")) {
            this.testButton = new Button(leftArea, 8);
            this.testButton.setText("Test");
            this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IStorage storage = StorageFactory.DEFAULT.create("pDKTqBfDuNxlAKydhEwxBZPxa4q");
                        IBlob blob = storage.getBlob("ui_test");
                        blob.setContentsUTF("Test 123");
                        ServicesPreferencePage.this.performDefaults();
                        MessageDialog.openInformation((Shell)ServicesPreferencePage.this.getShell(), (String)"Test", (String)"Test succeeded.");
                    }
                    catch (Exception ex) {
                        ServicesPreferencePage.this.performDefaults();
                        ErrorDialog.openError((Shell)ServicesPreferencePage.this.getShell(), (String)"Test", (String)"Test failed.", (IStatus)Activator.getStatus(ex));
                    }
                }
            });
        }
        this.applyDialogFont(mainArea);
        return mainArea;
    }

    protected void performDefaults() {
        this.credentialsMap.clear();
        this.termsOfUseAgreedMap.clear();
        try {
            this.skipValidate = true;
            IStorageService service = this.selectedService;
            this.selectedService = null;
            this.setSelectedService(service);
        }
        finally {
            this.skipValidate = false;
        }
        this.updateEnablement();
    }

    protected Point doComputeSize() {
        return CredentialsComposite.INITIAL_SIZE;
    }

    public boolean performOk() {
        IStorageService service;
        for (Map.Entry<IStorageService, Credentials> entry : this.credentialsMap.entrySet()) {
            service = entry.getKey();
            Credentials credentials = entry.getValue();
            ((StorageService)service).setCredentials(credentials);
        }
        for (Map.Entry<IStorageService, Object> entry : this.termsOfUseAgreedMap.entrySet()) {
            service = entry.getKey();
            Boolean termsOfUseAgreed = (Boolean)entry.getValue();
            ((StorageService)service).setTermsOfUseAgreed(Boolean.TRUE.equals(termsOfUseAgreed));
        }
        this.updateEnablement();
        return true;
    }

    private Composite createArea(Composite parent, int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)layout);
        return main;
    }

    private void setSelectedService(IStorageService service) {
        if (service != this.selectedService) {
            this.selectedService = service;
            if (this.selectedService != null) {
                Boolean termsOfUseAgreed;
                Credentials credentials = this.credentialsMap.get(this.selectedService);
                if (credentials == null && (credentials = ((StorageService)this.selectedService).getCredentials()) != null) {
                    this.credentialsMap.put(this.selectedService, credentials);
                }
                if ((termsOfUseAgreed = this.termsOfUseAgreedMap.get(this.selectedService)) == null) {
                    termsOfUseAgreed = ((StorageService)this.selectedService).isTermsOfUseAgreed();
                    this.termsOfUseAgreedMap.put(this.selectedService, termsOfUseAgreed);
                }
                try {
                    this.skipValidate = true;
                    this.credentialsComposite.setService(this.selectedService);
                    this.credentialsComposite.setCredentials(credentials);
                    this.credentialsComposite.setTermsOfUseAgreed(termsOfUseAgreed);
                }
                finally {
                    this.skipValidate = false;
                }
                this.update(credentials, termsOfUseAgreed);
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(this.selectedService instanceof IStorageService.Dynamic);
                }
                if (this.servicesViewer != null) {
                    this.servicesViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedService));
                }
            } else {
                this.credentialsComposite.setService(null);
                this.credentialsComposite.setCredentials(null);
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(false);
                }
            }
        }
    }

    private void update(Credentials credentials, boolean termsOfUseAgreed) {
        this.credentialsMap.put(this.selectedService, credentials);
        this.termsOfUseAgreedMap.put(this.selectedService, termsOfUseAgreed);
        this.updateEnablement();
    }

    private void updateEnablement() {
        Button applyButton;
        Button defaultsButton;
        IStorageService service;
        boolean dirty = false;
        IStorageService[] iStorageServiceArray = REGISTRY.getServices();
        int n = iStorageServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            service = iStorageServiceArray[n2];
            Credentials localCredentials = this.credentialsMap.get(service);
            String localUsername = "";
            String localPassword = "";
            if (localCredentials != null) {
                localUsername = StringUtil.safe((String)localCredentials.getUsername());
                localPassword = StringUtil.safe((String)localCredentials.getPassword());
                Credentials credentials = ((StorageService)service).getCredentials();
                String username = "";
                String password = "";
                if (credentials != null) {
                    username = StringUtil.safe((String)credentials.getUsername());
                    password = StringUtil.safe((String)credentials.getPassword());
                }
                if (!localUsername.equals(username) || !localPassword.equals(password)) {
                    dirty = true;
                    break;
                }
            }
            ++n2;
        }
        if (!dirty) {
            iStorageServiceArray = REGISTRY.getServices();
            n = iStorageServiceArray.length;
            n2 = 0;
            while (n2 < n) {
                boolean termsOfUseAgreed;
                service = iStorageServiceArray[n2];
                boolean localTermsOfUseAgreed = Boolean.TRUE.equals(this.termsOfUseAgreedMap.get(service));
                if (localTermsOfUseAgreed != (termsOfUseAgreed = ((StorageService)service).isTermsOfUseAgreed())) {
                    dirty = true;
                    break;
                }
                ++n2;
            }
        }
        if ((defaultsButton = this.getDefaultsButton()) != null) {
            defaultsButton.setEnabled(dirty);
        }
        if ((applyButton = this.getApplyButton()) != null) {
            applyButton.setEnabled(dirty);
        }
    }
}

