/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xpect.registry.IEPackageInfo;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.eclipse.xpect.registry.LazyClass;

public class EPackageInfoRegistry
implements IEPackageInfo.Registry {
    public static Logger LOG = Logger.getLogger(EPackageInfoRegistry.class);
    private final Map<String, IEPackageInfo> epackageInfos = ImmutableMap.copyOf(this.collectEPackageInfos());

    public static void main(String[] args) {
        System.out.println(new EPackageInfoRegistry().toString());
    }

    private Map<String, IEPackageInfo> collectEPackageInfos() {
        HashMap result = Maps.newHashMap();
        for (IExtensionInfo ext : IExtensionInfo.Registry.INSTANCE.getExtensions("org.eclipse.emf.ecore.generated_package")) {
            EPackageInfo info = new EPackageInfo(ext);
            String key = info.getNamespaceURI();
            IEPackageInfo conflict = (IEPackageInfo)result.get(key);
            if (conflict != null) {
                String loc1 = ((EPackageInfo)conflict).getSource().getLocation();
                String loc2 = info.getSource().getLocation();
                LOG.warn((Object)("namespaceURI " + key + " is already registered. File1: " + loc1 + " File2: " + loc2));
                continue;
            }
            result.put(key, info);
        }
        return result;
    }

    @Override
    public IEPackageInfo getEPackageInfo(String namespaceURI) {
        return this.epackageInfos.get(namespaceURI);
    }

    @Override
    public Collection<String> getNamespaceURIs() {
        return this.epackageInfos.keySet();
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.epackageInfos.values());
    }

    public static class EPackageInfo
    implements IEPackageInfo {
        private final IExtensionInfo source;

        public EPackageInfo(IExtensionInfo source) {
            this.source = source;
        }

        @Override
        public LazyClass<EPackage> getEPackage() {
            String className = this.getEPackageClassName();
            return LazyClass.create(EPackage.class, className, this.source);
        }

        @Override
        public String getEPackageClassName() {
            return this.source.getAttributeValue("class");
        }

        @Override
        public String getGenmodel() {
            return this.source.getAttributeValue("genModel");
        }

        @Override
        public String getNamespaceURI() {
            return this.source.getAttributeValue("uri");
        }

        public IExtensionInfo getSource() {
            return this.source;
        }

        public String toString() {
            return "uri=" + this.getNamespaceURI() + " class=" + this.getEPackageClassName() + " genModel=" + this.getGenmodel();
        }
    }
}

