/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.eclipse.xpect.util.ExtensionFactoryUtil;

public class LazyClass<T> {
    private final Class<T> expectedType;
    private final String factory;
    private final Function<String, Class<?>> loader;
    private final String name;
    private final IExtensionInfo trace;

    public static <T> LazyClass<T> create(Class<T> expectedType, IExtensionInfo trace, String attributeName) {
        String className = trace.getAttributeValue(attributeName);
        if (className != null) {
            return new LazyClass<T>(expectedType, className, trace.getClassLoader(), trace);
        }
        return null;
    }

    public static <T> LazyClass<T> create(Class<T> expectedType, String name, Function<String, Class<?>> loader) {
        if (name != null) {
            return new LazyClass<T>(expectedType, name, loader, null);
        }
        return null;
    }

    public static <T> LazyClass<T> create(Class<T> expectedType, String name, IExtensionInfo trace) {
        if (name != null) {
            return new LazyClass<T>(expectedType, name, trace.getClassLoader(), trace);
        }
        return null;
    }

    protected LazyClass(Class<T> expectedType, String name, Function<String, Class<?>> loader, IExtensionInfo trace) {
        ExtensionFactoryUtil.NameAndClass nameAndClass = ExtensionFactoryUtil.parseExtensionFactory(name);
        this.expectedType = expectedType;
        this.name = nameAndClass.getClazz();
        this.factory = nameAndClass.getUiLangName();
        this.loader = loader;
        this.trace = trace;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LazyClass other = (LazyClass)obj;
        return Objects.equal((Object)this.name, (Object)other.name);
    }

    public Class<T> getExpectedType() {
        return this.expectedType;
    }

    public String getFactory() {
        return this.factory;
    }

    public Function<String, Class<?>> getLoader() {
        return this.loader;
    }

    public String getName() {
        return this.name;
    }

    public IExtensionInfo getTrace() {
        return this.trace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Class<T> load() {
        Class clazz = (Class)this.loader.apply((Object)this.name);
        if (this.expectedType.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new ClassCastException("Class " + clazz.getName() + " is not a subtype of " + this.expectedType.getName());
    }

    public boolean needsInjection() {
        return this.factory != null;
    }

    public String toString() {
        return this.name;
    }
}

