/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.util.DotClasspath;
import org.eclipse.xpect.util.IBundleInfo;
import org.eclipse.xtext.util.Strings;

public class ResourceAccess {
    public static ResourceInfo create(URI uri) {
        if (uri.isArchive()) {
            return new ArchivedResourceInfo(uri);
        }
        File dot = new File(String.valueOf(uri.toFileString()) + ".classpath");
        if (dot.isFile()) {
            DotClasspath dotClasspath = new DotClasspath(dot);
            return new JavaProjectInfo(uri, dotClasspath.getSources(), dotClasspath.getOutput());
        }
        return new GeneralProjectInfo(uri);
    }

    public static class ArchivedResourceInfo
    extends ResourceInfo {
        public static final Logger LOG = Logger.getLogger(ArchivedResourceInfo.class);

        public ArchivedResourceInfo(URI location) {
            super(location);
        }

        @Override
        public List<URI> find(IBundleInfo.Context context) {
            return Collections.singletonList(this.location);
        }

        @Override
        public URI find(IBundleInfo.Context context, String fileName) {
            return this.resolve(fileName);
        }

        @Override
        public List<URI> find(IBundleInfo.Context context, String path, Predicate<String> matcher, String ... fileExtensions) {
            String archiveFileName = URI.createURI((String)this.location.authority().substring(0, this.location.authority().length() - 1)).toFileString();
            ArrayList result = Lists.newArrayList();
            try (JarFile jarFile = new JarFile(new File(archiveFileName));){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry next = entries.nextElement();
                    String name = next.getName();
                    if (!Strings.isEmpty((String)path) && !name.startsWith(path) || !this.matches(name, fileExtensions) || !matcher.apply((Object)name)) continue;
                    URI resolved = URI.createURI((String)name).resolve(this.location);
                    result.add(resolved);
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("location", (Object)this.location.toString()).toString();
        }
    }

    public static class GeneralProjectInfo
    extends ResourceInfo {
        public GeneralProjectInfo(URI location) {
            super(location);
        }

        @Override
        public List<URI> find(IBundleInfo.Context context) {
            return Collections.singletonList(this.location);
        }

        @Override
        public URI find(IBundleInfo.Context context, String fileName) {
            return this.resolve(fileName);
        }

        @Override
        public List<URI> find(IBundleInfo.Context context, String path, Predicate<String> matcher, String ... fileExtensions) {
            File root = new File(this.location.toFileString());
            ArrayList result = Lists.newArrayList();
            this.collect(root, root, result, matcher, fileExtensions);
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("location", (Object)this.location.toString()).toString();
        }
    }

    public static class JavaProjectInfo
    extends ResourceInfo {
        private final String output;
        private final List<String> sourceFolders;

        public JavaProjectInfo(URI location, List<String> sourceFolders, String output) {
            super(location);
            this.sourceFolders = sourceFolders;
            this.output = output;
        }

        @Override
        public List<URI> find(IBundleInfo.Context context) {
            switch (context) {
                case CLASSPATH: {
                    return Collections.singletonList(this.resolve(this.output));
                }
                case ROOT: {
                    return Collections.singletonList(this.location);
                }
                case SOURCE: {
                    ArrayList result = Lists.newArrayList();
                    for (String src : this.sourceFolders) {
                        result.add(this.resolve(src));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        @Override
        public URI find(IBundleInfo.Context context, String fileName) {
            for (URI uri : this.find(context)) {
                File parent = new File(uri.toFileString());
                if (!new File(parent, fileName).exists()) continue;
                return URI.createURI((String)fileName).resolve(uri.hasTrailingPathSeparator() ? uri : uri.appendSegment(""));
            }
            return null;
        }

        @Override
        public List<URI> find(IBundleInfo.Context context, String path, Predicate<String> matcher, String ... fileExtensions) {
            ArrayList result = Lists.newArrayList();
            for (URI uri : this.find(context)) {
                File folder = new File(new File(uri.toFileString()), path);
                if (!folder.isDirectory()) continue;
                this.collect(folder, folder, result, matcher, fileExtensions);
            }
            return result;
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
            helper.add("location", (Object)this.location.toString());
            helper.add("classpath", (Object)this.output);
            helper.add("source", this.sourceFolders);
            return helper.toString();
        }
    }

    public static abstract class ResourceInfo {
        protected final URI location;

        public ResourceInfo(URI location) {
            this.location = location;
        }

        protected void collect(File root, File file, List<URI> result, Predicate<String> matcher, String ... fileExtensions) {
            if (file.isFile()) {
                URI uri;
                URI name;
                if (this.matches(file.getName(), fileExtensions) && matcher.apply((Object)(name = (uri = URI.createFileURI((String)file.getAbsolutePath())).deresolve(URI.createURI((String)root.toString()))).toString())) {
                    result.add(uri);
                }
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.collect(root, child, result, matcher, fileExtensions);
                    ++n2;
                }
            }
        }

        public abstract List<URI> find(IBundleInfo.Context var1);

        public abstract URI find(IBundleInfo.Context var1, String var2);

        public abstract List<URI> find(IBundleInfo.Context var1, String var2, Predicate<String> var3, String ... var4);

        public URI getLocation() {
            return this.location;
        }

        protected boolean matches(String name, String ... fileExtensions) {
            if (fileExtensions.length == 0) {
                return true;
            }
            int index = name.lastIndexOf(46);
            if (index < 0) {
                return false;
            }
            String ext = name.substring(index + 1, name.length());
            int i = 0;
            while (i < fileExtensions.length) {
                if (ext.equals(fileExtensions[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected URI resolve(String fileName) {
            return URI.createURI((String)fileName).resolve(this.location);
        }
    }
}

