/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.DestructureUtilsForSymbols;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.VariableDeclaration;

public class AssignmentRelationFactory {
    private final SymbolFactory symbolFactory;

    AssignmentRelationFactory(SymbolFactory symbolFactory) {
        this.symbolFactory = symbolFactory;
    }

    Multimap<Symbol, Object> findAssignments(ControlFlowElement cfe) {
        ForStatement fs;
        EObject parent;
        HashMultimap assgns = HashMultimap.create();
        if (DestructureUtils.isTopOfDestructuring((EObject)cfe)) {
            this.findInAllDestructNodes((Multimap<Symbol, Object>)assgns, cfe);
        } else if (DestructureUtils.isInDestructuringPattern((EObject)cfe)) {
            this.findInCorrespondingDestructNodes((Multimap<Symbol, Object>)assgns, cfe);
        } else if (cfe instanceof AssignmentExpression) {
            this.findInAssignmentExpression((Multimap<Symbol, Object>)assgns, (AssignmentExpression)cfe);
        } else if (cfe instanceof VariableDeclaration) {
            this.findInVariableDeclaration((Multimap<Symbol, Object>)assgns, (VariableDeclaration)cfe);
        } else if (cfe instanceof IdentifierRef && (parent = cfe.eContainer()) instanceof ForStatement && (fs = (ForStatement)parent).getInitExpr() == cfe && !fs.isForPlain()) {
            this.findInForStatementInOf((Multimap<Symbol, Object>)assgns, cfe, fs);
        }
        return assgns;
    }

    private void findInAssignmentExpression(Multimap<Symbol, Object> assgns, AssignmentExpression ae) {
        Expression lhs = ae.getLhs();
        Expression rhs = ae.getRhs();
        this.handleSubexpressions(assgns, (ControlFlowElement)lhs, rhs);
    }

    private void findInVariableDeclaration(Multimap<Symbol, Object> assgns, VariableDeclaration vd) {
        ForStatement fs;
        EObject parent = vd.eContainer();
        if (parent instanceof ForStatement && !(fs = (ForStatement)parent).isForPlain()) {
            this.findInForStatementInOf(assgns, (ControlFlowElement)vd, (ForStatement)parent);
            return;
        }
        Expression rhs = vd.getExpression();
        if (rhs == null) {
            Symbol undefinedSymbol = this.symbolFactory.getUndefined();
            this.createRelation(assgns, (ControlFlowElement)vd, undefinedSymbol, null);
        } else {
            this.handleSubexpressions(assgns, (ControlFlowElement)vd, rhs);
        }
    }

    private void findInForStatementInOf(Multimap<Symbol, Object> assgns, ControlFlowElement cfe, ForStatement fs) {
        Expression rhs = fs.getExpression();
        if (rhs instanceof ArrayLiteral) {
            ArrayLiteral al = (ArrayLiteral)rhs;
            for (ArrayElement arElem : al.getElements()) {
                this.handleSubexpressions(assgns, cfe, arElem.getExpression());
            }
        } else {
            this.createRelation(assgns, cfe, rhs);
        }
    }

    private void handleSubexpressions(Multimap<Symbol, Object> assgns, ControlFlowElement lhs, Expression rhs) {
        if ((rhs = ASTUtils.unwrapParentheses(rhs)) instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)rhs;
            Expression innerRhs = ae.getRhs();
            this.handleSubexpressions(assgns, lhs, innerRhs);
        } else if (rhs instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)rhs;
            Expression trueExpr = ce.getTrueExpression();
            Expression falseExpr = ce.getFalseExpression();
            this.handleSubexpressions(assgns, lhs, trueExpr);
            this.handleSubexpressions(assgns, lhs, falseExpr);
        } else if (rhs instanceof BinaryLogicalExpression) {
            BinaryLogicalExpression ble = (BinaryLogicalExpression)rhs;
            if (ble.getOp() == BinaryLogicalOperator.OR) {
                this.handleSubexpressions(assgns, lhs, ble.getLhs());
            }
            this.handleSubexpressions(assgns, lhs, ble.getRhs());
        } else {
            this.createRelation(assgns, lhs, rhs);
        }
    }

    private void findInAllDestructNodes(Multimap<Symbol, Object> assgns, ControlFlowElement cfe) {
        EObject top = DestructureUtils.getTop((EObject)cfe);
        DestructNode dNode = DestructNode.unify((EObject)top);
        if (dNode == null) {
            return;
        }
        if (top instanceof ForStatement) {
            ForStatement fs = (ForStatement)top;
            Expression fsExpr = fs.getExpression();
            if (fsExpr instanceof ArrayLiteral) {
                ArrayLiteral al = (ArrayLiteral)fsExpr;
                EObject rootOfDestrNode = DestructureUtils.getRoot((EObject)cfe);
                for (ArrayElement arrElem : al.getElements()) {
                    dNode = DestructNode.unify((EObject)rootOfDestrNode, (Expression)arrElem.getExpression());
                    this.findInDestructNodes(assgns, dNode);
                }
            }
        } else {
            this.findInDestructNodes(assgns, dNode);
        }
    }

    private void findInCorrespondingDestructNodes(Multimap<Symbol, Object> assgns, ControlFlowElement cfe) {
        DestructNode dNode = DestructureUtils.getCorrespondingDestructNode((EObject)cfe);
        if (dNode == null) {
            return;
        }
        EObject parentOfDestrNode = DestructureUtils.getTop((EObject)cfe);
        if (parentOfDestrNode instanceof ForStatement) {
            ForStatement fs = (ForStatement)parentOfDestrNode;
            Expression fsExpr = fs.getExpression();
            if (fsExpr instanceof ArrayLiteral) {
                ArrayLiteral al = (ArrayLiteral)fsExpr;
                EObject rootOfDestrNode = DestructureUtils.getRoot((EObject)cfe);
                for (ArrayElement arrElem : al.getElements()) {
                    dNode = DestructNode.unify((EObject)rootOfDestrNode, (Expression)arrElem.getExpression());
                    this.findInDestructNodes(assgns, dNode);
                }
            }
        } else {
            this.findInDestructNodes(assgns, dNode);
        }
    }

    private void findInDestructNodes(Multimap<Symbol, Object> assgns, DestructNode dNode) {
        Iterator dnIter = dNode.stream().iterator();
        while (dnIter.hasNext()) {
            DestructNode dnChild = (DestructNode)dnIter.next();
            IdentifierRef lhs = dnChild.getVarRef() != null ? dnChild.getVarRef() : dnChild.getVarDecl();
            EObject rhs = DestructureUtilsForSymbols.getValueFromDestructuring(this.symbolFactory, dnChild);
            if (rhs == null) {
                Symbol undefinedSymbol = this.symbolFactory.getUndefined();
                this.createRelation(assgns, (ControlFlowElement)lhs, undefinedSymbol, null);
                continue;
            }
            this.createRelation(assgns, (ControlFlowElement)lhs, (Expression)rhs);
        }
    }

    private void createRelation(Multimap<Symbol, Object> assgns, ControlFlowElement lhs, Expression rhs) {
        Symbol rSymbol = this.symbolFactory.create((ControlFlowElement)rhs);
        this.createRelation(assgns, lhs, rSymbol, rhs);
    }

    private void createRelation(Multimap<Symbol, Object> assgns, ControlFlowElement lhs, Symbol rSymbol, Expression rhs) {
        Symbol lSymbol = this.symbolFactory.create(lhs);
        if (lSymbol != null) {
            if (rSymbol != null) {
                assgns.put((Object)lSymbol, (Object)rSymbol);
            } else if (rhs != null) {
                assgns.put((Object)lSymbol, (Object)rhs);
            }
        }
    }
}

