/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.BuiltInProjectNode;
import org.eclipse.n4js.ui.navigator.internal.NamedNode;
import org.eclipse.n4js.ui.navigator.internal.Node;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.n4js.utils.resources.IExternalResource;
import org.eclipse.swt.graphics.Image;

@Singleton
public class N4JSProjectExplorerHelper {
    @Inject
    private IN4JSCore core;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private ExternalLibraryPreferenceStore prefStore;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ShadowingInfoHelper shadowingInfoHelper;

    public IN4JSProject getProject(IProject project) {
        Preconditions.checkArgument((!(project instanceof ExternalProject) ? 1 : 0) != 0, (Object)("Expected Eclipse workspace project. Got: " + project));
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        String projectName = Strings.nullToEmpty((String)project.getName());
        IN4JSProject n4Project = this.core.create(URI.createPlatformResourceURI((String)projectName, (boolean)true));
        if (n4Project == null || !n4Project.exists() || n4Project.isExternal()) {
            return null;
        }
        return n4Project;
    }

    public boolean isSourceFolder(IFolder folder) {
        IN4JSProject project = this.getProject(folder.getProject());
        if (project != null) {
            String relativePath = Strings.nullToEmpty((String)folder.getProjectRelativePath().toOSString());
            for (IN4JSSourceContainer srcContainer : project.getSourceContainers()) {
                String relSrcCont = Strings.nullToEmpty((String)srcContainer.getRelativeLocation());
                if (!relativePath.equals(relSrcCont) && !relSrcCont.startsWith(String.valueOf(relativePath) + File.separator)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOutputFolder(IFolder folder) {
        IN4JSProject project = this.getProject(folder.getProject());
        if (project != null) {
            String outputPath;
            String relativePath = Strings.nullToEmpty((String)folder.getProjectRelativePath().toOSString());
            return relativePath.equals(outputPath = Strings.nullToEmpty((String)project.getOutputPath())) || outputPath.startsWith(String.valueOf(relativePath) + File.separator);
        }
        return false;
    }

    public N4JSExternalProject getNodeModulesNpmProjectOrNull(IFolder folder) {
        String npmPckJson = folder.getLocation().toOSString();
        URI folderURI = URI.createFileURI((String)npmPckJson);
        return this.externalLibraryWorkspace.getProject(folderURI);
    }

    public boolean isNodeModulesNpmProject(IFolder folder) {
        IContainer parentContainer = folder.getParent();
        if (parentContainer instanceof IFolder) {
            return this.isNodeModulesFolder(parentContainer);
        }
        return false;
    }

    public boolean isNodeModulesFolder(IContainer container) {
        if ("node_modules".equals(container.getName()) && container instanceof IFolder) {
            IPath path = container.getLocation();
            java.net.URI locURI = path.toFile().toURI();
            if (this.prefStore.getNodeModulesLocations().contains(locURI)) {
                return true;
            }
        }
        return false;
    }

    public StyledString getStyledTextForExternalProject(IN4JSProject project, String overrideProjectName) {
        String name = overrideProjectName == null ? project.getProjectName() : overrideProjectName;
        ProjectType type = project.getProjectType();
        String version = SemverSerializer.serialize((VersionNumber)project.getVersion()).replaceFirst("@", "v");
        String typeLabel = this.getProjectTypeLabel(type);
        boolean inIndex = this.indexSynchronizer.isInIndex((URI)project.getProjectDescriptionLocation().orNull());
        String rootLocationName = this.getRootLocationName(project);
        StyledString.Styler stylerName = inIndex ? null : StyledString.QUALIFIER_STYLER;
        StyledString.Styler stylerType = inIndex ? StyledString.DECORATIONS_STYLER : StyledString.QUALIFIER_STYLER;
        StyledString string = new StyledString(String.valueOf(name) + " " + version, stylerName);
        string.append(typeLabel, stylerType);
        if (rootLocationName != null) {
            string.append(rootLocationName, StyledString.COUNTER_STYLER);
        }
        return string;
    }

    private String getRootLocationName(IN4JSProject project) {
        String rootLocationName = null;
        List shadowingProjects = this.shadowingInfoHelper.findShadowingProjects(project);
        if (!shadowingProjects.isEmpty()) {
            IN4JSProject shadowedProject = (IN4JSProject)shadowingProjects.get(0);
            if (shadowedProject.isExternal()) {
                URI location = shadowedProject.getLocation();
                java.net.URI rootLocation = this.externalLibraryWorkspace.getRootLocationForResource(location);
                if (rootLocation != null) {
                    Path rootPath = Paths.get(rootLocation.getPath(), new String[0]);
                    Path subpath = rootPath.subpath(rootPath.getNameCount() - 2, rootPath.getNameCount());
                    rootLocationName = subpath.toString();
                } else {
                    rootLocationName = "unknown";
                }
            } else {
                rootLocationName = "workspace";
            }
            rootLocationName = " [shadowed by " + rootLocationName + "]";
        }
        return rootLocationName;
    }

    private String getProjectTypeLabel(ProjectType projectType) {
        String label = ProjectType.API.equals((Object)projectType) ? ProjectType.API.getName() : org.eclipse.xtext.util.Strings.toFirstUpper((String)Strings.nullToEmpty((String)projectType.getName()).replaceAll("_", " ").toLowerCase());
        return " [" + label + "]";
    }

    public Node[] getVirtualNodesForProject(IProject project) {
        Node[] nodeArray;
        Preconditions.checkArgument((!(project instanceof ExternalProject) ? 1 : 0) != 0, (Object)("Expected Eclipse workspace project. Got: " + project));
        if (project == null || !project.exists() || !project.isAccessible()) {
            return Node.EMPTY_NODES;
        }
        IN4JSProject n4Project = this.getProject(project);
        if (n4Project == null || !n4Project.exists() || n4Project.isExternal()) {
            return Node.EMPTY_NODES;
        }
        Image image = (Image)ImageDescriptorCache.ImageRef.LIB_PATH.asImage().get();
        NamedNode rootNode = new NamedNode(project, "External Dependencies", image);
        FluentIterable directDependencies = FluentIterable.from((Iterable)n4Project.getAllDirectDependencies()).filter(IN4JSProject.class);
        Iterable<IN4JSProject> runtimeLibraries = this.getExternalDependenciesOfType((Iterable<? extends IN4JSProject>)directDependencies, ProjectType.RUNTIME_LIBRARY, new ProjectType[0]);
        if (!FluentIterable.from(runtimeLibraries).isEmpty()) {
            Map<String, IN4JSProject> builtInRuntimeEnvironments = this.getBuiltInRuntimeEnvironments();
            Map<String, IN4JSProject> builtInRuntimeLibraries = this.getBuiltInRuntimeLibraries();
            HashSet libs = Sets.newHashSet();
            HashSet envs = Sets.newHashSet();
            for (IN4JSProject p2 : runtimeLibraries) {
                IN4JSProject dependency = builtInRuntimeLibraries.get(p2.getProjectName());
                if (dependency == null) continue;
                libs.add(dependency);
            }
            if (!libs.isEmpty()) {
                block1: for (IN4JSProject p2 : builtInRuntimeEnvironments.values()) {
                    for (IN4JSProject providedLib : FluentIterable.from((Iterable)p2.getProvidedRuntimeLibraries()).filter(IN4JSProject.class)) {
                        IN4JSProject extension;
                        if (!libs.contains(providedLib)) continue;
                        envs.add(p2);
                        String extndedRuntimeEnvName = (String)p2.getExtendedRuntimeEnvironmentId().orNull();
                        if (extndedRuntimeEnvName == null || (extension = builtInRuntimeEnvironments.get(extndedRuntimeEnvName)) == null) continue block1;
                        envs.add(extension);
                        continue block1;
                    }
                }
            }
            NamedNode runtimeNode = new NamedNode(rootNode, "N4JS Runtime", image);
            if (!envs.isEmpty()) {
                NamedNode envsNode = new NamedNode(runtimeNode, "Runtime Environments", image);
                envsNode.addChild((Iterable<Object>)FluentIterable.from((Iterable)envs).transform(p -> new BuiltInProjectNode(envsNode, (IN4JSProject)p)));
                runtimeNode.addChild(envsNode);
            }
            if (!libs.isEmpty()) {
                NamedNode libsNode = new NamedNode(runtimeNode, "Runtime Libraries", image);
                libsNode.addChild((Iterable<Object>)FluentIterable.from((Iterable)libs).transform(p -> new BuiltInProjectNode(libsNode, (IN4JSProject)p)));
                runtimeNode.addChild(libsNode);
            }
            if (!Arrays2.isEmpty((Object[])runtimeNode.getChildren())) {
                rootNode.addChild(runtimeNode);
            }
        }
        Map<String, IN4JSProject> langProjects = this.getAvailableLangProjects();
        Map<String, IN4JSProject> mangelhaftProjects = this.getAvailableMangelhaftProjects();
        Map<String, IN4JSProject> npmProjects = this.getAvailableNpmProjects();
        LinkedHashSet<IN4JSProject> requiredLangLibs = new LinkedHashSet<IN4JSProject>();
        LinkedHashSet<IN4JSProject> requiredMangelhaftLibs = new LinkedHashSet<IN4JSProject>();
        LinkedHashSet<IN4JSProject> requiredNpmLibs = new LinkedHashSet<IN4JSProject>();
        for (IN4JSProject directDependecy : directDependencies) {
            if (!directDependecy.exists() || !directDependecy.isExternal()) continue;
            IN4JSProject externalDepenency = mangelhaftProjects.get(directDependecy.getProjectName());
            if (externalDepenency != null) {
                requiredMangelhaftLibs.add(externalDepenency);
                continue;
            }
            externalDepenency = npmProjects.get(directDependecy.getProjectName());
            if (externalDepenency != null) {
                requiredNpmLibs.add(externalDepenency);
                continue;
            }
            externalDepenency = langProjects.get(directDependecy.getProjectName());
            if (externalDepenency == null) continue;
            requiredLangLibs.add(externalDepenency);
        }
        if (!requiredLangLibs.isEmpty()) {
            NamedNode langNode = new NamedNode(rootNode, (String)ExternalLibrariesActivator.EXTERNAL_LIBRARY_NAMES.get("lang"), image);
            langNode.addChild((Iterable<Object>)FluentIterable.from(requiredLangLibs).transform(p -> new BuiltInProjectNode(langNode, (IN4JSProject)p)));
            rootNode.addChild(langNode);
        }
        if (!requiredMangelhaftLibs.isEmpty()) {
            NamedNode mangNode = new NamedNode(rootNode, (String)ExternalLibrariesActivator.EXTERNAL_LIBRARY_NAMES.get("mangelhaft"), image);
            mangNode.addChild((Iterable<Object>)FluentIterable.from(requiredMangelhaftLibs).transform(p -> new BuiltInProjectNode(mangNode, (IN4JSProject)p)));
            rootNode.addChild(mangNode);
        }
        if (!requiredNpmLibs.isEmpty()) {
            NamedNode npmNode = new NamedNode(rootNode, (String)ExternalLibrariesActivator.EXTERNAL_LIBRARY_NAMES.get("node_modules"), image);
            npmNode.addChild((Iterable<Object>)FluentIterable.from(requiredNpmLibs).transform(p -> new BuiltInProjectNode(npmNode, (IN4JSProject)p)));
            rootNode.addChild(npmNode);
        }
        if (Arrays2.isEmpty((Object[])rootNode.getChildren())) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = rootNode;
        }
        return nodeArray;
    }

    private Iterable<IN4JSProject> getExternalDependenciesOfType(Iterable<? extends IN4JSProject> dependencies, ProjectType type, ProjectType ... others) {
        EnumSet<ProjectType[]> allowedTypes = EnumSet.of(type, others);
        return FluentIterable.from(dependencies).filter(p -> p.exists() && p.isExternal()).filter(p -> allowedTypes.contains(p.getProjectType())).filter(IN4JSProject.class);
    }

    private Map<String, IN4JSProject> getAvailableNpmProjects() {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(this.getBuiltInLibraries("node_modules")), p -> p.getProjectName());
    }

    private Map<String, IN4JSProject> getAvailableLangProjects() {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(this.getBuiltInLibraries("lang")), p -> p.getProjectName());
    }

    private Map<String, IN4JSProject> getAvailableMangelhaftProjects() {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(this.getBuiltInLibraries("mangelhaft")), p -> p.getProjectName());
    }

    private Map<String, IN4JSProject> getBuiltInRuntimeEnvironments() {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(this.getBuiltInLibraries("runtime")).filter(p -> ProjectType.RUNTIME_ENVIRONMENT.equals((Object)p.getProjectType())), p -> p.getProjectName());
    }

    private Map<String, IN4JSProject> getBuiltInRuntimeLibraries() {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(this.getBuiltInLibraries("runtime")).filter(p -> ProjectType.RUNTIME_LIBRARY.equals((Object)p.getProjectType())), p -> p.getProjectName());
    }

    private Iterable<IN4JSProject> getBuiltInLibraries(String externalLibraryName) {
        java.net.URI location = (java.net.URI)((BiMap)ExternalLibrariesActivator.EXTERNAL_LIBRARIES_SUPPLIER.get()).inverse().get((Object)externalLibraryName);
        return location != null ? FluentIterable.from((Iterable)this.externalLibraryWorkspace.getProjectsIn(location)).filter(IExternalResource.class).transform(r -> r.getExternalResource()).transform(file -> URI.createFileURI((String)file.getAbsolutePath())).transform(uri -> (IN4JSProject)this.core.findProject(uri).orNull()).filter(IN4JSProject.class) : Collections.emptyList();
    }
}

