/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.extension;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.tester.ITester;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.extension.EclipseTesterDescriptor;
import org.eclipse.n4js.tester.extension.ITesterDescriptor;

@Singleton
public class TesterRegistry {
    private static final Logger log = Logger.getLogger(TesterRegistry.class);
    public static final String TESTERS_EXTENSION_POINT_ID = "org.eclipse.n4js.tester.testers";
    private final Map<String, ITesterDescriptor> descriptors = new HashMap<String, ITesterDescriptor>();
    private boolean isInitialized = false;
    @Inject
    private Injector injector;

    public void register(ITesterDescriptor testerDescriptor) {
        String testerId = testerDescriptor.getId();
        if (this.descriptors.containsKey(testerId)) {
            throw new IllegalArgumentException("cannot register two testers with the same ID: " + testerId);
        }
        this.descriptors.put(testerId, testerDescriptor);
    }

    public Map<String, ITesterDescriptor> getDescriptors() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return Collections.unmodifiableMap(this.descriptors);
    }

    public ITesterDescriptor getDescriptor(String testerId) {
        ITesterDescriptor result = this.getDescriptors().get(testerId);
        if (result == null) {
            throw new IllegalArgumentException("no tester found for ID: " + testerId);
        }
        return result;
    }

    public ITester getTester(String testerId) {
        return this.getDescriptor(testerId).getTester();
    }

    public ITester getTester(TestConfiguration testConfig) {
        String testerId = testConfig.getTesterId();
        if (testerId == null || testerId.trim().isEmpty()) {
            throw new IllegalArgumentException("no tester ID defined in given test configuration");
        }
        return this.getTester(testerId);
    }

    private void initialize() {
        if (this.isInitialized) {
            throw new IllegalStateException("may invoke method initialize() only once");
        }
        this.isInitialized = true;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] configElems;
            IConfigurationElement[] iConfigurationElementArray = configElems = registry.getConfigurationElementsFor(TESTERS_EXTENSION_POINT_ID);
            int n = configElems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    EclipseTesterDescriptor descriptor = new EclipseTesterDescriptor(elem);
                    this.injector.injectMembers((Object)descriptor);
                    this.register(descriptor);
                }
                catch (Exception ex) {
                    log.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.tester.testers", (Throwable)ex);
                }
                ++n2;
            }
        }
    }

    public void reset() {
        this.isInitialized = false;
        this.descriptors.clear();
    }
}

