/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ModuleSpecifierAdjustment;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.projectDescription.ModuleLoader;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ModuleWrappingTransformationNEW
extends Transformation {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceNameComputer resourceNameComputer;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<ImportDeclaration> _function = it -> this.transformImportDecl((ImportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ImportDeclaration.class, false).forEach(_function);
        Functions.Function1 _function_1 = it -> it.getExportedElement();
        Consumer<ModifiableElement> _function_2 = it -> it.getDeclaredModifiers().clear();
        Iterables.filter((Iterable)ListExtensions.map((List)this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false), (Functions.Function1)_function_1), ModifiableElement.class).forEach(_function_2);
        Consumer<ExportDeclaration> _function_3 = it -> this.splitDefaultExportFromVarDecl((ExportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false).forEach(_function_3);
        this.addEmptyImport("n4js-node");
    }

    private void transformImportDecl(ImportDeclaration importDeclIM) {
        TModule module = this.getState().info.getImportedModule(importDeclIM);
        String actualModuleSpecifier = this.computeActualModuleSpecifier(module);
        String actualModuleSpecifierNormalized = actualModuleSpecifier.replace("/./", "/");
        importDeclIM.setModuleSpecifierAsText(actualModuleSpecifierNormalized);
    }

    private String computeActualModuleSpecifier(TModule module) {
        String definedPackageName;
        ModuleSpecifierAdjustment moduleSpecifierAdjustment = this.getModuleSpecifierAdjustment(module);
        if (moduleSpecifierAdjustment != null && moduleSpecifierAdjustment.usePlainModuleSpecifier) {
            return module.getModuleSpecifier();
        }
        String completeModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(module);
        IN4JSProject depProject = (IN4JSProject)this.n4jsCore.findProject(module.eResource().getURI()).orNull();
        if (depProject != null && depProject.getProjectType() == ProjectType.DEFINITION && (definedPackageName = depProject.getDefinesPackageName()) != null) {
            depProject = (IN4JSProject)this.n4jsCore.findAllProjectMappings().get(definedPackageName);
        }
        if (depProject != null) {
            String projectName = depProject.getProjectName();
            String outputPath = depProject.getOutputPath();
            if (projectName != null && outputPath != null) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)outputPath);
                if (_isNullOrEmpty) {
                    outputPath = "/";
                } else {
                    boolean _endsWith;
                    boolean _not_1;
                    boolean _not;
                    boolean _startsWith = outputPath.startsWith("/");
                    boolean bl = _not = !_startsWith;
                    if (_not) {
                        outputPath = "/" + outputPath;
                    }
                    boolean bl2 = _not_1 = !(_endsWith = outputPath.endsWith("/"));
                    if (_not_1) {
                        outputPath = String.valueOf(outputPath) + "/";
                    }
                }
                return String.valueOf(projectName) + outputPath + completeModuleSpecifier;
            }
        }
        return completeModuleSpecifier;
    }

    private ModuleSpecifierAdjustment getModuleSpecifierAdjustment(TModule module) {
        boolean _not;
        URI resourceURI;
        Resource _eResource = null;
        if (module != null) {
            _eResource = module.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        if ((resourceURI = _uRI) == null) {
            return null;
        }
        Optional project = this.n4jsCore.findProject(resourceURI);
        boolean _isPresent = project.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            return null;
        }
        ModuleLoader loader = ((IN4JSProject)project.get()).getModuleLoader();
        if (loader == null) {
            return null;
        }
        ModuleSpecifierAdjustment adjustment = (ModuleSpecifierAdjustment)N4JSLanguageConstants.MODULE_LOADER_PREFIXES.get(loader);
        return adjustment;
    }

    private void splitDefaultExportFromVarDecl(ExportDeclaration exportDecl) {
        ExportableElement exportedElement;
        boolean _isDefaultExport = exportDecl.isDefaultExport();
        if (_isDefaultExport && (exportedElement = exportDecl.getExportedElement()) instanceof VariableStatement) {
            boolean _greaterThan;
            boolean _not;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings(), VariableBinding.class));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                throw new UnsupportedOperationException("unsupported: default-exported variable binding");
            }
            int _size = ((VariableStatement)exportedElement).getVarDeclsOrBindings().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                throw new UnsupportedOperationException("unsupported: several default-exported variable declarations in a single export declaration");
            }
            VariableDeclarationOrBinding _head = (VariableDeclarationOrBinding)IterableExtensions.head((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings());
            VariableDeclaration varDecl = (VariableDeclaration)_head;
            SymbolTableEntry varDeclSTE = this.findSymbolTableEntryForElement((NamedElement)varDecl, true);
            this.insertBefore((EObject)exportDecl, new EObject[]{exportedElement});
            exportDecl.setDefaultExportedExpression((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)varDeclSTE));
        }
    }
}

