/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.config.Config;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.n4js.xpect.config.XpEnvironmentData;
import org.eclipse.n4js.xpect.ui.common.QuickFixTestHelper;
import org.eclipse.n4js.xpect.ui.common.XtextResourceCleanUtil;
import org.eclipse.n4js.xpect.ui.methods.contentassist.CommaSeparatedValuesExpectationCfg;
import org.eclipse.n4js.xpect.ui.methods.contentassist.CursorMarkerHelper;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilder;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilderHelper;
import org.eclipse.n4js.xpect.ui.methods.contentassist.RegionWithCursor;
import org.eclipse.n4js.xpect.ui.methods.contentassist.VarSubstExpectationCollection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.IExpectationRegion;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.CommaSeparatedValuesExpectationImpl;
import org.eclipse.xpect.expectation.impl.ExpectationCollection;
import org.eclipse.xpect.expectation.impl.StringExpectationImpl;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@XpectImport(value={N4JSOffsetAdapter.class, XpEnvironmentData.class, VarDef.class, Config.class, ValidationTestModuleSetup.class})
public class ContentAssistXpectMethod {
    private static final String MULTI_LINE_WILDCARD = "<...>";
    private static Logger logger;
    @Inject
    private N4ContentAssistProcessorTestBuilderHelper n4ContentAssistProcessorTestBuilderHelper;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
        logger = Logger.getLogger(ContentAssistXpectMethod.class);
    }

    @Xpect
    @ParameterParser(syntax="( ('kind' arg3=STRING)? 'at' (arg2=STRING  ('apply' arg4=STRING)?  (arg5=ID)? )? )?")
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void contentAssist(IStringExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor offset, String kind, String selected, String mode) throws Exception {
        IExpectationRegion region;
        N4ContentAssistProcessorTestBuilder fixture = this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource);
        ICompletionProposal proposal = this.exactlyMatchingProposal(offset, fixture, selected);
        String before = resource.getParseResult().getRootNode().getText();
        IXtextDocument document = fixture.getDocument(XtextResourceCleanUtil.cleanXtextResource(resource), before);
        Optional<String> optionalMode = Optional.ofNullable(mode);
        if (optionalMode.isPresent()) {
            optionalMode.get().trim();
        }
        String after = this.applyProposal(proposal, document);
        boolean isMultiLineExpectation = this.getExpectationString(expectation).contains("\n");
        if (isMultiLineExpectation) {
            this.assertMultiLineExpectation(expectation, after);
            return;
        }
        QuickFixTestHelper.ChangeInfo changedLines = QuickFixTestHelper.extractSingleChangedLine(before, after);
        if (changedLines.isMoreThanOne()) {
            throw new AssertionError((Object)("more then one line changed: " + changedLines.asString()));
        }
        if (changedLines.isEmpty()) {
            throw new AssertionError((Object)"Nothing changed.");
        }
        String exp = changedLines.first().getAfter();
        Point selection = proposal.getSelection((IDocument)document);
        if (selection != null && CursorMarkerHelper.exists((region = ((AbstractExpectation)expectation).getRegion()).getRegionText(), "<|>")) {
            int newPos = selection.x - changedLines.first().getAfterOffset();
            exp = new StringBuilder(exp).insert(newPos, "<|>").toString();
        }
        expectation.assertEquals((Object)exp);
    }

    /*
     * Unable to fully structure code
     */
    private void assertMultiLineExpectation(IStringExpectation expectation, String actualStr) {
        expectedStr = this.getExpectationString(expectation);
        actualWithoutExpectationStr = actualStr.replace(expectedStr, "*** EXPECTATION REMOVED ***");
        expectedLines = expectedStr.trim().replace("\r", "").split("\n");
        actualLines = actualWithoutExpectationStr.trim().replace("\r", "").split("\n");
        Arrays2.transformInplace((Object[])expectedLines, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, trim(), (Ljava/lang/String;)Ljava/lang/String;)());
        Arrays2.transformInplace((Object[])actualLines, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, trim(), (Ljava/lang/String;)Ljava/lang/String;)());
        expectedLinesCount = expectedLines.length;
        actualLinesCount = actualLines.length;
        lastWasWildcard = false;
        ia = 0;
        ie = 0;
        while (ie < expectedLinesCount) {
            block8: {
                block7: {
                    expectedLine = expectedLines[ie];
                    isWildcard = expectedLine.equals("<...>");
                    if (!isWildcard && expectedLine.contains("<...>")) {
                        this.multiLineFailure("lines in expectation that contain <...> must not contain any other characters (except white-space)", expectedStr, actualWithoutExpectationStr);
                    }
                    if (!isWildcard) break block7;
                    nextExpectedLine = this.getNextNonWildcardLine((String[])expectedLines, ie);
                    if (nextExpectedLine != null) ** GOTO lbl23
                    ia = actualLinesCount;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        ++ia;
lbl23:
                        // 2 sources

                        ** while (ia < actualLinesCount && !actualLines[ia].equals((Object)nextExpectedLine))
                    }
lbl24:
                    // 1 sources

                    break block8;
                }
                v0 = actualLine = ia < actualLinesCount ? actualLines[ia++] : null;
                if (actualLine == null || !actualLine.equals(expectedLine)) {
                    if (actualLine == null || lastWasWildcard) {
                        this.multiLineFailure("could not find line " + (ie + 1) + " of expectation in actual result", expectedStr, actualWithoutExpectationStr);
                    } else {
                        this.multiLineFailure("mismatch when comparing line " + (ie + 1) + " of expectation to actual line \"" + (String)actualLine + "\"", expectedStr, actualWithoutExpectationStr);
                    }
                }
            }
            lastWasWildcard = isWildcard;
            ++ie;
        }
        if (ia < actualLinesCount) {
            this.multiLineFailure("expectation does not cover entire actual result (maybe use <...> at end of expectation)", expectedStr, actualWithoutExpectationStr);
        }
    }

    private String getNextNonWildcardLine(String[] lines, int startIndex) {
        int len = lines.length;
        while (startIndex < len && lines[startIndex].equals(MULTI_LINE_WILDCARD)) {
            ++startIndex;
        }
        return startIndex < len ? lines[startIndex] : null;
    }

    private void multiLineFailure(String msg, String expectedStr, String actualStr) {
        throw new AssertionError((Object)("multi-line expectation failed: " + msg + "\n=== Complete Expectation:\n" + expectedStr.trim() + "\n=== Complete Actual Result (with expectation string removed):\n" + actualStr.trim()));
    }

    private String getExpectationString(IStringExpectation expectation) {
        return ((StringExpectationImpl)expectation).getExpectation();
    }

    @Xpect
    @ParameterParser(syntax="( ('kind' arg4=STRING)? 'at' (arg2=STRING (arg3=ID  (arg5=STRING)?  (arg6=ID (arg7=ID)? )? )? )? )?")
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void contentAssistList(@CommaSeparatedValuesExpectation(quoted=true) ICommaSeparatedValuesExpectation expect, @ThisResource XtextResource resource, RegionWithCursor offset, String checkType, String kind, String selected, String mode, String orderMod, ISetupInitializer<XpEnvironmentData> uiTestRunInit) throws Exception {
        block29: {
            boolean ordered;
            XpEnvironmentData xpEnvData = new XpEnvironmentData();
            uiTestRunInit.initialize((Object)xpEnvData);
            xpEnvData.setResourceUnderTest(resource);
            CommaSeparatedValuesExpectationImpl csvE = (CommaSeparatedValuesExpectationImpl)expect;
            Pair<CommaSeparatedValuesExpectationImpl, CharSequence> exptectationAndText = this.expandVariables(csvE, xpEnvData);
            CommaSeparatedValuesExpectationImpl expectation = (CommaSeparatedValuesExpectationImpl)exptectationAndText.getKey();
            CharSequence expectedText = (CharSequence)exptectationAndText.getValue();
            List<String> proposals = this.getProposalDisplayStrings(resource, offset, kind);
            proposals.replaceAll(str -> str.replace(",", ""));
            if ("display".equals(checkType)) {
                List<String> candidates = proposals.stream().filter(p -> p.contains(selected)).collect(Collectors.toList());
                if (candidates.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("more then one proposal matches the selection '").append(selected).append("' matches:[");
                    candidates.forEach(m -> {
                        StringBuilder stringBuilder2 = sb.append((String)m).append(",");
                    });
                    sb.append("]");
                    throw new RuntimeException(sb.toString());
                }
                if (candidates.size() == 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("nothing matches the selection '").append(selected).append("' available are [");
                    candidates.forEach(m -> {
                        StringBuilder stringBuilder2 = sb.append((String)m).append(",");
                    });
                    sb.append("]");
                    throw new RuntimeException(sb.toString());
                }
                expectation.assertEquals(candidates);
                return;
            }
            if (!"proposals".equals(checkType)) break block29;
            boolean bl = ordered = "ordered" == orderMod || "ordered" == mode;
            if (mode == null) {
                if (ordered) {
                    this.assertExactlyOrdered(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), expectation);
                } else {
                    this.assertExactly(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), (ICommaSeparatedValuesExpectation)expectation);
                }
                return;
            }
            switch (mode) {
                case "exactly": 
                case "ordered": 
                case "": 
                case "unordered": {
                    if (ordered) {
                        this.assertExactlyOrdered(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), expectation);
                    } else {
                        this.assertExactly(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), (ICommaSeparatedValuesExpectation)expectation);
                    }
                    return;
                }
                case "contains": {
                    if (ordered) {
                        this.assertContainingMatchAllOrdered(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), expectation);
                    } else {
                        this.assertContainingMatchAll(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), (ICommaSeparatedValuesExpectation)expectation);
                    }
                    return;
                }
                case "not": {
                    this.assertNoMatch(proposals, QuickFixTestHelper.separateOnCommaAndQuote(expectedText), (ICommaSeparatedValuesExpectation)expectation);
                    return;
                }
            }
            throw new RuntimeException("unrecognized mode for proposal-test : '" + mode + "'");
        }
        throw new UnsupportedOperationException("unrecognized checktype: '" + checkType + "'");
    }

    private Pair<CommaSeparatedValuesExpectationImpl, CharSequence> expandVariables(CommaSeparatedValuesExpectationImpl csvE, XpEnvironmentData data) {
        IExpectationRegion region = csvE.getRegion();
        CharSequence doc = region.getDocument();
        CharSequence expectedText = null;
        expectedText = region.getLength() < 0 ? "" : doc.subSequence(region.getOffset(), region.getOffset() + region.getLength());
        CommaSeparatedValuesExpectationCfg cfg = new CommaSeparatedValuesExpectationCfg(csvE.getAnnotation());
        cfg.setData(data);
        VarSubstCommaSeparatedValuesExpectationImpl csvRet = new VarSubstCommaSeparatedValuesExpectationImpl(csvE, cfg);
        VarSubstExpectationCollection vseColl = new VarSubstExpectationCollection(data);
        vseColl.init(expectedText.toString());
        String expandedExpectedText = IteratorExtensions.join((Iterator)vseColl.iterator(), (CharSequence)",");
        return new Pair((Object)csvRet, (Object)expandedExpectedText);
    }

    private void assertNoMatch(List<String> proposals, List<String> forbidden, ICommaSeparatedValuesExpectation expectation) {
        final List<String> matched = this.computeMatches(proposals, forbidden);
        if (!matched.isEmpty()) {
            expectation.assertEquals((Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !matched.contains(input);
                }
            });
        }
    }

    private void assertExactlyOrdered(List<String> proposals, List<String> required, CommaSeparatedValuesExpectationImpl expectation) {
        this.assertContainingMatchAllOrdered(proposals, required, expectation);
        if (proposals.size() != required.size()) {
            throw new ComparisonFailure("Ambiguity: All required proposal (right side) could match the ones the system provides. But, at least two required labels matched the same proposal. Your requirement on the right side is to sloppy. Please provide more specific labels. See the full proposal display strings in the comparison", required.stream().collect(Collectors.joining(",")), proposals.stream().collect(Collectors.joining(",")));
        }
    }

    private void assertExactly(List<String> proposals, List<String> required, ICommaSeparatedValuesExpectation expectation) {
        if (proposals.size() != required.size()) {
            throw new ComparisonFailure("System provides " + proposals.size() + " proposals, expected have been " + required.size() + ".", required.stream().collect(Collectors.joining(",")), proposals.stream().collect(Collectors.joining(",")));
        }
        this.assertContainingMatchAll(proposals, required, expectation);
    }

    private void assertContainingMatchAll(List<String> proposals, List<String> required, ICommaSeparatedValuesExpectation exp) {
        List<String> matched = this.computeMatches(proposals, required);
        exp.assertEquals(matched);
    }

    private List<String> computeMatches(List<String> proposals, List<String> required) {
        ArrayList matched = Lists.newArrayList();
        required.forEach(r -> {
            if (proposals.stream().anyMatch(p -> p.contains((CharSequence)r))) {
                matched.add(r);
            }
        });
        return matched;
    }

    private void assertContainingMatchAllOrdered(List<String> proposals, List<String> required, CommaSeparatedValuesExpectationImpl exp) {
        ArrayList matched = Lists.newArrayList();
        HashMap<String, Integer> match2index = new HashMap<String, Integer>();
        int highestIdx = 0;
        int i = 0;
        while (i < required.size()) {
            String r = required.get(i);
            Optional<String> prop = proposals.stream().filter(p -> p.contains(r)).findFirst();
            if (prop.isPresent()) {
                int idx = proposals.indexOf(prop.get());
                matched.add(r);
                match2index.put(r, idx);
                highestIdx = Math.max(highestIdx, idx);
            }
            ++i;
        }
        List matchedOrder = match2index.entrySet().stream().sorted(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        }).map(sme -> (String)sme.getKey()).collect(Collectors.toList());
        CommaSeparatedValuesExpectationCfg cfg = new CommaSeparatedValuesExpectationCfg(exp.getAnnotation());
        cfg.setOrdered(true);
        CommaSeparatedValuesExpectationImpl expNCSV = new CommaSeparatedValuesExpectationImpl(exp, (CommaSeparatedValuesExpectation)cfg);
        expNCSV.assertEquals(matchedOrder);
    }

    private ICompletionProposal exactlyMatchingProposal(RegionWithCursor offset, N4ContentAssistProcessorTestBuilder fixture, String selected) {
        ICompletionProposal[] computeCompletionProposals = this.allProposalsAt(offset, fixture);
        List<ICompletionProposal> candidates = Arrays.stream(computeCompletionProposals).filter(proposal -> proposal.getDisplayString().contains(selected)).collect(Collectors.toList());
        if (candidates.size() > 1) {
            throw new AssertionFailedError("The selection of contentassist is not precise enough more then one assist matched the selection '" + selected + "': " + QuickFixTestHelper.asString2(candidates) + " Please be more precise.");
        }
        if (candidates.size() < 1) {
            throw new AssertionFailedError("No content assist matching the selection '" + selected + "' found. Available are " + QuickFixTestHelper.asString2(Arrays.asList(computeCompletionProposals)));
        }
        ICompletionProposal proposal2 = (ICompletionProposal)candidates.get(0);
        return proposal2;
    }

    private List<String> getProposalDisplayStrings(XtextResource resource, RegionWithCursor offset, String kind) throws Exception {
        if (kind != null && kind != "") {
            throw new UnsupportedOperationException("Proposals of a special kind=" + kind + " are not yet queried.");
        }
        ICompletionProposal[] computeCompletionProposals = this.allProposalsAt(offset, this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource));
        ArrayList result = Lists.newArrayList();
        ICompletionProposal[] iCompletionProposalArray = computeCompletionProposals;
        int n = computeCompletionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal iCompletionProposal = iCompletionProposalArray[n2];
            result.add(iCompletionProposal.getDisplayString().trim());
            ++n2;
        }
        return result;
    }

    private ICompletionProposal[] allProposalsAt(RegionWithCursor offset, N4ContentAssistProcessorTestBuilder fixture) {
        AtomicReference w = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            try {
                w.set(fixture.computeCompletionProposals(offset.getGlobalCursorOffset()));
            }
            catch (Exception e) {
                logger.warn((Object)"Cannot compute Completion Proposals", (Throwable)e);
            }
        });
        return (ICompletionProposal[])w.get();
    }

    private String applyProposal(ICompletionProposal proposal, IXtextDocument document) {
        return (String)document.modify(state -> {
            state.setValidationDisabled(false);
            if (!(proposal instanceof TemplateProposal)) {
                proposal.apply((IDocument)document);
            }
            return document.get();
        });
    }

    private static class VarSubstCommaSeparatedValuesExpectationImpl
    extends CommaSeparatedValuesExpectationImpl {
        public VarSubstCommaSeparatedValuesExpectationImpl(CommaSeparatedValuesExpectationImpl original, CommaSeparatedValuesExpectation annotation) {
            super(original, annotation);
        }

        protected ExpectationCollection createExpectationCollection() {
            CommaSeparatedValuesExpectation annotation = this.getAnnotation();
            VarSubstExpectationCollection exp = new VarSubstExpectationCollection(((CommaSeparatedValuesExpectationCfg)annotation).getData());
            exp.setCaseSensitive(annotation.caseSensitive());
            exp.setOrdered(annotation.ordered());
            exp.setQuoted(annotation.quoted());
            exp.setSeparator(',');
            exp.setWhitespaceSensitive(annotation.whitespaceSensitive());
            exp.init(this.getExpectation());
            return exp;
        }
    }
}

