/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class N4JSExternalValidator
extends AbstractN4JSDeclarativeValidator {
    private final List<? extends Triple<AnnotationDefinition, String, ? extends Class<? extends N4ClassifierDeclaration>>> PROVIDES_ANNOTATION_INFO = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Triple[]{Tuples.create((Object)AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION, (Object)"interfaces", N4InterfaceDeclaration.class), Tuples.create((Object)AnnotationDefinition.PROVIDES_INITIALZER, (Object)"classifiers", N4ClassifierDeclaration.class)}));
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkExternalClassesDefinedInN4JSDFile(N4ClassDeclaration clazz) {
        boolean _not;
        boolean _holdsExternalOnlyInDefinitionFile = this.holdsExternalOnlyInDefinitionFile((N4TypeDeclaration)clazz, "Classes");
        boolean bl = _not = !_holdsExternalOnlyInDefinitionFile;
        if (_not) {
            return;
        }
    }

    @Check
    public void checkExternalInterfacesDefinedInN4JSDFile(N4InterfaceDeclaration interfaceDecl) {
        boolean _not;
        boolean _holdsExternalOnlyInDefinitionFile = this.holdsExternalOnlyInDefinitionFile((N4TypeDeclaration)interfaceDecl, "Interfaces");
        boolean bl = _not = !_holdsExternalOnlyInDefinitionFile;
        if (_not) {
            return;
        }
    }

    @Check
    public void checkExternalEnumsDefinedInN4JSDFile(N4EnumDeclaration enumDecl) {
        boolean _not;
        boolean _holdsExternalOnlyInDefinitionFile = this.holdsExternalOnlyInDefinitionFile((N4TypeDeclaration)enumDecl, "Enumerations");
        boolean bl = _not = !_holdsExternalOnlyInDefinitionFile;
        if (_not) {
            return;
        }
    }

    private boolean holdsExternalOnlyInDefinitionFile(N4TypeDeclaration typeDecl, String typesName) {
        if (typeDecl.isExternal() && !this.jsVariantHelper.isExternalMode((EObject)typeDecl)) {
            String message = IssueCodes.getMessageForCLF_EXT_EXTERNAL_N4JSD(typesName);
            this.addIssue(message, (EObject)typeDecl, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_EXT_EXTERNAL_N4JSD", new String[0]);
            return false;
        }
        return true;
    }

    @Check
    public void checkProvidesDefaultImplementationAnnotation(N4MemberDeclaration memberDecl) {
        boolean _tripleEquals;
        String _name = memberDecl.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        for (Triple<AnnotationDefinition, String, ? extends Class<? extends N4ClassifierDeclaration>> triple : this.PROVIDES_ANNOTATION_INFO) {
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            if (AnnotationDefinition.PROVIDES_INITIALZER == triple.getFirst() && memberDecl instanceof N4SetterDeclaration) {
                return;
            }
            AnnotationDefinition annodef = (AnnotationDefinition)triple.getFirst();
            String typeName = (String)triple.getSecond();
            Class metaType = (Class)triple.getThird();
            boolean _hasAnnotation = annodef.hasAnnotation((AnnotableElement)memberDecl);
            if (!_hasAnnotation) continue;
            boolean _isExternalMode = this.jsVariantHelper.isExternalMode((EObject)memberDecl);
            boolean bl2 = _not = !_isExternalMode;
            if (_not) {
                String msg = IssueCodes.getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES(annodef.name, typeName);
                this.addIssue(msg, (EObject)memberDecl, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES", new String[0]);
                return;
            }
            N4ClassifierDefinition owner = memberDecl.getOwner();
            boolean _isInstance = metaType.isInstance(owner);
            boolean bl3 = _not_1 = !_isInstance;
            if (_not_1) {
                String msg_1 = IssueCodes.getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS(annodef.name, typeName);
                this.addIssue(msg_1, (EObject)memberDecl, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS", new String[0]);
                return;
            }
            boolean _hasAnnotation_1 = AnnotationDefinition.N4JS.hasAnnotation((AnnotableElement)owner);
            boolean bl4 = _not_2 = !_hasAnnotation_1;
            if (!_not_2) continue;
            String msg_2 = IssueCodes.getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES(annodef.name, typeName);
            this.addIssue(msg_2, (EObject)memberDecl, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES", new String[0]);
            return;
        }
    }

    @Check
    public void checkExternalFunctionsDefinedInN4JSDFile(FunctionDeclaration funDecl) {
        if (funDecl.isExternal() && !this.jsVariantHelper.isExternalMode((EObject)funDecl)) {
            String message = IssueCodes.getMessageForCLF_EXT_EXTERNAL_N4JSD("Functions");
            this.addIssue(message, (EObject)funDecl, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "CLF_EXT_EXTERNAL_N4JSD", new String[0]);
        }
    }

    @Check
    public void checkExternalVariableStatementAssigments(ExportedVariableStatement variableStatement) {
        if (variableStatement.isExternal() && !this.jsVariantHelper.isExternalMode((EObject)variableStatement)) {
            String message = IssueCodes.getMessageForCLF_EXT_EXTERNAL_N4JSD("Variables");
            this.addIssue(message, (EObject)variableStatement, "CLF_EXT_EXTERNAL_N4JSD");
        }
        Consumer<VariableDeclaration> _function = evd -> {
            if (this.jsVariantHelper.isExternalMode((EObject)evd) && evd.getExpression() != null) {
                String _xifexpression = null;
                boolean _isConst = evd.isConst();
                _xifexpression = _isConst ? "constant" : "variable";
                String mod = _xifexpression;
                String message_1 = IssueCodes.getMessageForCLF_EXT_VAR_NO_VAL(mod);
                this.addIssue(message_1, (EObject)evd, "CLF_EXT_VAR_NO_VAL");
            }
        };
        variableStatement.getVarDecl().forEach(_function);
    }

    @Check
    public Object checkAllowedElementsInN4JSDFile(EObject eo) {
        Object _xifexpression = null;
        if (this.jsVariantHelper.isExternalMode(eo) && eo.eContainer() instanceof Script) {
            Object _xblockexpression = null;
            boolean found = this.findUnallowedElement(eo);
            Object _xifexpression_1 = null;
            if (found) {
                this.handleUnallowedElement(eo);
            } else {
                Object _xifexpression_2 = null;
                if (eo instanceof ExportDeclaration) {
                    this.handleExportDeclaration((ExportDeclaration)eo);
                } else {
                    Object _xifexpression_3 = null;
                    if (!(eo instanceof AnnotationList || eo instanceof Annotation || eo instanceof EmptyStatement || eo instanceof ImportDeclaration)) {
                        _xifexpression_3 = null;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private void handleExportDeclaration(ExportDeclaration eo) {
        ExportableElement exported = eo.getExportedElement();
        this.holdsExternalImplementation(exported);
        boolean _matched = false;
        if (exported instanceof N4ClassDeclaration) {
            _matched = true;
            this.handleN4ClassDeclaration(eo, (N4ClassDeclaration)exported);
        }
        if (!_matched && exported instanceof N4InterfaceDeclaration) {
            _matched = true;
            this.handleN4InterfaceDeclaration(eo, (N4InterfaceDeclaration)exported);
        }
        if (!_matched && exported instanceof N4EnumDeclaration) {
            _matched = true;
            this.handleN4EnumDeclaration(eo, (N4EnumDeclaration)exported);
        }
        if (!_matched && exported instanceof FunctionDeclaration) {
            _matched = true;
            this.handleFunctionDeclaration(eo, (FunctionDeclaration)exported);
        }
    }

    private void handleN4ClassDeclaration(ExportDeclaration eo, N4ClassDeclaration exported) {
        this.validateClassifierIsExternal(exported.isExternal(), "classes", eo);
        boolean _hasAnnotation = AnnotationDefinition.N4JS.hasAnnotation((AnnotableElement)exported);
        if (_hasAnnotation) {
            this.validateExtensionOfNotAnnotatedClass(exported, eo);
            this.validateConsumptionOfNonAnnotatedInterfaces((Iterable<ParameterizedTypeRef>)exported.getImplementedInterfaceRefs(), eo, "classes");
        } else {
            ParameterizedTypeRef _superClassRef = exported.getSuperClassRef();
            TClass _hasExpectedTypes = null;
            if (_superClassRef != null) {
                _hasExpectedTypes = this.hasExpectedTypes(_superClassRef, TClass.class);
            }
            TClass superClass = _hasExpectedTypes;
            this.validateNonAnnotatedClassDoesntExtendN4Object(exported, superClass, eo);
            this.validateConsumptionOfNonExternalInterfaces((Iterable<ParameterizedTypeRef>)exported.getImplementedInterfaceRefs(), eo, "classes");
        }
        this.validateNoObservableAtClassifier(eo, (N4ClassifierDeclaration)exported, "classes");
        this.validateMembers((N4ClassifierDeclaration)exported, "classes");
    }

    private void handleN4InterfaceDeclaration(ExportDeclaration eo, N4InterfaceDeclaration exported) {
        boolean _hasAnnotation;
        if (Objects.equal((Object)exported.getTypingStrategy(), (Object)TypingStrategy.NOMINAL) || Objects.equal((Object)exported.getTypingStrategy(), (Object)TypingStrategy.DEFAULT)) {
            this.validateClassifierIsExternal(exported.isExternal(), "interfaces", eo);
        }
        if (_hasAnnotation = AnnotationDefinition.N4JS.hasAnnotation((AnnotableElement)exported)) {
            this.validateConsumptionOfNonAnnotatedInterfaces((Iterable<ParameterizedTypeRef>)exported.getSuperInterfaceRefs(), eo, "interfaces");
        } else {
            this.validateConsumptionOfNonExternalInterfaces((Iterable<ParameterizedTypeRef>)exported.getSuperInterfaceRefs(), eo, "interfaces");
        }
        this.validateNoObservableAtClassifier(eo, (N4ClassifierDeclaration)exported, "interfaces");
        this.validateMembers((N4ClassifierDeclaration)exported, "interfaces");
    }

    private void handleN4EnumDeclaration(ExportDeclaration eo, N4EnumDeclaration exported) {
        boolean _not;
        boolean _isStringBased = this.isStringBased(exported);
        boolean bl = _not = !_isStringBased;
        if (_not) {
            Functions.Function1 _function = it -> {
                String _value = it.getValue();
                return _value != null;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)exported.getLiterals(), (Functions.Function1)_function);
            for (N4EnumLiteral literal : _filter) {
                String message = IssueCodes.getMessageForCLF_EXT_LITERAL_NO_VALUE();
                this.addIssue(message, (EObject)literal, (EStructuralFeature)N4JSPackage.Literals.N4_ENUM_LITERAL__VALUE, "CLF_EXT_LITERAL_NO_VALUE", new String[0]);
            }
        }
    }

    private void handleFunctionDeclaration(ExportDeclaration eo, FunctionDeclaration exported) {
        boolean _tripleNotEquals;
        Block _body = exported.getBody();
        boolean bl = _tripleNotEquals = _body != null;
        if (_tripleNotEquals) {
            String message = IssueCodes.getMessageForCLF_EXT_FUN_NO_BODY();
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_FUN_NO_BODY", new String[0]);
        }
    }

    private boolean holdsExternalImplementation(ExportableElement element) {
        if (element instanceof AnnotableElement) {
            boolean _hasAnnotation = AnnotationDefinition.IGNORE_IMPLEMENTATION.hasAnnotation((AnnotableElement)element);
            if (_hasAnnotation) {
                return true;
            }
            boolean _hasAnnotation_1 = AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation((AnnotableElement)element);
            if (_hasAnnotation_1) {
                return this.holdsDefinedInRuntime(element);
            }
        }
        return true;
    }

    private boolean holdsDefinedInRuntime(ExportableElement element) {
        ProjectType projectType;
        Resource _eResource = null;
        if (element != null) {
            _eResource = element.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        IN4JSProject _get = (IN4JSProject)this.n4jsCore.findProject(_uRI).get();
        ProjectType _projectType = null;
        if (_get != null) {
            _projectType = _get.getProjectType();
        }
        if ((projectType = _projectType) == null || projectType == ProjectType.RUNTIME_ENVIRONMENT || projectType == ProjectType.RUNTIME_LIBRARY) {
            return true;
        }
        String message = IssueCodes.getMessageForCLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE();
        Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)element);
        this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE", new String[0]);
        return false;
    }

    private void validateNoObservableAtClassifier(ExportDeclaration ed, N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        boolean _hasAnnotation = AnnotationDefinition.OBSERVABLE.hasAnnotation((AnnotableElement)ed);
        if (_hasAnnotation) {
            String message = IssueCodes.getMessageForCLF_EXT_NO_OBSERV_ANNO(classesOrRolesOrInterface);
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)declaration);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_NO_OBSERV_ANNO", new String[0]);
        }
    }

    private void validateMembers(N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        this.validateNoBody(declaration, classesOrRolesOrInterface);
        this.validateNoFieldExpression(declaration, classesOrRolesOrInterface);
        this.validateNoObservableAtMember(declaration, classesOrRolesOrInterface);
        this.validateNoNfonAtMember(declaration, classesOrRolesOrInterface);
    }

    private void validateNoObservableAtMember(N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        Functions.Function1 _function = it -> AnnotationDefinition.OBSERVABLE.hasAnnotation((AnnotableElement)it);
        Iterable _filter = IterableExtensions.filter((Iterable)declaration.getOwnedMembers(), (Functions.Function1)_function);
        for (N4MemberDeclaration member : _filter) {
            String _firstUpper = StringExtensions.toFirstUpper((String)this.keywordProvider.keyword(member));
            String _plus = String.valueOf(_firstUpper) + "s";
            String message = IssueCodes.getMessageForCLF_EXT_METHOD_NO_ANNO(_plus, classesOrRolesOrInterface, "Observable");
            this.addIssue(message, (EObject)member, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_METHOD_NO_ANNO", new String[0]);
        }
    }

    private void validateNoNfonAtMember(N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        Functions.Function1 _function = it -> AnnotationDefinition.NFON.hasAnnotation((AnnotableElement)it);
        Iterable _filter = IterableExtensions.filter((Iterable)declaration.getOwnedMembers(), (Functions.Function1)_function);
        for (N4MemberDeclaration member : _filter) {
            String _firstUpper = StringExtensions.toFirstUpper((String)this.keywordProvider.keyword(member));
            String _plus = String.valueOf(_firstUpper) + "s";
            String message = IssueCodes.getMessageForCLF_EXT_METHOD_NO_ANNO(_plus, classesOrRolesOrInterface, "Nfon");
            this.addIssue(message, (EObject)member, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_METHOD_NO_ANNO", new String[0]);
        }
    }

    private void validateNoFieldExpression(N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        Functions.Function1 _function = it -> {
            Expression _expression = it.getExpression();
            return _expression != null;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)declaration.getOwnedFields(), (Functions.Function1)_function);
        for (N4FieldDeclaration member : _filter) {
            String message = IssueCodes.getMessageForCLF_EXT_NO_FIELD_EXPR(classesOrRolesOrInterface);
            this.addIssue(message, (EObject)member, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_NO_FIELD_EXPR", new String[0]);
        }
    }

    private void validateNoBody(N4ClassifierDeclaration declaration, String classesOrRolesOrInterface) {
        Functions.Function1 _function = it -> !(it instanceof N4FieldDeclaration);
        Functions.Function1 _function_1 = it -> {
            Block _body = this.getBody((N4MemberDeclaration)it);
            return _body != null;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)declaration.getOwnedMembers(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (N4MemberDeclaration member : _filter) {
            String _firstUpper = StringExtensions.toFirstUpper((String)this.keywordProvider.keyword(member));
            String _plus = String.valueOf(_firstUpper) + "s";
            String message = IssueCodes.getMessageForCLF_EXT_NO_METHOD_BODY(_plus, classesOrRolesOrInterface);
            this.addIssue(message, (EObject)member, (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_EXT_NO_METHOD_BODY", new String[0]);
        }
    }

    private void validateNonAnnotatedClassDoesntExtendN4Object(N4ClassDeclaration exported, TClass superType, ExportDeclaration eo) {
        if (superType != null && !superType.isExternal()) {
            String message = IssueCodes.getMessageForCLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT();
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT", new String[0]);
        }
    }

    private void validateClassifierIsExternal(boolean external, String classifiers, ExportDeclaration eo) {
        if (!external) {
            String message = IssueCodes.getMessageForCLF_EXT_EXTERNAL(classifiers);
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_EXTERNAL", new String[0]);
        }
    }

    private void validateExtensionOfNotAnnotatedClass(N4ClassDeclaration exportedWithN4JSAnnotation, ExportDeclaration eo) {
        TClass superClass = this.getSuperClassType(exportedWithN4JSAnnotation);
        if (superClass != null) {
            boolean _isExternal = superClass.isExternal();
            if (_isExternal) {
                this.validateSuperClassAnnotatedWithN4JS(superClass, eo);
            }
        } else {
            Type superType;
            ParameterizedTypeRef _superClassRef = exportedWithN4JSAnnotation.getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            if ((superType = _declaredType) != null && !"N4Object".equals(superType.getName()) && !this.isSubtypeOfError(superType)) {
                this.handleSuperClassNotAnnotatedWithN4JS(eo);
            }
        }
    }

    private boolean isSubtypeOfError(Type type) {
        Functions.Function1 _function;
        Functions.Function1 toPrototype = _function = t -> {
            TObjectPrototype _xifexpression = null;
            _xifexpression = t instanceof TObjectPrototype ? (TObjectPrototype)t : null;
            return _xifexpression;
        };
        TObjectPrototype prototype = (TObjectPrototype)toPrototype.apply((Object)type);
        while (prototype != null) {
            boolean _tripleEquals;
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)prototype);
            TObjectPrototype _errorType = RuleEnvironmentExtensions.errorType(G);
            boolean bl = _tripleEquals = _errorType == prototype;
            if (_tripleEquals) {
                return true;
            }
            ParameterizedTypeRef _superType = null;
            if (prototype != null) {
                _superType = prototype.getSuperType();
            }
            Type _declaredType = null;
            if (_superType != null) {
                _declaredType = _superType.getDeclaredType();
            }
            prototype = (TObjectPrototype)toPrototype.apply((Object)_declaredType);
        }
        return false;
    }

    private void validateSuperClassAnnotatedWithN4JS(TClass classifier, ExportDeclaration eo) {
        boolean _not;
        boolean _hasAnnotation = AnnotationDefinition.N4JS.hasAnnotation((TAnnotableElement)classifier);
        boolean bl = _not = !_hasAnnotation;
        if (_not) {
            this.handleSuperClassNotAnnotatedWithN4JS(eo);
        }
    }

    private void handleSuperClassNotAnnotatedWithN4JS(ExportDeclaration eo) {
        String message = IssueCodes.getMessageForCLF_EXT_ANNOTATED_EXTEND();
        Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
        this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_ANNOTATED_EXTEND", new String[0]);
    }

    private TClass getSuperClassType(N4ClassDeclaration exported) {
        ParameterizedTypeRef _superClassRef = exported.getSuperClassRef();
        TClass _hasExpectedTypes = null;
        if (_superClassRef != null) {
            _hasExpectedTypes = this.hasExpectedTypes(_superClassRef, TClass.class);
        }
        return _hasExpectedTypes;
    }

    private void validateConsumptionOfNonAnnotatedInterfaces(Iterable<ParameterizedTypeRef> superInterfaces, ExportDeclaration eo, String classifiers) {
        Functions.Function1 _function = it -> this.hasExpectedTypes((ParameterizedTypeRef)it, (Class)TInterface.class);
        Functions.Function1 _function_1 = it -> it != null;
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map(superInterfaces, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (TInterface tinterface : _filter) {
            this.validateConsumptionOfNonExternalInterface(tinterface, classifiers, eo);
            this.validateConsumptionOfNonAnnotatedRole(tinterface, classifiers, eo);
        }
    }

    private void validateConsumptionOfNonAnnotatedRole(TInterface consumedRole, String classifiers, ExportDeclaration eo) {
        if (!AnnotationDefinition.N4JS.hasAnnotation((TAnnotableElement)consumedRole) && !Objects.equal((Object)consumedRole.getTypingStrategy(), (Object)TypingStrategy.STRUCTURAL)) {
            String message = IssueCodes.getMessageForCLF_EXT_ANNOTATED_CONSUME(classifiers);
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_ANNOTATED_CONSUME", new String[0]);
        }
    }

    private void validateConsumptionOfNonExternalInterfaces(Iterable<ParameterizedTypeRef> superInterfaces, ExportDeclaration eo, String classifiers) {
        Functions.Function1 _function = it -> this.hasExpectedTypes((ParameterizedTypeRef)it, (Class)TInterface.class);
        Functions.Function1 _function_1 = it -> it != null;
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map(superInterfaces, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (TInterface tinterface : _filter) {
            this.validateConsumptionOfNonExternalInterface(tinterface, classifiers, eo);
        }
    }

    private void validateConsumptionOfNonExternalInterface(TInterface tinterface, String classifiers, ExportDeclaration eo) {
        if (!tinterface.isExternal() && tinterface.getTypingStrategy() != TypingStrategy.STRUCTURAL) {
            String message = IssueCodes.getMessageForCLF_EXT_CONSUME_NON_EXT(classifiers);
            Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature((EObject)eo);
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_CONSUME_NON_EXT", new String[0]);
        }
    }

    private void handleUnallowedElement(EObject eo) {
        String message = IssueCodes.getMessageForCLF_EXT_UNALLOWED_N4JSD();
        Pair<? extends EObject, ? extends EStructuralFeature> eObjectToNameFeature = this.findNameFeature(eo);
        if (eObjectToNameFeature == null) {
            Pair<Integer, Integer> offsetAndLength = this.findOffsetAndLength(eo);
            this.addIssue(message, eo, (Integer)offsetAndLength.getKey(), (Integer)offsetAndLength.getValue(), "CLF_EXT_UNALLOWED_N4JSD");
        } else {
            this.addIssue(message, (EObject)eObjectToNameFeature.getKey(), (EStructuralFeature)eObjectToNameFeature.getValue(), "CLF_EXT_UNALLOWED_N4JSD", new String[0]);
        }
    }

    private <T extends Type> T hasExpectedTypes(ParameterizedTypeRef typeRef, Class<T> typeClazz) {
        Type type;
        Type _declaredType = null;
        if (typeRef != null) {
            _declaredType = typeRef.getDeclaredType();
        }
        if ((type = _declaredType) != null && typeClazz.isAssignableFrom(type.getClass())) {
            return (T)type;
        }
        return null;
    }

    private boolean findUnallowedElement(EObject eo) {
        boolean _isExternal_2;
        boolean _isExternal_1;
        boolean _isExternal;
        if (eo instanceof EmptyStatement) {
            return false;
        }
        if (eo instanceof ImportDeclaration) {
            return false;
        }
        if (eo instanceof Annotation) {
            return false;
        }
        if (eo instanceof ExportDeclaration) {
            return this.findUnallowedElement((EObject)((ExportDeclaration)eo).getExportedElement());
        }
        if (eo instanceof N4ClassDeclaration && (_isExternal = ((N4ClassDeclaration)eo).isExternal())) {
            return false;
        }
        if (eo instanceof N4InterfaceDeclaration && (((N4InterfaceDeclaration)eo).isExternal() || Objects.equal((Object)((N4InterfaceDeclaration)eo).getTypingStrategy(), (Object)TypingStrategy.STRUCTURAL))) {
            return false;
        }
        if (eo instanceof N4EnumDeclaration && (_isExternal_1 = ((N4EnumDeclaration)eo).isExternal())) {
            return false;
        }
        if (eo instanceof FunctionDeclaration && (_isExternal_2 = ((FunctionDeclaration)eo).isExternal())) {
            return false;
        }
        return !(eo instanceof VariableStatement);
    }

    private boolean isStringBased(N4EnumDeclaration enumDecl) {
        return AnnotationDefinition.STRING_BASED.hasAnnotation((AnnotableElement)enumDecl);
    }
}

