/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class CFEdge
extends Edge {
    public final TreeSet<ControlFlowType> cfTypes;
    public final boolean isDead;

    public CFEdge(String label, Node startNode, Node endNode, Set<ControlFlowType> cfTypes, boolean isDead) {
        super(label, false, startNode, (Collection<? extends Node>)Lists.newArrayList((Object[])new Node[]{endNode}), Collections.emptyList());
        this.isDead = isDead;
        this.cfTypes = new TreeSet<ControlFlowType>(cfTypes);
    }

    @Override
    public void paint(GC gc) {
        Node startNode = (Node)this.startNodes.get(0);
        Node endNode = (Node)this.endNodes.get(0);
        this.paintEdge(gc, startNode, endNode);
    }

    void paintEdge(GC gc, Node srcN, Node tgtN) {
        this.setColor(gc);
        Point src = srcN.getCenter();
        Point tgt = tgtN.getCenter();
        Point tgtB = srcN == tgtN ? this.paintSelfArc(gc, tgtN, tgt) : (this.isReverseArc(src, tgt) ? this.paintReverseArc(gc, srcN, tgtN, src, tgt) : this.paintArc(gc, srcN, tgtN, src, tgt));
        this.drawArrowHead(gc, tgt, tgtB);
    }

    void setColor(GC gc) {
        Display displ = Display.getCurrent();
        Color color = GraphUtils.getColor(50, 50, 50);
        if (this.isDead || this.cfTypes.contains(ControlFlowType.DeadCode)) {
            color = displ.getSystemColor(15);
        } else {
            for (ControlFlowType cfType : this.cfTypes) {
                switch (cfType) {
                    case Return: 
                    case Break: 
                    case Continue: 
                    case LoopEnter: 
                    case LoopReenter: 
                    case LoopInfinite: {
                        color = displ.getSystemColor(9);
                        break;
                    }
                    case Throw: {
                        color = displ.getSystemColor(3);
                        break;
                    }
                }
            }
        }
        gc.setForeground(color);
    }

    private Point paintArc(GC gc, Node srcN, Node tgtN, Point src, Point tgt) {
        Point ctr = this.getArcControlPoint(src, tgt);
        Rectangle tgtR = new Rectangle(tgtN.x - 2.0f, tgtN.y - 2.0f, tgtN.width + 1.0f, tgtN.height + 1.0f);
        Point tgtB = GraphUtils.pointOnRect(ctr, tgtR);
        Rectangle srcR = new Rectangle(srcN.x - 2.0f, srcN.y - 2.0f, srcN.width + 1.0f, srcN.height + 1.0f);
        Point srcB = GraphUtils.pointOnRect(ctr, srcR);
        this.drawLabel(gc, ctr);
        if (srcB == null || tgtB == null) {
            GraphUtils.drawLine(gc, src, tgt, false);
            return tgt;
        }
        GraphUtils.arc(gc, ctr, srcB, tgtB);
        return tgtB;
    }

    private Point paintSelfArc(GC gc, Node tgtN, Point tgt) {
        Point srcB = new Point(tgt.x + tgtN.width / 2.0f + 2.0f, tgt.y);
        Point tgtB = new Point(tgt.x, tgt.y - tgtN.height / 2.0f - 2.0f);
        Point tgtL = new Point(tgtB.x, tgtB.y - 20.0f);
        this.drawLabel(gc, tgtL);
        GraphUtils.arcSelf(gc, srcB, tgtB);
        return tgtB;
    }

    private Point paintReverseArc(GC gc, Node srcN, Node tgtN, Point src, Point tgt) {
        Point tgtB = new Point(tgt.x, tgt.y - tgtN.height / 2.0f - 2.0f);
        Point srcB = new Point(src.x, src.y + srcN.height / 2.0f + 1.0f);
        Point tgtL = new Point(tgtB.x, tgtB.y - 20.0f);
        this.drawLabel(gc, tgtL);
        GraphUtils.arcReversed(gc, srcB, tgtB);
        return tgtB;
    }

    private Point getArcControlPoint(Point src, Point tgt) {
        float reverser = this.isReverseArc(src, tgt) ? -1 : 1;
        float diffX = (src.x - tgt.x) / 2.0f;
        float diffY = (src.y - tgt.y) / 2.0f;
        float ctrX = src.x - diffX - reverser * diffY / 2.0f;
        float ctrY = src.y - diffY + reverser * diffX / 2.0f;
        Point ctr = new Point(ctrX, ctrY);
        return ctr;
    }

    private boolean isReverseArc(Point src, Point tgt) {
        boolean isReverse = src.x > tgt.x && src.y < tgt.y;
        return isReverse;
    }

    private void drawArrowHead(GC gc, Point tgt, Point tgtB) {
        float xx = (tgt.x - tgtB.x) / 2.0f;
        float yy = (tgt.y - tgtB.y) / 2.0f;
        float p1x = -yy - xx;
        float p1y = xx - yy;
        float p2x = yy - xx;
        float p2y = -xx - yy;
        float l = (float)(7.0 / Math.sqrt(p1x * p1x + p1y * p1y));
        Point arrP1 = new Point(tgtB.x + (p1x *= l), tgtB.y + (p1y *= l));
        Point arrP2 = new Point(tgtB.x + (p2x *= l), tgtB.y + (p2y *= l));
        gc.drawLine((int)tgtB.x, (int)tgtB.y, (int)arrP1.x, (int)arrP1.y);
        gc.drawLine((int)tgtB.x, (int)tgtB.y, (int)arrP2.x, (int)arrP2.y);
    }

    void drawLabel(GC gc, Point p) {
        this.label = "";
        for (ControlFlowType cfType : this.cfTypes) {
            switch (cfType) {
                case Return: 
                case Throw: 
                case Break: 
                case Continue: 
                case LoopEnter: 
                case LoopReenter: 
                case LoopInfinite: {
                    if (!this.label.isEmpty()) {
                        this.label = String.valueOf(this.label) + "|";
                    }
                    this.label = String.valueOf(this.label) + cfType.name();
                }
            }
        }
        org.eclipse.swt.graphics.Point size = gc.stringExtent(this.label);
        float x = p.x - (float)(size.x / 2);
        float y = p.y - (float)(size.y / 2);
        GraphUtils.drawString(gc, this.label, x, y);
    }
}

