/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractPartSelectionTracker {
    private ListenerList<ISelectionListener> fListeners = new ListenerList();
    private ListenerList<ISelectionListener> postListeners = new ListenerList();
    private String fPartId;

    public AbstractPartSelectionTracker(String partId) {
        this.setPartId(partId);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        this.postListeners.add((Object)listener);
    }

    public abstract ISelection getSelection();

    public void removeSelectionListener(ISelectionListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        this.postListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ListenerList<ISelectionListener> listenerList = this.fListeners;
        synchronized (listenerList) {
            Object[] objectArray = this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                this.fListeners.remove(listener);
                this.postListeners.remove(listener);
                ++n2;
            }
        }
    }

    protected void fireSelection(final IWorkbenchPart part, final ISelection sel) {
        for (final ISelectionListener l : this.fListeners) {
            if ((part == null || sel == null) && !(l instanceof INullSelectionListener)) continue;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(part, sel);
                }
            });
        }
    }

    protected void firePostSelection(final IWorkbenchPart part, final ISelection sel) {
        for (final ISelectionListener l : this.postListeners) {
            if ((part == null || sel == null) && !(l instanceof INullSelectionListener)) continue;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(part, sel);
                }
            });
        }
    }

    private void setPartId(String partId) {
        this.fPartId = partId;
    }

    protected String getPartId() {
        return this.fPartId;
    }
}

