/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.xtext.naming.QualifiedName;

public class SpecTestInfo
implements Comparable<SpecTestInfo> {
    private static final String NAME_WITH_UNDERSCORE = "(?:[^_]+(?:_?[^_])*)";
    private static final Pattern TEST_NAME_PATTERN = Pattern.compile("(?:test)?(?:(?:_?((?:[^_]+(?:_?[^_])*))__)|(?:_))?((?:[^_]+(?:_?[^_])*))(?:___((?:[^_]+(?:_?[^_])*)))?");
    private final QualifiedName methodName;
    public final Doclet doclet;
    public final RepoRelativePath rrp;
    public final String testeeName;
    public final String testTitle;
    public final String testCase;

    @VisibleForTesting
    static String[] parseName(QualifiedName methodName) {
        Matcher matcher = TEST_NAME_PATTERN.matcher(methodName.getLastSegment());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Test name does not match naming convention: " + methodName.getLastSegment());
        }
        return new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
    }

    public SpecTestInfo(String testeeName, QualifiedName methodName, Doclet doclet, RepoRelativePath rrp) {
        this.methodName = methodName;
        this.doclet = doclet;
        this.rrp = rrp;
        this.testeeName = testeeName;
        String[] parsedName = SpecTestInfo.parseName(methodName);
        this.testCase = SpecTestInfo.humanReadable(parsedName[2]);
        this.testTitle = SpecTestInfo.humanReadable(parsedName[1]);
    }

    public static final String humanReadable(String camelcaseOrUnderscoredString) {
        if (camelcaseOrUnderscoredString == null) {
            return null;
        }
        if (camelcaseOrUnderscoredString.indexOf(95) >= 0) {
            return camelcaseOrUnderscoredString.replaceAll("_", " ");
        }
        if (camelcaseOrUnderscoredString.toUpperCase().equals(camelcaseOrUnderscoredString)) {
            return camelcaseOrUnderscoredString;
        }
        StringBuilder strb = new StringBuilder();
        char p = '\u0000';
        int i = 0;
        while (i < camelcaseOrUnderscoredString.length()) {
            char c = camelcaseOrUnderscoredString.charAt(i);
            if (Character.isUpperCase(c) && p != '\u0000') {
                strb.append(' ');
                strb.append(Character.toLowerCase(c));
            } else {
                strb.append(c);
            }
            p = c;
            ++i;
        }
        return strb.toString();
    }

    @Override
    public int compareTo(SpecTestInfo o) {
        int d;
        int n = this.methodName != null ? this.methodName.compareTo(o.methodName) : (d = o.methodName != null ? -1 : 0);
        if (d == 0) {
            d = this.rrp != null ? this.rrp.compareTo(o.rrp) : (o.rrp != null ? -1 : 0);
        }
        return d;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpecTestInfo) {
            return this.compareTo((SpecTestInfo)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (this.methodName != null ? this.methodName.hashCode() : 0) * 31 + (this.rrp != null ? this.rrp.hashCode() : 0);
    }

    public CharSequence testModuleSpec() {
        return this.methodName.getSegment(0);
    }

    public String testMethodTypeName() {
        return this.methodName.getSegment(1);
    }

    public String testMethodName() {
        return this.methodName.getSegment(2);
    }
}

