/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS.extensions;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ExpressionExtensions {
    public static boolean isLeftHandSide(EObject subExpression) {
        if (subExpression == null || subExpression instanceof AssignmentExpression) {
            return false;
        }
        EObject expr = subExpression;
        while (expr.eContainer() != null && ExpressionExtensions.isPotentialEvalResult(expr.eContainer(), expr)) {
            expr = expr.eContainer();
        }
        return expr != null && expr.eContainer() instanceof AssignmentExpression && Objects.equal((Object)((AssignmentExpression)expr.eContainer()).getLhs(), (Object)expr);
    }

    public static boolean isIncOrDecTarget(EObject subExpression) {
        EObject _eContainer_2;
        UnaryExpression ue;
        if (subExpression == null || subExpression instanceof AssignmentExpression) {
            return false;
        }
        EObject expr = subExpression;
        while (expr.eContainer() != null && ExpressionExtensions.isPotentialEvalResult(expr.eContainer(), expr)) {
            expr = expr.eContainer();
        }
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof PostfixExpression) {
            return true;
        }
        EObject _eContainer_1 = expr.eContainer();
        return _eContainer_1 instanceof UnaryExpression && (Objects.equal((Object)(ue = (UnaryExpression)(_eContainer_2 = expr.eContainer())).getOp(), (Object)UnaryOperator.INC) || ue.getOp() == UnaryOperator.DEC);
    }

    public static boolean isBothReadFromAndWrittenTo(EObject expr) {
        boolean _isLeftHandSide = ExpressionExtensions.isLeftHandSide(expr);
        if (_isLeftHandSide) {
            AssignmentExpression a = (AssignmentExpression)EcoreUtil2.getContainerOfType((EObject)expr, AssignmentExpression.class);
            AssignmentOperator _op = a.getOp();
            return _op != AssignmentOperator.ASSIGN;
        }
        return ExpressionExtensions.isIncOrDecTarget(expr);
    }

    private static boolean _isPotentialEvalResult(EObject container, EObject childExpression) {
        return false;
    }

    private static boolean _isPotentialEvalResult(ParenExpression container, Expression childExpression) {
        return childExpression != null && childExpression.eContainer() == container;
    }

    private static boolean _isPotentialEvalResult(BinaryLogicalExpression container, Expression childExpression) {
        return childExpression != null && childExpression.eContainer() == container;
    }

    private static boolean _isPotentialEvalResult(CommaExpression container, Expression childExpression) {
        return container != null && IterableExtensions.last((Iterable)container.getExprs()) == childExpression;
    }

    private static boolean isPotentialEvalResult(EObject container, EObject childExpression) {
        if (container instanceof ParenExpression && childExpression instanceof Expression) {
            return ExpressionExtensions._isPotentialEvalResult((ParenExpression)container, (Expression)childExpression);
        }
        if (container instanceof BinaryLogicalExpression && childExpression instanceof Expression) {
            return ExpressionExtensions._isPotentialEvalResult((BinaryLogicalExpression)container, (Expression)childExpression);
        }
        if (container instanceof CommaExpression && childExpression instanceof Expression) {
            return ExpressionExtensions._isPotentialEvalResult((CommaExpression)container, (Expression)childExpression);
        }
        if (container != null && childExpression != null) {
            return ExpressionExtensions._isPotentialEvalResult(container, childExpression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(container, childExpression).toString());
    }
}

