/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson.model.edit;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONFactory;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.model.edit.IJSONDocumentModification;

public class PackageJsonModificationProvider {
    public static IJSONDocumentModification insertProjectDependencies(final Collection<String> dependencies) {
        return new IJSONDocumentModification(){

            @Override
            public void apply(JSONDocument document) {
                boolean _isEmpty = dependencies.isEmpty();
                if (_isEmpty) {
                    return;
                }
                JSONObject root = PackageJsonModificationProvider.getDocumentRoot(document);
                for (String dependency : dependencies) {
                    PackageJsonModificationProvider.addProjectDependency(root, dependency, "*");
                }
            }
        };
    }

    public static IJSONDocumentModification insertRequiredRuntimeLibraries(final Collection<String> runtimeLibraries) {
        return new IJSONDocumentModification(){

            @Override
            public void apply(JSONDocument document) {
                boolean _isEmpty = runtimeLibraries.isEmpty();
                if (_isEmpty) {
                    return;
                }
                JSONObject root = PackageJsonModificationProvider.getDocumentRoot(document);
                JSONObject n4jsSection = PackageJsonModificationProvider.getOrCreateN4JSSection(root);
                JSONArray requiredRuntimeLibrariesList = PackageJsonModificationProvider.getOrCreateArray(n4jsSection, PackageJsonProperties.REQUIRED_RUNTIME_LIBRARIES);
                for (String library : runtimeLibraries) {
                    requiredRuntimeLibrariesList.getElements().add((Object)JSONModelUtils.createStringLiteral((String)library));
                }
            }
        };
    }

    public static IJSONDocumentModification setExtendedRuntimeEnvironment(final String runtimeEnvironment) {
        return new IJSONDocumentModification(){

            @Override
            public void apply(JSONDocument document) {
                JSONObject root = PackageJsonModificationProvider.getDocumentRoot(document);
                JSONObject n4jsSection = PackageJsonModificationProvider.getOrCreateN4JSSection(root);
                JSONModelUtils.setProperty((JSONObject)n4jsSection, (String)PackageJsonProperties.EXTENDED_RUNTIME_ENVIRONMENT.name, (String)runtimeEnvironment);
            }
        };
    }

    public static IJSONDocumentModification setProjectType(final String projectType) {
        return new IJSONDocumentModification(){

            @Override
            public void apply(JSONDocument document) {
                JSONObject root = PackageJsonModificationProvider.getDocumentRoot(document);
                JSONObject n4jsSection = PackageJsonModificationProvider.getOrCreateN4JSSection(root);
                JSONModelUtils.setProperty((JSONObject)n4jsSection, (String)PackageJsonProperties.PROJECT_TYPE.name, (String)projectType);
            }
        };
    }

    private static JSONObject getDocumentRoot(JSONDocument document) {
        JSONValue content = document.getContent();
        if (!(content instanceof JSONObject)) {
            URI _uRI = document.eResource().getURI();
            String _plus = "The given resource does not represent a valid package.json file.Make sure the document root is a JSON object. (URI=" + _uRI;
            String _plus_1 = String.valueOf(_plus) + ")";
            throw new IllegalArgumentException(_plus_1);
        }
        return (JSONObject)content;
    }

    public static void addProjectDependency(JSONObject root, String projectName, String versionConstraint) {
        JSONModelUtils.setPath((JSONObject)root, Arrays.asList(PackageJsonProperties.DEPENDENCIES.name, projectName), (JSONValue)JSONModelUtils.createStringLiteral((String)versionConstraint));
    }

    private static JSONArray getOrCreateArray(JSONObject root, PackageJsonProperties property) {
        Supplier<JSONValue> _function = () -> JSONModelUtils.addProperty((JSONObject)root, (String)packageJsonProperties.name, (JSONValue)JSONFactory.eINSTANCE.createJSONArray());
        JSONValue _orElseGet = JSONModelUtils.getProperty((JSONObject)root, (String)property.name).orElseGet(_function);
        return (JSONArray)_orElseGet;
    }

    private static JSONObject getOrCreateObject(JSONObject root, PackageJsonProperties property) {
        Supplier<JSONValue> _function = () -> JSONModelUtils.addProperty((JSONObject)root, (String)packageJsonProperties.name, (JSONValue)JSONFactory.eINSTANCE.createJSONObject());
        JSONValue _orElseGet = JSONModelUtils.getProperty((JSONObject)root, (String)property.name).orElseGet(_function);
        return (JSONObject)_orElseGet;
    }

    private static JSONObject getOrCreateN4JSSection(JSONObject root) {
        return PackageJsonModificationProvider.getOrCreateObject(root, PackageJsonProperties.N4JS);
    }
}

