/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource.packagejson;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.extension.IJSONResourceDescriptionExtension;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PackageJsonResourceDescriptionExtension
implements IJSONResourceDescriptionExtension {
    private static final String SEPARATOR = "/";
    public static final String PROJECT_NAME_KEY = "projectName";
    public static final String PROJECT_VERSION_KEY = "projectVersion";
    private static final String PROJECT_TYPE_KEY = "projectType";
    private static final String IMPLEMENTATION_ID_KEY = "implementationId";
    private static final String TESTED_PROJECT_NAMES_KEY = "testedProjectNames";
    private static final String IMPLEMENTED_PROJECT_NAMES_KEY = "implementedProjectNames";
    private static final String PROJECT_DEPENDENCY_NAMES_KEY = "projectDependencyNames";
    private static final String PROVIDED_RUNTIME_LIBRARY_NAMES_KEY = "providedRuntimeLibraryNames";
    private static final String REQUIRED_RUNTIME_LIBRARY_NAMES_KEY = "requiredRuntimeLibraryNames";
    private static final String EXTENDED_RUNTIME_ENVIRONMENT_NAME_KEY = "extendedRuntimeEnvironmentName";
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    private static final Logger LOGGER = Logger.getLogger(PackageJsonResourceDescriptionExtension.class);

    public boolean isToBeBuilt(URI uri, Resource resource) {
        boolean _not;
        boolean _isPackageJSON = PackageJsonResourceDescriptionExtension.isPackageJSON(uri);
        boolean bl = _not = !_isPackageJSON;
        if (_not) {
            return false;
        }
        int _depthOfLocation = this.n4jsCore.getDepthOfLocation(uri);
        return _depthOfLocation == 1;
    }

    public QualifiedName getFullyQualifiedName(EObject obj) {
        boolean _not;
        boolean _isPackageJSON = PackageJsonResourceDescriptionExtension.isPackageJSON(obj);
        boolean bl = _not = !_isPackageJSON;
        if (_not) {
            return null;
        }
        return this.qualifiedNameProvider.getFullyQualifiedName(obj);
    }

    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
        boolean _not;
        boolean _isPackageJSON = PackageJsonResourceDescriptionExtension.isPackageJSON(candidate);
        boolean bl = _not = !_isPackageJSON;
        if (_not) {
            return false;
        }
        Functions.Function1 _function = it -> it.getUri();
        Functions.Function1 _function_1 = it -> PackageJsonResourceDescriptionExtension.isPackageJSON(it);
        Functions.Function1 _function_2 = it -> PackageJsonResourceDescriptionExtension.getProjectNameFromPackageJSONUri(it);
        Set changedProjectNames = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(deltas, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        LinkedList referencedProjectNames = CollectionLiterals.newLinkedList();
        Consumer<IEObjectDescription> _function_3 = it -> {
            boolean _not_1;
            referencedProjectNames.addAll(PackageJsonResourceDescriptionExtension.getTestedProjectNames(it));
            referencedProjectNames.addAll(PackageJsonResourceDescriptionExtension.getImplementedProjectNames(it));
            referencedProjectNames.addAll(PackageJsonResourceDescriptionExtension.getProjectDependencyNames(it));
            referencedProjectNames.addAll(PackageJsonResourceDescriptionExtension.getProvidedRuntimeLibraryNames(it));
            referencedProjectNames.addAll(PackageJsonResourceDescriptionExtension.getRequiredRuntimeLibraryNames(it));
            String extRuntimeEnvironmentId = PackageJsonResourceDescriptionExtension.getExtendedRuntimeEnvironmentName(it);
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)extRuntimeEnvironmentId);
            boolean bl = _not_1 = !_isNullOrEmpty;
            if (_not_1) {
                referencedProjectNames.add(extRuntimeEnvironmentId);
            }
        };
        candidate.getExportedObjectsByType(JSONPackage.Literals.JSON_DOCUMENT).forEach(_function_3);
        for (String referencedProjectName : referencedProjectNames) {
            boolean _contains = changedProjectNames.contains(referencedProjectName);
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public void createJSONDocumentDescriptions(JSONDocument document, IAcceptor<IEObjectDescription> acceptor) {
        URI projectLocation;
        QualifiedName qualifiedName = this.getFullyQualifiedName((EObject)document);
        if (qualifiedName == null) {
            return;
        }
        Resource _eResource = null;
        if (document != null) {
            _eResource = document.eResource();
        }
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        URI _trimSegments = null;
        if (_uRI != null) {
            _trimSegments = _uRI.trimSegments(1);
        }
        if ((projectLocation = _trimSegments) == null) {
            LOGGER.error((Object)"creation of EObjectDescriptions failed: cannot derive project location from document");
            return;
        }
        ProjectDescription description = this.projectDescriptionLoader.loadProjectDescriptionAtLocation(projectLocation, document);
        if (description == null) {
            LOGGER.error((Object)("creation of EObjectDescriptions failed: cannot load project description at location: " + projectLocation));
            return;
        }
        Map<String, String> userData = this.createProjectDescriptionUserData(description);
        EObjectDescription _eObjectDescription = new EObjectDescription(qualifiedName, (EObject)document, userData);
        acceptor.accept((Object)_eObjectDescription);
    }

    private Map<String, String> createProjectDescriptionUserData(ProjectDescription it) {
        ProjectReference extRuntimeEnvironment;
        EList requiredRuntimeLibraries;
        boolean _isNullOrEmpty_4;
        boolean _not_4;
        EList providedRuntimeLibraries;
        boolean _isNullOrEmpty_3;
        boolean _not_3;
        EList projectDependencies;
        boolean _isNullOrEmpty_2;
        boolean _not_2;
        EList implementedProjects;
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        EList testedProjects;
        boolean _isNullOrEmpty;
        boolean _not;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        StringConcatenation _builder = new StringConcatenation();
        ProjectType _projectType = it.getProjectType();
        _builder.append((Object)_projectType);
        builder.put((Object)PROJECT_TYPE_KEY, (Object)_builder.toString());
        builder.put((Object)PROJECT_NAME_KEY, (Object)Strings.nullToEmpty((String)it.getProjectName()));
        builder.put((Object)IMPLEMENTATION_ID_KEY, (Object)Strings.nullToEmpty((String)it.getImplementationId()));
        VersionNumber vers = it.getProjectVersion();
        if (vers != null) {
            String versionStr = SemverSerializer.serialize((VersionNumber)vers);
            builder.put((Object)PROJECT_VERSION_KEY, (Object)versionStr);
        }
        boolean bl = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(testedProjects = it.getTestedProjects())));
        if (_not) {
            builder.put((Object)TESTED_PROJECT_NAMES_KEY, (Object)PackageJsonResourceDescriptionExtension.asString((Iterable<? extends ProjectReference>)testedProjects));
        }
        boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)(implementedProjects = it.getImplementedProjects())));
        if (_not_1) {
            builder.put((Object)IMPLEMENTED_PROJECT_NAMES_KEY, (Object)PackageJsonResourceDescriptionExtension.asString((Iterable<? extends ProjectReference>)implementedProjects));
        }
        boolean bl3 = _not_2 = !(_isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)(projectDependencies = it.getProjectDependencies())));
        if (_not_2) {
            builder.put((Object)PROJECT_DEPENDENCY_NAMES_KEY, (Object)PackageJsonResourceDescriptionExtension.asString((Iterable<? extends ProjectReference>)projectDependencies));
        }
        boolean bl4 = _not_3 = !(_isNullOrEmpty_3 = IterableExtensions.isNullOrEmpty((Iterable)(providedRuntimeLibraries = it.getProvidedRuntimeLibraries())));
        if (_not_3) {
            builder.put((Object)PROVIDED_RUNTIME_LIBRARY_NAMES_KEY, (Object)PackageJsonResourceDescriptionExtension.asString((Iterable<? extends ProjectReference>)providedRuntimeLibraries));
        }
        boolean bl5 = _not_4 = !(_isNullOrEmpty_4 = IterableExtensions.isNullOrEmpty((Iterable)(requiredRuntimeLibraries = it.getRequiredRuntimeLibraries())));
        if (_not_4) {
            builder.put((Object)REQUIRED_RUNTIME_LIBRARY_NAMES_KEY, (Object)PackageJsonResourceDescriptionExtension.asString((Iterable<? extends ProjectReference>)requiredRuntimeLibraries));
        }
        if ((extRuntimeEnvironment = it.getExtendedRuntimeEnvironment()) != null) {
            builder.put((Object)EXTENDED_RUNTIME_ENVIRONMENT_NAME_KEY, (Object)PackageJsonResourceDescriptionExtension.asString(Collections.singleton(it.getExtendedRuntimeEnvironment())));
        }
        return builder.build();
    }

    public static ProjectType getProjectType(IEObjectDescription it) {
        if (it == null) {
            return null;
        }
        String typeLiteral = it.getUserData(PROJECT_TYPE_KEY);
        if (typeLiteral == null) {
            return null;
        }
        return ProjectType.get((String)typeLiteral);
    }

    public static String getProjectName(IEObjectDescription it) {
        if (it == null) {
            return null;
        }
        return it.getUserData(PROJECT_NAME_KEY);
    }

    public static Set<String> getTestedProjectNames(IEObjectDescription it) {
        return PackageJsonResourceDescriptionExtension.getProjectNamesUserDataOf(it, TESTED_PROJECT_NAMES_KEY);
    }

    public static Set<String> getImplementedProjectNames(IEObjectDescription it) {
        return PackageJsonResourceDescriptionExtension.getProjectNamesUserDataOf(it, IMPLEMENTED_PROJECT_NAMES_KEY);
    }

    public static Set<String> getProjectDependencyNames(IEObjectDescription it) {
        return PackageJsonResourceDescriptionExtension.getProjectNamesUserDataOf(it, PROJECT_DEPENDENCY_NAMES_KEY);
    }

    public static Set<String> getProvidedRuntimeLibraryNames(IEObjectDescription it) {
        return PackageJsonResourceDescriptionExtension.getProjectNamesUserDataOf(it, PROVIDED_RUNTIME_LIBRARY_NAMES_KEY);
    }

    public static Set<String> getRequiredRuntimeLibraryNames(IEObjectDescription it) {
        return PackageJsonResourceDescriptionExtension.getProjectNamesUserDataOf(it, REQUIRED_RUNTIME_LIBRARY_NAMES_KEY);
    }

    public static String getExtendedRuntimeEnvironmentName(IEObjectDescription it) {
        if (it == null) {
            return null;
        }
        return it.getUserData(EXTENDED_RUNTIME_ENVIRONMENT_NAME_KEY);
    }

    private static Set<String> getProjectNamesUserDataOf(IEObjectDescription it, String key) {
        if (it == null) {
            return CollectionLiterals.emptySet();
        }
        return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)Strings.nullToEmpty((String)it.getUserData(key)).split(SEPARATOR))));
    }

    private static String asString(Iterable<? extends ProjectReference> it) {
        Functions.Function1 _function = it_1 -> it_1.getProjectName();
        return IterableExtensions.join((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull(it), (Functions.Function1)_function)), (CharSequence)SEPARATOR);
    }

    private static String getProjectNameFromPackageJSONUri(URI uri) {
        boolean _isPackageJSON = PackageJsonResourceDescriptionExtension.isPackageJSON(uri);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Expected URI with ");
        _builder.append("package.json");
        _builder.append(" as last segment. Was: ");
        _builder.append((Object)uri);
        Preconditions.checkArgument((boolean)_isPackageJSON, (Object)_builder);
        int _segmentCount = uri.segmentCount();
        int _minus = _segmentCount - 2;
        return uri.segment(_minus);
    }

    private static boolean isPackageJSON(IResourceDescription desc) {
        return desc != null && PackageJsonResourceDescriptionExtension.isPackageJSON(desc.getURI());
    }

    private static boolean isPackageJSON(EObject obj) {
        return obj != null && PackageJsonResourceDescriptionExtension.isPackageJSON(obj.eResource());
    }

    private static boolean isPackageJSON(Resource res) {
        return res != null && PackageJsonResourceDescriptionExtension.isPackageJSON(res.getURI());
    }

    private static boolean isPackageJSON(URI uri) {
        return uri != null && Objects.equal((Object)uri.lastSegment(), (Object)"package.json");
    }
}

