/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.util.Modules;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.n4js.N4JSRuntimeModule;
import org.eclipse.n4js.N4JSStandaloneSetup;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.BuildSetComputer;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4HeadlessCompiler;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.N4JSHeadlessGeneratorModule;
import org.eclipse.n4js.generator.headless.logging.ConfigurableHeadlessLogger;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.hlc.base.BuildType;
import org.eclipse.n4js.hlc.base.ErrorExitCode;
import org.eclipse.n4js.hlc.base.ExitCodeException;
import org.eclipse.n4js.hlc.base.HeadlessExtensionRegistrationHelper;
import org.eclipse.n4js.hlc.base.HlcFileUtils;
import org.eclipse.n4js.hlc.base.ProjectLocationsUtil;
import org.eclipse.n4js.hlc.base.SuccessExitStatus;
import org.eclipse.n4js.hlc.base.running.HeadlessRunner;
import org.eclipse.n4js.hlc.base.testing.HeadlessTester;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataCollectorCSVExporter;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.tester.CliTestTreeTransformer;
import org.eclipse.n4js.tester.TestCatalogSupplier;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.TesterModule;
import org.eclipse.n4js.tester.extension.TesterRegistry;
import org.eclipse.n4js.tester.internal.TesterActivator;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class N4jscBase
implements IApplication {
    private static final String N4JSC_PERFORMANCE_REPORT_ENV = "N4JSC_PERFORMANCE_REPORT";
    public static final String MARKER_RUNNER_OUPTUT = "======= =======";
    public static final String USAGE = "Usage: java -jar n4jsc.jar [options] FILE FILE ...";
    @Option(name="--help", aliases={"-h"}, usage="print help & exit")
    boolean help = false;
    @Option(name="--debug", usage="print information about the current setup of the compiler")
    boolean debug = false;
    @Option(name="--projectlocations", aliases={"-pl"}, metaVar="directory", required=false, usage="provide folder(s) to search for projects. If not set, the base folder of the running jvm will be taken as the location. Multiple folders can be given separated by the systems path-separator(: or ;). Only direct subfolders will be queried for projects.")
    String projectLocations;
    @Option(name="--preferences", usage="provide custom compiler preference settings stored in a *.properties file")
    File preferencesProperties;
    @Option(name="--buildType", aliases={"-bt"}, metaVar="type", usage="provide the type to build (defaults to dontcompile). \n'allprojects' compiles all projects found in the projectlocations, no other argument required. \n'projects' interprets the arguments as projects-folders and compiles them. \n'singlefile' interprets the arguments as paths to N4JS-source files and compiles only those both.\n'dontcompile' don't generate anything.")
    BuildType buildtype = BuildType.dontcompile;
    @Option(name="--testCatalogFile", aliases={"-tc"}, required=false, usage="if specified, a test catalog file will be generated to the given file location. The generated test catalog file will represent all tests that are available among the compiled sources. If the file does not exists at the given location, a new file will be created to the specified location. If a file already exists at the given location then the content of the existing file content will be replaced with the newly assembled test catalog. If an invalid file location is specified as the test catalog file output, then the catalog generation will fail.")
    File testCatalogFile;
    @Option(name="--targetPlatformInstallLocation", aliases={"-tl"}, required=false, usage="this flag is deprecated and will be ignored. Remove it from your scripts, it will become an error in the future.")
    File targetPlatformInstallLocation;
    @Option(name="--installMissingDependencies", aliases={"-imd"}, required=false, usage="usually projects have dependencies that have to be fetched before the compilation. If this flag is provided, compiler will calculate missing dependencies based on the manifest files of the projects provided as input to the compilation.Calculated missing dependencies will be fetched by Library Manager priori to the compilation.")
    boolean installMissingDependencies = false;
    @Option(name="--keepCompiling", usage="keep compiling - even if errors are encountered")
    boolean keepCompiling = false;
    @Option(name="--notests", usage="don't process test-folders")
    boolean notests = false;
    @Option(name="--testonly", usage="only transpile contents of test-folders")
    boolean testonly = false;
    @Option(name="--verbose", aliases={"-v"}, usage="verbose output during build")
    boolean verbose = false;
    @Option(name="--clean", aliases={"-c"}, required=false, usage="use this flag to indicate that the output folder should be cleaned before compilation. If this flag is activated, the flag -bt must be activated as well. This flag can NOT be used in combination with -bt singlefile.")
    boolean clean = false;
    @Option(name="--run", aliases={"-r"}, metaVar="pathToFileToRun", usage="path to the file that should be run after compilation.")
    File runThisFile = null;
    @Option(name="--runWith", aliases={"-rw"}, metaVar="runnerId", usage="ID of runner to use, last segment is sufficient, e.g. nodejs.")
    String runner = "nodejs";
    @Option(name="--systemLoader", aliases={"-sl"}, required=false, usage="when specified the given javascript system loader will be used for running the module. If not specified, the by default the System.js loader will be used. The following system loaders are available: sjs and cjs where sjs stands for System.js and cjs stands for Common JS.")
    String systemLoader;
    @Option(name="--nodejsLocation", required=false, usage="when configured then the Node.js binary located under the given absolute path will be used for executing modules. When specified then the absolute path of the folder that contains the Node.js binary should be specified. If not set, then the default /usr/local/bin (on Unix systems) or C:\\Program Files\\nodejs (on Windows systems) location will be used to look for the Node.js binary. ")
    File nodeJsBinaryRoot;
    @Option(name="--npmrcRootLocation", required=false, usage="when configured then the nprc setting used from given pathwill be used for installing npm packages modules. When specified then the absolute path of the folder that contains the '.npmrc' file should be specified. If not set, then the default to value specified by 'user.home' property value returned by java.lang.System ")
    File npmrcRoot;
    @Option(name="--listRunners", aliases={"-lr"}, usage="show list of available runners.")
    boolean listRunners = false;
    @Option(name="--test", aliases={"-t"}, metaVar="path", usage="path must point to a project, folder, or file containing tests.")
    File testThisLocation = null;
    @Option(name="--testReportRoot", required=false, usage="when provided, it is expected to be directory in which test report will be written.If test report already exists in that location it is removed overwritten. If not provided, test report generation is skipped.")
    File testReportRoot;
    @Option(name="--testWith", aliases={"-tw"}, metaVar="testerId", usage="ID of tester to use, last segment is sufficient, e.g. nodejs_mangelhaft")
    String tester = "nodejs_mangelhaft";
    @Option(name="--listTesters", aliases={"-lt"}, usage="show list of available testers")
    boolean listTesters = false;
    @Option(name="--implementationId", aliases={"-impl"}, metaVar="ID", required=false, usage="if there are API projects among the dependencies of the module to run, this specifies the ID of the implementation to use; only required when running/testing if there are API projects and there exists more than one implementation.")
    String implementationId = null;
    @Option(name="--log", required=false)
    boolean log = false;
    @Option(name="--logfile", required=false)
    String logFile = "n4jsc.log";
    @Option(name="--performanceReport", aliases={"-pR"}, required=false)
    File performanceReport = null;
    @Option(name="--performanceKey", aliases={"-pK"}, required=false)
    String performanceKey = "Headless N4JS Compiler";
    @Argument(multiValued=true, usage="filename of source (or project, see -bt) to compile")
    List<File> srcFiles = new ArrayList<File>();
    @Inject
    private N4HeadlessCompiler headless;
    @Inject
    private BuildSetComputer buildSetComputer;
    @Inject
    private HeadlessRunner headlessRunner;
    @Inject
    private HeadlessTester headlessTester;
    @Inject
    private TestCatalogSupplier testCatalogSupplier;
    @Inject
    private LibraryManager libManager;
    @Inject
    private TesterRegistry testerRegistry;
    @Inject
    private Provider<NodeJsBinary> nodeJsBinaryProvider;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;
    @Inject
    private BinariesPreferenceStore binariesPreferenceStore;
    @Inject
    private HeadlessExtensionRegistrationHelper headlessExtensionRegistrationHelper;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private FileBasedWorkspace workspace;

    public Object start(IApplicationContext context) throws Exception {
        int exitCode;
        try {
            String[] args = new String[]{"--help"};
            SuccessExitStatus success = new N4jscBase().doMain(args);
            exitCode = success.code;
        }
        catch (ExitCodeException e) {
            exitCode = e.getExitCode();
            System.err.println(String.valueOf(e.getMessage()) + " exitcode: " + exitCode + e.explanationOfExitCode());
        }
        System.out.flush();
        System.err.flush();
        return new Integer(exitCode);
    }

    public void stop() {
    }

    public static void main(String[] args) {
        int exitCode;
        try {
            SuccessExitStatus success = new N4jscBase().doMain(args);
            exitCode = success.code;
        }
        catch (ExitCodeException e) {
            exitCode = e.getExitCode();
            System.err.println(String.valueOf(e.getMessage()) + " exitcode: " + exitCode + e.explanationOfExitCode());
        }
        System.out.flush();
        System.err.flush();
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SuccessExitStatus doMain(String ... args) throws ExitCodeException {
        block53: {
            if (this.isPerformanceDataCollectionEnabled(args)) {
                CollectedDataAccess.setPaused((boolean)false);
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Measurement m = N4JSDataCollectors.dcHeadless.getMeasurement("Headless N4JS Compiler");
                    try {
                        Serializable performanceReportFile;
                        String msg;
                        CmdLineParser parser = new CmdLineParser((Object)this);
                        parser.getProperties().withUsageWidth(130);
                        try {
                            parser.parseArgument(args);
                        }
                        catch (CmdLineException e) {
                            System.err.println(e.getMessage());
                            N4jscBase.printExtendedUsage(parser, System.err);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        if (this.targetPlatformInstallLocation != null) {
                            N4jscBase.warn("WARNING: flag --targetPlatformInstallLocation is deprecated; this flag is being ignored and this message will become an error soon!");
                        }
                        if (this.debug) {
                            this.printDebugLines();
                        } else {
                            Logger.getRootLogger().removeAllAppenders();
                            Logger.getRootLogger().addAppender((Appender)new NullAppender());
                        }
                        if (this.help) {
                            N4jscBase.printExtendedUsage(parser, System.out);
                            return SuccessExitStatus.INSTANCE;
                        }
                        this.initInjection(this.refProperties());
                        this.headlessExtensionRegistrationHelper.registerExtensions();
                        if (this.listRunners) {
                            this.printAvailableRunners(System.out);
                            return SuccessExitStatus.INSTANCE;
                        }
                        if (this.listTesters) {
                            this.printAvailableTesters(System.out);
                            return SuccessExitStatus.INSTANCE;
                        }
                        StringJoiner sj = new StringJoiner(",");
                        Iterator<File> iterator = this.srcFiles.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                if (sj.toString().isEmpty()) break;
                                System.err.println("These source files or projects are invalid (neither file nor directory): " + sj.toString());
                                throw new ExitCodeException(ErrorExitCode.EXITCODE_SRCFILES_INVALID);
                            }
                            File srcFile = iterator.next();
                            if (srcFile.isFile() || srcFile.isDirectory()) continue;
                            sj.add(srcFile.toString());
                        }
                        EnumSet<BuildType> noSrcRequired = EnumSet.of(BuildType.allprojects, BuildType.dontcompile);
                        if (this.srcFiles.isEmpty() && !noSrcRequired.contains((Object)this.buildtype)) {
                            System.out.println("Missing arguments.");
                            N4jscBase.printExtendedUsage(parser, System.out);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        if (this.runThisFile != null && N4jscBase.isNotGiven(this.runner)) {
                            System.out.println("Missing arguments for running: runner must be named with option -rw");
                            N4jscBase.printExtendedUsage(parser, System.out);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        if (this.testThisLocation != null && N4jscBase.isNotGiven(this.tester)) {
                            System.out.println("Missing arguments for testing: tester must be named with option -tw");
                            N4jscBase.printExtendedUsage(parser, System.out);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        if (this.runThisFile != null && this.testThisLocation != null) {
                            System.out.println("Conflicting arguments: must not provide both -r and -t");
                            N4jscBase.printExtendedUsage(parser, System.out);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        if (this.testCatalogFile != null) {
                            if (this.testCatalogFile.exists()) {
                                if (this.testCatalogFile.isDirectory()) {
                                    msg = "The location of the test catalog file points to a directory and not to a file. " + this.testCatalogFile;
                                    System.out.println(msg);
                                    N4jscBase.printExtendedUsage(parser, System.out);
                                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR, msg);
                                }
                                if (!this.testCatalogFile.delete()) {
                                    msg = "Error while deleting existing test catalog file. " + this.testCatalogFile;
                                    System.out.println(msg);
                                    N4jscBase.printExtendedUsage(parser, System.out);
                                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR, msg);
                                }
                            }
                            try {
                                if (!this.testCatalogFile.createNewFile()) {
                                    msg = "Error while creating test catalog file at: " + this.testCatalogFile;
                                    System.out.println(msg);
                                    N4jscBase.printExtendedUsage(parser, System.out);
                                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR, msg);
                                }
                            }
                            catch (IOException e) {
                                System.out.println("Error while creating test catalog file. " + e.getMessage());
                                N4jscBase.printExtendedUsage(parser, System.out);
                                throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR, (Throwable)e);
                            }
                            if (!this.testCatalogFile.exists() || !this.testCatalogFile.canWrite()) {
                                msg = "Cannot access test catalog file at: " + this.testCatalogFile;
                                System.out.println(msg);
                                N4jscBase.printExtendedUsage(parser, System.out);
                                throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR, msg);
                            }
                        }
                        if (this.clean && (this.buildtype == BuildType.dontcompile || this.buildtype == BuildType.singlefile)) {
                            msg = "";
                            if (this.buildtype == BuildType.dontcompile) {
                                msg = "The flag -bt must be specified when --clean/-c is activated";
                            } else if (this.buildtype == BuildType.singlefile) {
                                msg = "The flag --clean/-c flag can not be used in combination with -bt singlefile";
                            }
                            System.out.println(msg);
                            N4jscBase.printExtendedUsage(parser, System.out);
                            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS);
                        }
                        SystemLoaderInfo systemLoaderType = SystemLoaderInfo.fromString((String)this.systemLoader);
                        if (systemLoaderType == null) {
                            this.systemLoader = SystemLoaderInfo.SYSTEM_JS.getId();
                        }
                        if (this.nodeJsBinaryRoot != null) {
                            this.binariesPreferenceStore.setPath((Binary)this.nodeJsBinaryProvider.get(), this.nodeJsBinaryRoot.toURI());
                            this.binariesPreferenceStore.save();
                        }
                        if (this.npmrcRoot != null) {
                            this.binariesPreferenceStore.setPath((Binary)this.npmrcBinaryProvider.get(), this.npmrcRoot.toURI());
                            this.binariesPreferenceStore.save();
                        }
                        if (this.performanceReport == null && System.getenv(N4JSC_PERFORMANCE_REPORT_ENV) != null) {
                            String rawPath = System.getenv(N4JSC_PERFORMANCE_REPORT_ENV);
                            performanceReportFile = new File(rawPath);
                            this.performanceReport = performanceReportFile;
                        }
                        if (this.performanceReport != null) {
                            System.out.println("Performance Data Collection is enabled.");
                        }
                        this.validateBinaries();
                        BuildSet buildSet = this.computeBuildSet();
                        this.registerProjects(buildSet);
                        if (this.clean) {
                            this.clean();
                            break block53;
                        }
                        if (this.installMissingDependencies) {
                            performanceReportFile = null;
                            Object var11_17 = null;
                            try (Measurement installMissingDepMeasurement = N4JSDataCollectors.dcHeadlessInstallMissingDeps.getMeasurement("Install missing dependencies");){
                                IStatus status = this.libManager.runNpmYarnInstallOnAllProjects((IProgressMonitor)new NullProgressMonitor());
                                if (!status.isOK()) {
                                    if (!this.keepCompiling) throw new ExitCodeException(ErrorExitCode.EXITCODE_DEPENDENCY_NOT_FOUND, "Cannot install dependencies: " + StatusUtils.getErrorMessage((IStatus)status, (boolean)false));
                                    N4jscBase.warn(status.getMessage());
                                }
                            }
                            catch (Throwable throwable2) {
                                if (performanceReportFile == null) {
                                    performanceReportFile = throwable2;
                                    throw performanceReportFile;
                                }
                                if (performanceReportFile == throwable2) throw performanceReportFile;
                                ((Throwable)performanceReportFile).addSuppressed(throwable2);
                                throw performanceReportFile;
                            }
                        }
                        BuildSet targetPlatformBuildSet = this.computeTargetPlatformBuildSet(buildSet.getAllProjects());
                        this.registerProjects(targetPlatformBuildSet);
                        buildSet = BuildSet.combineDiscovered((BuildSet)buildSet, (BuildSet)targetPlatformBuildSet);
                        this.doCompileAndTestAndRun(buildSet);
                    }
                    finally {
                        if (m == null) return SuccessExitStatus.INSTANCE;
                        m.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.dumpThrowable(e);
                throw e;
            }
        }
        this.writePerformanceReport();
        return SuccessExitStatus.INSTANCE;
    }

    private void clean() throws ExitCodeException {
        if (this.buildtype == BuildType.dontcompile) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS, "The flag -bt must be specified when cleaning");
        }
        try {
            switch (this.buildtype) {
                case projects: {
                    this.headless.cleanProjects(this.srcFiles);
                    break;
                }
                case allprojects: {
                    if (this.projectLocations == null) {
                        throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS, "Require option for projectlocations to clean all projects.");
                    }
                    if (!this.srcFiles.isEmpty()) {
                        N4jscBase.warn("The list of projects are ignored because we are cleaning all projects in  " + this.projectLocations);
                    }
                    ArrayList<File> toClean = new ArrayList<File>();
                    toClean.addAll(ProjectLocationsUtil.convertToFiles(this.projectLocations));
                    this.headless.cleanProjectsInSearchPath(toClean);
                }
            }
        }
        catch (N4JSCompileException e) {
            e.userDump(System.err);
            throw new ExitCodeException(ErrorExitCode.EXITCODE_CLEAN_ERROR);
        }
    }

    private void validateBinaries() throws ExitCodeException {
        IStatus status;
        if ((this.installMissingDependencies || this.runThisFile != null || this.testThisLocation != null) && !(status = ((NodeJsBinary)this.nodeJsBinaryProvider.get()).validate()).isOK()) {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                this.dumpThrowable(status.getException());
            }
            throw new ExitCodeException(ErrorExitCode.EXITCODE_CONFIGURATION_ERROR, status.getMessage(), status.getException());
        }
        if (this.installMissingDependencies && !(status = ((NpmBinary)this.npmBinaryProvider.get()).validate()).isOK()) {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                this.dumpThrowable(status.getException());
            }
            throw new ExitCodeException(ErrorExitCode.EXITCODE_CONFIGURATION_ERROR, status.getMessage(), status.getException());
        }
    }

    private void printAvailableRunners(PrintStream out) {
        if (this.testerRegistry.getDescriptors().isEmpty()) {
            out.println("No runners found.");
        } else {
            StringJoiner sj = new StringJoiner("\n\t");
            sj.add("Available runners are:");
            this.testerRegistry.getDescriptors().values().forEach(td -> {
                StringJoiner stringJoiner2 = sj.add(td.getId());
            });
            out.println(sj);
        }
    }

    private void printAvailableTesters(PrintStream out) {
        if (this.testerRegistry.getDescriptors().isEmpty()) {
            out.println("No testers found.");
        } else {
            StringJoiner sj = new StringJoiner("\n\t");
            sj.add("Available testers are:");
            this.testerRegistry.getDescriptors().values().forEach(td -> {
                StringJoiner stringJoiner2 = sj.add(td.getId());
            });
            out.println(sj);
        }
    }

    private static boolean isNotGiven(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void initInjection(Properties properties) {
        HeadlessStandloneSetup setup = new HeadlessStandloneSetup(properties);
        Injector injector = setup.createInjectorAndDoEMFRegistration();
        injector.injectMembers((Object)this);
        if (TesterActivator.getInstance() != null) {
            TesterActivator.getInstance().startupWithInjector(injector);
        }
    }

    private static void printExtendedUsage(CmdLineParser parser, PrintStream ps) {
        ps.println(USAGE);
        parser.printUsage((OutputStream)ps);
    }

    private void doCompileAndTestAndRun(BuildSet buildSet) throws ExitCodeException {
        if (this.debug) {
            System.out.println("N4JS compiling...");
        }
        this.compile(buildSet);
        this.writeTestCatalog();
        this.testAndRun(buildSet);
        if (this.debug) {
            System.out.println("... done.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compile(BuildSet buildSet) throws ExitCodeException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Measurement m = N4JSDataCollectors.dcHeadlessCompilation.getMeasurement("Compilation");
                try {
                    if (this.buildtype == BuildType.dontcompile) {
                        return;
                    }
                    this.headless.compile(buildSet);
                    return;
                }
                finally {
                    if (m == null) return;
                    m.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (N4JSCompileException e) {
            e.userDump(System.err);
            throw new ExitCodeException(ErrorExitCode.EXITCODE_COMPILE_ERROR, (Throwable)e);
        }
    }

    private void registerProjects(BuildSet buildSet) throws ExitCodeException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Measurement m = N4JSDataCollectors.dcHeadlessProjectRegistration.getMeasurement("Register projects");){
                this.headlessHelper.registerProjects(buildSet, this.workspace);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (N4JSCompileException e) {
            e.userDump(System.err);
            throw new ExitCodeException(ErrorExitCode.EXITCODE_COMPILE_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BuildSet computeBuildSet() throws ExitCodeException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BuildSet buildSet;
                Measurement m = N4JSDataCollectors.dcHeadlessBuildSetComputation.getMeasurement("Compute BuildSet");
                try {
                    switch (this.buildtype) {
                        case singlefile: {
                            buildSet = this.computeSingleFilesBuildSet();
                            return buildSet;
                        }
                        case projects: {
                            return this.computeProjectsBuildSet();
                        }
                        case allprojects: {
                            return this.computeAllProjectsBuildSet();
                        }
                    }
                    return this.computeAllProjectsBuildSet();
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (m == null) return buildSet;
                    m.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (N4JSCompileException e) {
            e.userDump(System.err);
            throw new ExitCodeException(ErrorExitCode.EXITCODE_COMPILE_ERROR);
        }
    }

    private BuildSet computeSingleFilesBuildSet() throws N4JSCompileException {
        ArrayList<File> toBuild = new ArrayList<File>();
        if (this.projectLocations != null) {
            toBuild.addAll(ProjectLocationsUtil.convertToFiles(this.projectLocations));
        }
        return this.buildSetComputer.createSingleFilesBuildSet(toBuild, this.srcFiles, Collections.emptySet());
    }

    private BuildSet computeProjectsBuildSet() throws N4JSCompileException {
        ArrayList<File> toBuild = new ArrayList<File>();
        if (this.projectLocations != null) {
            toBuild.addAll(ProjectLocationsUtil.convertToFiles(this.projectLocations));
        }
        return this.buildSetComputer.createProjectsBuildSet(toBuild, this.srcFiles, Collections.emptySet());
    }

    private BuildSet computeAllProjectsBuildSet() throws N4JSCompileException, ExitCodeException {
        if (this.projectLocations == null) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_WRONG_CMDLINE_OPTIONS, "Require option for projectlocations to compile all projects.");
        }
        if (!this.srcFiles.isEmpty()) {
            N4jscBase.warn("The list of source files is obsolete for built all projects. The following will be ignored: " + Joiner.on((String)", ").join(this.srcFiles));
        }
        ArrayList<File> toBuild = new ArrayList<File>();
        toBuild.addAll(ProjectLocationsUtil.convertToFiles(this.projectLocations));
        return this.buildSetComputer.createAllProjectsBuildSet(toBuild, Collections.emptySet());
    }

    private BuildSet computeTargetPlatformBuildSet(Collection<? extends IN4JSProject> workspaceProjects) throws ExitCodeException {
        LinkedHashSet<String> namesOfWorkspaceProjects = new LinkedHashSet<String>();
        LinkedList<Path> n4jsProjectPaths = new LinkedList<Path>();
        for (IN4JSProject iN4JSProject : workspaceProjects) {
            n4jsProjectPaths.add(iN4JSProject.getLocationPath());
            namesOfWorkspaceProjects.add(iN4JSProject.getProjectName());
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path nmPath : this.nodeModulesDiscoveryHelper.findNodeModulesFolders(n4jsProjectPaths)) {
            arrayList.add(nmPath.toFile());
        }
        try {
            return this.buildSetComputer.createBuildSet(arrayList, Collections.emptyList(), Collections.emptyList(), namesOfWorkspaceProjects);
        }
        catch (N4JSCompileException e) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_DEPENDENCY_NOT_FOUND, "Cannot compute build set for target platform location.", (Throwable)e);
        }
    }

    private void writeTestCatalog() throws ExitCodeException {
        if (this.testCatalogFile != null) {
            String catalog = this.testCatalogSupplier.get();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream fos = new FileOutputStream(this.testCatalogFile);){
                    fos.write(catalog.getBytes());
                    fos.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.out.println("Error while writing test catalog file at: " + this.testCatalogFile);
                throw new ExitCodeException(ErrorExitCode.EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR);
            }
        }
    }

    private void testAndRun(BuildSet buildSet) throws ExitCodeException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Measurement m = N4JSDataCollectors.dcHeadlessRunnerTester.getMeasurement("Execute tester/runner");){
            if (this.testThisLocation != null) {
                if (this.buildtype != BuildType.dontcompile) {
                    N4jscBase.flushAndIinsertMarkerInOutputs();
                }
                this.headlessTester.runTests(this.tester, this.implementationId, this.checkLocationToTest(), this.testReportRoot);
            }
            if (this.runThisFile != null) {
                if (this.buildtype != BuildType.dontcompile) {
                    N4jscBase.flushAndIinsertMarkerInOutputs();
                }
                LinkedList<Path> projectPaths = new LinkedList<Path>();
                LinkedList<String> additionalPaths = new LinkedList<String>();
                for (N4JSProject prj : buildSet.getAllProjects()) {
                    projectPaths.add(prj.getLocationPath());
                }
                List modulesFolders = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(projectPaths);
                for (Path nmFolder : modulesFolders) {
                    additionalPaths.add(nmFolder.toString());
                }
                this.headlessRunner.startRunner(this.runner, this.implementationId, this.systemLoader, this.checkFileToRun(), additionalPaths);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void flushAndIinsertMarkerInOutputs() {
        System.out.flush();
        System.err.flush();
        System.out.println(MARKER_RUNNER_OUPTUT);
        System.out.flush();
    }

    private URI checkFileToRun() throws ExitCodeException {
        if (this.runThisFile == null || !this.runThisFile.exists()) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_MODULE_TO_RUN_NOT_FOUND);
        }
        return HlcFileUtils.fileToURI(this.runThisFile);
    }

    private URI checkLocationToTest() throws ExitCodeException {
        if (this.testThisLocation == null || !this.testThisLocation.exists()) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_MODULE_TO_RUN_NOT_FOUND);
        }
        return HlcFileUtils.fileToURI(this.testThisLocation);
    }

    @Inject
    private N4HeadlessCompiler configHeadlessCompiler() {
        this.headless.setKeepOnCompiling(this.keepCompiling);
        this.headless.setCompileSourceCode(!this.testonly);
        this.headless.setProcessTestCode(!this.notests);
        if (this.log) {
            this.headless.setLogFile(this.logFile);
        }
        return this.headless;
    }

    protected static void warn(String msg) {
        if (msg == null) {
            return;
        }
        System.err.println(msg);
    }

    private Properties refProperties() throws ExitCodeException {
        if (this.preferencesProperties == null) {
            return null;
        }
        Properties ret = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream stream = new FileInputStream(this.preferencesProperties);){
                ret.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_CONFIGURATION_ERROR, "Cannot load preference-properties from given file " + this.preferencesProperties, (Throwable)e);
        }
        return ret;
    }

    private void printDebugLines() {
        int NL = 10;
        StringBuffer sb = new StringBuffer();
        sb.append("N4jsc.options=").append('\n').append("debug=").append(this.debug).append('\n').append("runner=").append(this.runner).append('\n').append("listRunners=").append(this.listRunners).append('\n').append("runThisFile=").append(this.runThisFile).append('\n').append("tester=").append(this.tester).append('\n').append("listTesters=").append(this.listTesters).append('\n').append("testThisLocation=").append(this.testThisLocation).append('\n').append("preferencesProperties=").append(this.preferencesProperties).append('\n').append("projectLocations=").append(this.projectLocations).append('\n').append("type=").append((Object)this.buildtype).append('\n').append("testCatalogFile=").append(this.testCatalogFile).append('\n').append("srcFiles=");
        sb.append(this.srcFiles.stream().map(f -> f.toString()).reduce((a, b) -> String.valueOf(a) + ", " + b).orElse("\u00f8")).append('\n');
        sb.append("testonly=").append(this.testonly).append('\n').append("notests=").append(this.notests).append('\n').append("verbose=").append(this.verbose).append('\n');
        sb.append("Current execution directory = " + new File(".").getAbsolutePath());
        System.out.println(sb.toString());
    }

    private void dumpThrowable(Throwable throwable) {
        System.err.println(Throwables.getStackTraceAsString((Throwable)throwable));
    }

    private boolean isPerformanceDataCollectionEnabled(String ... args) {
        List<String> arguments = Arrays.asList(args);
        return arguments.contains("-pR") || arguments.contains("--performanceReport") || System.getenv(N4JSC_PERFORMANCE_REPORT_ENV) != null;
    }

    private void writePerformanceReport() throws ExitCodeException {
        if (this.performanceReport != null) {
            System.out.println("Writing performance report to " + this.performanceReport.toPath().toAbsolutePath().toString());
            try {
                DataCollectorCSVExporter.toFile((File)this.performanceReport, (String)this.performanceKey);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ExitCodeException(ErrorExitCode.EXITCODE_PERFORMANCE_REPORT_COULD_NOT_BE_WRITTEN);
            }
        }
    }

    private class HeadlessStandloneSetup
    extends N4JSStandaloneSetup {
        private final Properties properties;

        public HeadlessStandloneSetup(Properties properties) {
            this.properties = properties;
        }

        public Injector createInjector() {
            Module combinedModule = Modules.combine((Module[])new Module[]{new N4JSRuntimeModule(), new TesterModule(), new N4JSHeadlessGeneratorModule(this.properties)});
            Module overridenModule = Modules.override((Module[])new Module[]{combinedModule}).with(new Module[]{binder -> {
                binder.bind(TestTreeTransformer.class).to(CliTestTreeTransformer.class);
                binder.bind(IHeadlessLogger.class).toInstance((Object)new ConfigurableHeadlessLogger(N4jscBase.this.verbose, N4jscBase.this.debug));
            }});
            return Guice.createInjector((Module[])new Module[]{overridenModule});
        }
    }
}

