/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.DirectPathAnalyses;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorAnalysis;
import org.eclipse.n4js.flowgraphs.analysis.SuccessorPredecessorAnalysis;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.factories.ControlFlowGraphFactory;
import org.eclipse.n4js.flowgraphs.model.FlowGraph;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.utils.N4JSDataCollectors;

public class N4JSFlowAnalyser {
    private static final Logger logger = Logger.getLogger(N4JSFlowAnalyser.class);
    private final Callable<Void> cancelledChecker;
    private FlowGraph cfg;
    private SymbolFactory symbolFactory;
    private DirectPathAnalyses dpa;
    private GraphVisitorAnalysis gva;
    private SuccessorPredecessorAnalysis spa;

    public N4JSFlowAnalyser() {
        this(null);
    }

    public N4JSFlowAnalyser(Callable<Void> cancelledChecker) {
        this.cancelledChecker = cancelledChecker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createGraphs(Script script) {
        Objects.requireNonNull(script);
        String uriString = script.eResource().getURI().toString();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Measurement m1 = N4JSDataCollectors.dcFlowGraphs.getMeasurement("flowGraphs_" + uriString);
            try {
                try (Measurement m2 = N4JSDataCollectors.dcCreateGraph.getMeasurement("createGraph_" + uriString);){
                    this.symbolFactory = new SymbolFactory();
                    this.cfg = ControlFlowGraphFactory.build(script);
                    this.dpa = new DirectPathAnalyses(this.cfg);
                    this.gva = new GraphVisitorAnalysis(this, this.cfg);
                    this.spa = new SuccessorPredecessorAnalysis(this.cfg);
                }
                if (m1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (m1 == null) throw throwable;
                m1.close();
                throw throwable;
            }
            m1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void checkCancelled() {
        if (this.cancelledChecker == null) {
            return;
        }
        try {
            this.cancelledChecker.call();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)"Unknown exception", (Throwable)e);
        }
    }

    public FlowGraph getControlFlowGraph() {
        return this.cfg;
    }

    public SymbolFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    public Set<ControlFlowElement> getPredecessors(ControlFlowElement cfe) {
        return this.spa.getPredecessors(cfe);
    }

    public Set<ControlFlowElement> getPredecessorsSkipInternal(ControlFlowElement cfe) {
        return this.spa.getPredecessorsSkipInternal(cfe);
    }

    public Set<ControlFlowElement> getSuccessors(ControlFlowElement cfe) {
        return this.spa.getSuccessors(cfe);
    }

    public Set<ControlFlowElement> getSuccessorsSkipInternal(ControlFlowElement cfe) {
        return this.spa.getSuccessorsSkipInternal(cfe);
    }

    public boolean isSuccessor(ControlFlowElement cfe1, ControlFlowElement cfe2) {
        return this.spa.isSuccessor(cfe1, cfe2);
    }

    public boolean isPredecessor(ControlFlowElement cfe1, ControlFlowElement cfe2) {
        return this.spa.isPredecessor(cfe1, cfe2);
    }

    public boolean isTransitiveSuccessor(ControlFlowElement cfeFrom, ControlFlowElement cfeTo) {
        return this.dpa.isTransitiveSuccessor(cfeFrom, cfeTo, null);
    }

    public boolean isTransitiveSuccessor(ControlFlowElement cfeFrom, ControlFlowElement cfeTo, ControlFlowElement cfeNotVia) {
        return this.dpa.isTransitiveSuccessor(cfeFrom, cfeTo, cfeNotVia);
    }

    public TreeSet<ControlFlowType> getControlFlowTypeToSuccessors(ControlFlowElement cfe, ControlFlowElement cfeSucc) {
        return this.dpa.getControlFlowTypeToSuccessors(cfe, cfeSucc);
    }

    public Set<ControlFlowElement> getCommonPredecessors(ControlFlowElement cfeA, ControlFlowElement cfeB) {
        return this.dpa.getCommonPredecessors(cfeA, cfeB);
    }

    public void accept(FlowAnalyser ... flowAnalysers) {
        this.acceptForwardAnalysers(flowAnalysers);
        this.augmentEffectInformation();
        this.acceptBackwardAnalysers(flowAnalysers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptForwardAnalysers(FlowAnalyser ... flowAnalysers) {
        String name = this.cfg.getScriptName();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Measurement m1 = N4JSDataCollectors.dcFlowGraphs.getMeasurement("flowGraphs_" + name);
            try {
                block18: {
                    Measurement m2 = N4JSDataCollectors.dcPerformAnalyses.getMeasurement("performAnalysis_" + name);
                    try {
                        try (Measurement m3 = N4JSDataCollectors.dcForwardAnalyses.getMeasurement("Forward_" + name);){
                            this.gva.forwardAnalysis(flowAnalysers);
                        }
                        if (m2 == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (m2 == null) throw throwable;
                        m2.close();
                        throw throwable;
                    }
                    m2.close();
                }
                if (m1 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (m1 == null) throw throwable;
                m1.close();
                throw throwable;
            }
            m1.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptBackwardAnalysers(FlowAnalyser ... flowAnalysers) {
        String name = this.cfg.getScriptName();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Measurement m1 = N4JSDataCollectors.dcFlowGraphs.getMeasurement("flowGraphs_" + name);
            try {
                block18: {
                    Measurement m2 = N4JSDataCollectors.dcPerformAnalyses.getMeasurement("performAnalysis_" + name);
                    try {
                        try (Measurement m3 = N4JSDataCollectors.dcBackwardAnalyses.getMeasurement("Backward_" + name);){
                            this.gva.backwardAnalysis(flowAnalysers);
                        }
                        if (m2 == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (m2 == null) throw throwable;
                        m2.close();
                        throw throwable;
                    }
                    m2.close();
                }
                if (m1 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (m1 == null) throw throwable;
                m1.close();
                throw throwable;
            }
            m1.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void augmentEffectInformation() {
        String name = this.cfg.getScriptName();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Measurement m1 = N4JSDataCollectors.dcFlowGraphs.getMeasurement("flowGraphs_" + name);
            try {
                block18: {
                    Measurement m2 = N4JSDataCollectors.dcCreateGraph.getMeasurement("createGraph_" + name);
                    try {
                        try (Measurement m = N4JSDataCollectors.dcAugmentEffectInfo.getMeasurement("AugmentEffectInfo_" + name);){
                            this.gva.augmentEffectInformation(this.symbolFactory);
                        }
                        if (m2 == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (m2 == null) throw throwable;
                        m2.close();
                        throw throwable;
                    }
                    m2.close();
                }
                if (m1 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (m1 == null) throw throwable;
                m1.close();
                throw throwable;
            }
            m1.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public ControlFlowElement getContainer(ControlFlowElement cfe) {
        return this.cfg.getContainer(cfe);
    }

    public Collection<ControlFlowElement> getAllContainers() {
        return this.cfg.getAllContainers();
    }
}

