/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPreferenceConstants;

public class GenericEditorPluginPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = GenericEditorPreferenceConstants.getPreferenceStore();
        GenericEditorPreferenceConstants.initializeDefaultValues(store);
    }

    public static void setThemeBasedPreferences(IPreferenceStore store, boolean fireEvent) {
        ColorRegistry registry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        GenericEditorPluginPreferenceInitializer.setDefault(store, "matchingBracketsColor", GenericEditorPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.genericeditor.matchingBracketsColor", new RGB(127, 0, 85)), fireEvent);
    }

    private static void setDefault(IPreferenceStore store, String key, RGB newValue, boolean fireEvent) {
        if (!fireEvent) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
            return;
        }
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }
}

