/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecTestInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.StringCountUtils;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;

public class SourceEntryFactory {
    protected static final String DELIMITER = "#";
    static final String ORG_ECLIPSE_N4JS = "org.eclipse.n4js";
    static final String NO_REPO = "NO_REPO";
    static final String NO_PATH = "NO_PATH";
    static final String NO_FOLDER = "NO_FOLDER";
    static final String NO_PACKAGE = "NO_PACKAGE";

    static SourceEntry create(SpecTestInfo info) {
        String module = info.testModuleSpec().toString();
        String element = info.testMethodTypeName();
        String delimiter = DELIMITER;
        String property = info.testMethodName();
        return SourceEntryFactory.newInstance(info.rrp, info.rrp, module, element, delimiter, property, null);
    }

    static SourceEntry create(RepoRelativePathHolder rrph, RepoRelativePath rrpType, IdentifiableElement idElement) {
        TModule containingModule = idElement.getContainingModule();
        if (containingModule == null) {
            return null;
        }
        String module = containingModule.getModuleSpecifier().toString();
        String elName = SourceEntryFactory.getElementName(idElement);
        String delimiter = SourceEntryFactory.getDelimiter(idElement);
        String property = SourceEntryFactory.getProperty(idElement);
        RepoRelativePath rrpElement = rrph.get(idElement);
        return SourceEntryFactory.newInstance(rrpType, rrpElement, module, elName, delimiter, property, idElement);
    }

    private static String getElementName(IdentifiableElement ie) {
        String elName = ie.getName();
        if (ie instanceof TMember) {
            TMember tm = (TMember)ie;
            ContainerType ct = tm.getContainingType();
            elName = ct.getName();
        }
        return elName;
    }

    private static String getDelimiter(IdentifiableElement ie) {
        String delimiter = "";
        if (ie instanceof TMember) {
            TMember tm = (TMember)ie;
            String string = delimiter = tm.isStatic() ? "@" : DELIMITER;
            if (tm.isGetter()) {
                delimiter = String.valueOf(delimiter) + "<";
            }
            if (tm.isSetter()) {
                delimiter = String.valueOf(delimiter) + ">";
            }
        }
        return delimiter;
    }

    private static String getProperty(IdentifiableElement ie) {
        String property = "";
        if (ie instanceof TMember) {
            property = ie.getName();
        }
        return property;
    }

    static SourceEntry newInstance(RepoRelativePath rrpType, RepoRelativePath rrpElement, String moduleSpecifier, String element, String delimiter, String property, IdentifiableElement idElement) {
        String module = SourceEntryFactory.trim(moduleSpecifier);
        String repository = SourceEntryFactory.getRepository(rrpType);
        String path = SourceEntryFactory.getPath(rrpType, repository);
        String project = SourceEntryFactory.getProject(rrpType);
        String folder = SourceEntryFactory.getFolder(rrpType, module);
        boolean isStaticPolyfillAware = SourceEntryFactory.getIsStaticPolyfillAware(idElement);
        String trueFolder = SourceEntryFactory.getTrueFolder(rrpElement, idElement, folder, module);
        String extension = SourceEntryFactory.getExtension(rrpType);
        String packageName = SourceEntryFactory.getPackageName(module);
        String moduleName = SourceEntryFactory.getModuleName(module);
        int sourceLine = rrpElement.lineNumber;
        int modulePackageCount = StringCountUtils.countFolderDepth(module);
        String[] fileNames = SourceEntryFactory.getFileNames(rrpType, module);
        String fileName = SourceEntryFactory.getFileName(fileNames);
        SourceEntry sed = new SourceEntry(repository, path, project, folder, isStaticPolyfillAware, trueFolder, module, extension, element, delimiter, property, packageName, moduleName, sourceLine, modulePackageCount, fileNames, fileName);
        return sed;
    }

    private static String getRepository(RepoRelativePath rrp) {
        if (rrp == null || rrp.repositoryName == null || rrp.repositoryName.isEmpty()) {
            return NO_REPO;
        }
        return rrp.repositoryName;
    }

    private static String getPath(RepoRelativePath rrp, String repository) {
        if (repository.equals(NO_REPO)) {
            return NO_PATH;
        }
        if (rrp.pathInRepository == null || rrp.pathInRepository.isEmpty()) {
            return NO_PATH;
        }
        String tPath = SourceEntryFactory.trim(rrp.pathInRepository);
        return tPath;
    }

    private static String getProject(RepoRelativePath rrp) {
        String tProject = SourceEntryFactory.trim(rrp.projectName);
        return tProject;
    }

    private static String getFolder(RepoRelativePath rrp, String module) {
        return SourceEntryFactory.getFolderInUriString(rrp.pathInProject, module);
    }

    private static boolean getIsStaticPolyfillAware(IdentifiableElement idElement) {
        if (idElement == null) {
            return false;
        }
        TModule containingModule = idElement.getContainingModule();
        if (containingModule == null) {
            return false;
        }
        return containingModule.isStaticPolyfillAware();
    }

    private static String getTrueFolder(RepoRelativePath rrpElement, IdentifiableElement idElement, String folder, String module) {
        if (idElement == null || idElement.getContainingModule() == null || !SourceEntryFactory.getIsStaticPolyfillAware(idElement)) {
            return folder;
        }
        String trueFolder = SourceEntryFactory.getFolder(rrpElement, module);
        return trueFolder;
    }

    private static String getFolderInUriString(String uriString, String module) {
        int idxProject = uriString.indexOf(ORG_ECLIPSE_N4JS);
        int idxFolder = uriString.indexOf("/", idxProject);
        int idxModule = uriString.indexOf(module, idxFolder);
        String tFolder = uriString.substring(idxFolder, idxModule);
        if ((tFolder = SourceEntryFactory.trim(tFolder)).isEmpty()) {
            tFolder = NO_FOLDER;
        }
        return tFolder;
    }

    protected static String getPackageName(String module) {
        String tPackageName = "";
        if (module.contains("/")) {
            int moduleNameStart = module.lastIndexOf("/");
            tPackageName = module.substring(0, moduleNameStart);
        }
        if ((tPackageName = SourceEntryFactory.trim(tPackageName)).isEmpty()) {
            tPackageName = NO_PACKAGE;
        }
        return tPackageName;
    }

    protected static String getModuleName(String module) {
        String tModuleName = module;
        if (module.contains("/")) {
            int moduleNameStart = module.lastIndexOf("/");
            tModuleName = module.substring(moduleNameStart);
        }
        tModuleName = SourceEntryFactory.trim(tModuleName);
        return tModuleName;
    }

    private static String getExtension(RepoRelativePath rrp) {
        int extPointIdx = rrp.pathInProject.lastIndexOf(".");
        String extension = rrp.pathInProject.substring(extPointIdx);
        return extension;
    }

    private static String[] getFileNames(RepoRelativePath rrp, String module) {
        String[] fNames = new String[4];
        String repository = SourceEntryFactory.getRepository(rrp);
        fNames[0] = String.valueOf(repository) + DELIMITER + SourceEntryFactory.getPath(rrp, repository).replace("/", ".");
        fNames[1] = String.valueOf(SourceEntryFactory.getProject(rrp)) + DELIMITER + SourceEntryFactory.getFolder(rrp, module).replace("/", ".");
        fNames[2] = SourceEntryFactory.getPackageName(module).replace("/", ".");
        fNames[3] = String.valueOf(SourceEntryFactory.getModuleName(module)) + ".adoc";
        return fNames;
    }

    protected static String getFileName(String[] fileNames) {
        String fName = fileNames[0];
        fName = String.valueOf(fName) + File.separator + fileNames[1];
        if (fileNames[2] != null && !fileNames[2].isEmpty()) {
            fName = String.valueOf(fName) + File.separator + fileNames[2];
        }
        fName = String.valueOf(fName) + File.separator + fileNames[3];
        return fName;
    }

    protected static String trim(String s) {
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

