/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ui.contentassist.antlr.internal.InternalN4JSParser;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;

@Singleton
public class ContentAssistTokenTypeMapper {
    private final Map<String, Integer> tokenTypes = Maps.newHashMap();
    private final Map<EObject, Integer> grammarElements = Maps.newHashMap();

    public ContentAssistTokenTypeMapper() {
        Map tokenDefMap = new InternalN4JSParser(null).getTokenDefMap();
        for (Map.Entry entry : tokenDefMap.entrySet()) {
            if (this.tokenTypes.put((String)entry.getValue(), (Integer)entry.getKey()) == null) continue;
            throw new IllegalStateException(String.valueOf(tokenDefMap));
        }
    }

    public int getInternalTokenType(ILeafNode leafNode) {
        EObject grammarElement = leafNode.getGrammarElement();
        if (grammarElement != null) {
            return this.getInternalTokenType(grammarElement);
        }
        String text = leafNode.getText();
        Integer type = this.tokenTypes.get("'" + text + "'");
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException(text);
    }

    public int getInternalTokenType(EObject grammarElement) {
        Integer type = this.grammarElements.get(grammarElement);
        if (type == null) {
            if (grammarElement instanceof Keyword) {
                String keyword = ((Keyword)grammarElement).getValue();
                type = this.tokenTypes.get("'" + keyword + "'");
            } else if (grammarElement instanceof RuleCall) {
                AbstractRule rule = ((RuleCall)grammarElement).getRule();
                type = this.tokenTypes.get("RULE_" + rule.getName().toUpperCase());
            } else if (grammarElement instanceof AbstractRule) {
                AbstractRule rule = (AbstractRule)grammarElement;
                type = this.tokenTypes.get("RULE_" + rule.getName().toUpperCase());
            } else if (grammarElement instanceof EnumLiteralDeclaration) {
                String keyword = ((EnumLiteralDeclaration)grammarElement).getLiteral().getValue();
                type = this.tokenTypes.get("'" + keyword + "'");
            } else if (grammarElement instanceof CrossReference) {
                type = this.getInternalTokenType((EObject)((CrossReference)grammarElement).getTerminal());
            } else {
                throw new IllegalArgumentException(String.valueOf(grammarElement));
            }
            this.grammarElements.put(grammarElement, type);
        }
        return type;
    }
}

