/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.ui.building.BuildDataWithRequestRebuild;
import org.eclipse.n4js.ui.building.BuildManagerAccess;
import org.eclipse.n4js.ui.containers.N4JSProjectsStateHelper;
import org.eclipse.n4js.ui.external.BuildOrderComputer;
import org.eclipse.n4js.ui.external.ComputeProjectOrder;
import org.eclipse.n4js.ui.external.ExternalLibraryBuildQueue;
import org.eclipse.n4js.ui.external.ExternalProjectProvider;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.ui.internal.ResourceUIValidatorExtension;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class ExternalLibraryBuilder {
    private static Logger LOGGER = Logger.getLogger(ExternalLibraryBuilder.class);
    @Inject
    private IN4JSCore core;
    @Inject
    private IBuilderState builderState;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private BuildOrderComputer builtOrderComputer;
    @Inject
    private ToBeBuiltComputer builtComputer;
    @Inject
    private ExternalProjectProvider projectProvider;
    @Inject
    private ResourceUIValidatorExtension validatorExtension;
    @Inject
    private N4JSProjectsStateHelper projectsStateHelper;
    private IToBeBuiltComputerContribution contribution;

    @Inject
    private void initializeContributions(ISharedStateContributionRegistry registry) {
        this.contribution = this.getContribution((ImmutableList<? extends IToBeBuiltComputerContribution>)registry.getContributedInstances(IToBeBuiltComputerContribution.class));
    }

    private IToBeBuiltComputerContribution getContribution(ImmutableList<? extends IToBeBuiltComputerContribution> contributedInstances) {
        switch (contributedInstances.size()) {
            case 0: {
                return new ToBeBuiltComputer.NullContribution();
            }
            case 1: {
                return (IToBeBuiltComputerContribution)contributedInstances.get(0);
            }
        }
        return new ToBeBuiltComputer.CompositeContribution(contributedInstances){};
    }

    public List<IProject> build() {
        return this.build((IProgressMonitor)new NullProgressMonitor());
    }

    public List<IProject> build(IProgressMonitor monitor) {
        return this.build(this.projectProvider.getProjects(), monitor);
    }

    public List<IProject> build(N4JSExternalProject project) {
        return this.build(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<IProject> build(N4JSExternalProject project, IProgressMonitor monitor) {
        return this.build(new N4JSExternalProject[]{project}, monitor);
    }

    public List<IProject> build(Collection<N4JSExternalProject> projects, IProgressMonitor monitor) {
        return this.build(projects.toArray(new N4JSExternalProject[0]), monitor);
    }

    public List<IProject> build(N4JSExternalProject[] buildConfigs, IProgressMonitor monitor) {
        return this.doPerformOperation(buildConfigs, BuildOperation.BUILD, monitor);
    }

    public List<IProject> clean() {
        return this.clean((IProgressMonitor)new NullProgressMonitor());
    }

    public List<IProject> clean(IProgressMonitor monitor) {
        return this.clean(this.projectProvider.getProjects(), monitor);
    }

    public List<IProject> clean(N4JSExternalProject project) {
        return this.clean(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<IProject> clean(N4JSExternalProject project, IProgressMonitor monitor) {
        return this.clean(new N4JSExternalProject[]{project}, monitor);
    }

    public List<IProject> clean(Collection<N4JSExternalProject> projects, IProgressMonitor monitor) {
        return this.clean(projects.toArray(new N4JSExternalProject[0]), monitor);
    }

    public List<IProject> clean(N4JSExternalProject[] projects, IProgressMonitor monitor) {
        return this.doPerformOperation(projects, BuildOperation.CLEAN, monitor);
    }

    private List<IProject> doPerformOperation(N4JSExternalProject[] projects, BuildOperation operation, IProgressMonitor monitor) {
        if (projects == null || projects.length == 0) {
            return Collections.emptyList();
        }
        Measurement allProjectsMeasurement = N4JSDataCollectors.dcExtLibBuilder.getMeasurement(String.valueOf(operation.name().toLowerCase()) + "ing all projects");
        ISchedulingRule rule = this.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            this.validatorExtension.clearAllMarkersOfExternalProjects(projects);
            ComputeProjectOrder.VertexOrder<IN4JSProject> buildOrder = this.builtOrderComputer.getBuildOrder(projects);
            ArrayList<IN4JSProject> buildOrderList = new ArrayList<IN4JSProject>(Arrays.asList((IN4JSProject[])buildOrder.vertexes));
            if (BuildOperation.CLEAN.equals((Object)operation)) {
                this.wipeProjectFromIndex((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), Arrays.asList(projects));
                this.projectsStateHelper.clearProjectCache();
                Collections.reverse(buildOrderList);
            }
            if (BuildOperation.BUILD.equals((Object)operation)) {
                Iterator itr = buildOrderList.iterator();
                while (itr.hasNext()) {
                    if (!this.hasWorkspaceCounterpart((IN4JSProject)itr.next())) continue;
                    itr.remove();
                }
            }
            this.ensureDynamicDependenciesSetForWorkspaceProjects();
            String prefix = Strings.toFirstUpper((String)operation.toString().toLowerCase());
            String projectNames = this.getProjectNames(buildOrderList);
            LOGGER.info((Object)(String.valueOf(prefix) + "ing external libraries: " + projectNames));
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)buildOrderList.size());
            LinkedList<IProject> actualBuildOrderList = new LinkedList<IProject>();
            for (IN4JSProject project : buildOrderList) {
                LOGGER.info((Object)(String.valueOf(prefix) + "ing external library: " + project.getProjectName()));
                N4JSEclipseProject n4EclPrj = (N4JSEclipseProject)project;
                operation.run(this, n4EclPrj, (IProgressMonitor)subMonitor.split(1));
                IProject iProject = n4EclPrj.getProject();
                actualBuildOrderList.add(iProject);
            }
            LinkedList<IProject> linkedList = actualBuildOrderList;
            return linkedList;
        }
        finally {
            allProjectsMeasurement.close();
            Job.getJobManager().endRule(rule);
        }
    }

    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private boolean hasWorkspaceCounterpart(IN4JSProject project) {
        URI uri = URI.createPlatformResourceURI((String)project.getProjectName(), (boolean)true);
        IN4JSProject n4Project = (IN4JSProject)this.core.findProject(uri).orNull();
        return n4Project != null && n4Project.exists() && !n4Project.isExternal();
    }

    private String getProjectNames(Iterable<IN4JSProject> projects) {
        return Iterables.toString((Iterable)FluentIterable.from(projects).transform(p -> p.getProjectName()));
    }

    private void ensureDynamicDependenciesSetForWorkspaceProjects() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            URI uri = URI.createPlatformResourceURI((String)project.getName(), (boolean)true);
            IN4JSProject n4Project = (IN4JSProject)this.core.findProject(uri).get();
            if (n4Project != null) {
                n4Project.getProjectName();
            }
            ++n2;
        }
    }

    public void wipeProjectFromIndex(IProgressMonitor monitor, Collection<N4JSExternalProject> projectsToBeWiped) {
        HashSet<URI> toBeWiped = new HashSet<URI>();
        for (N4JSExternalProject project : projectsToBeWiped) {
            toBeWiped.add(URIUtils.toFileUri((java.net.URI)project.getLocationURI()));
        }
        this.wipeURIsFromIndex(monitor, toBeWiped);
    }

    public void wipeURIsFromIndex(IProgressMonitor monitor, Collection<URI> toBeWiped) {
        HashSet<String> toBeWipedStrings = new HashSet<String>();
        for (URI toWipe : toBeWiped) {
            toBeWipedStrings.add(toWipe.toString());
            String projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)toWipe);
            this.validatorExtension.clearAllMarkersOfExternalProject(projectName);
        }
        ResourceSet resourceSet = this.core.createResourceSet(Optional.absent());
        IResourceDescriptions index = this.core.getXtextIndex(resourceSet);
        HashSet<URI> toBeRemoved = new HashSet<URI>();
        block1: for (IResourceDescription res : index.getAllResourceDescriptions()) {
            URI resUri = res.getURI();
            String resUriString = resUri.toString();
            for (String toWipeProject : toBeWipedStrings) {
                if (!resUriString.startsWith(toWipeProject)) continue;
                toBeRemoved.add(resUri);
                continue block1;
            }
        }
        this.builderState.clean(toBeRemoved, monitor);
    }

    public void process(ExternalLibraryBuildQueue.Task task, IProgressMonitor monitor) {
        if (task.isEmpty()) {
            return;
        }
        monitor.beginTask("Building external libraries...", -1);
        try {
            this.clean(task.toClean.toArray(new N4JSExternalProject[0]), monitor);
            this.build(task.toBuild.toArray(new N4JSExternalProject[0]), monitor);
        }
        catch (Error | RuntimeException e) {
            task.reschedule();
            throw e;
        }
    }

    private static enum BuildOperation {
        BUILD{

            @Override
            protected ToBeBuilt getToBeBuilt(final ToBeBuiltComputer computer, N4JSEclipseProject n4Project, final IProgressMonitor monitor, final IToBeBuiltComputerContribution contribution) {
                try {
                    final ToBeBuilt toBeBuilt = new ToBeBuilt();
                    final SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    n4Project.getProject().accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (resource instanceof IStorage) {
                                return computer.updateStorage((IProgressMonitor)childMonitor, toBeBuilt, (IStorage)resource);
                            }
                            if (resource instanceof IFolder) {
                                return !contribution.isRejected((IFolder)resource);
                            }
                            return true;
                        }
                    });
                    return toBeBuilt;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    String name = n4Project.getProjectName();
                    LOGGER.error((Object)("Error occurred while calculating to be build data for '" + name + "' project."), (Throwable)e);
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            }
        }
        ,
        CLEAN{

            @Override
            protected ToBeBuilt getToBeBuilt(ToBeBuiltComputer computer, N4JSEclipseProject n4Project, IProgressMonitor monitor, IToBeBuiltComputerContribution contribution) {
                return computer.removeProject(n4Project.getProject(), monitor);
            }
        };


        abstract ToBeBuilt getToBeBuilt(ToBeBuiltComputer var1, N4JSEclipseProject var2, IProgressMonitor var3, IToBeBuiltComputerContribution var4);

        private void run(ExternalLibraryBuilder helper, N4JSEclipseProject n4EclPrj, IProgressMonitor monitor) {
            RaceDetectionHelper.log((String)"%s: external project ", (Object[])new Object[]{this.name(), n4EclPrj.getProjectName()});
            DataCollector operationCollector = DataCollectors.INSTANCE.getOrCreateDataCollector(String.valueOf(this.name().toLowerCase()) + "ing " + n4EclPrj.getProjectName(), N4JSDataCollectors.dcExtLibBuilder);
            Measurement measurement = operationCollector.getMeasurement(String.valueOf(this.name().toLowerCase()) + "ing " + n4EclPrj.getProjectName());
            monitor.setTaskName("Collecting resource for '" + n4EclPrj.getProjectName() + "'...");
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            SubMonitor computeMonitor = subMonitor.newChild(1, 2);
            IProject project = n4EclPrj.getProject();
            ToBeBuiltComputer computer = helper.builtComputer;
            IToBeBuiltComputerContribution contribution = helper.contribution;
            ToBeBuilt toBeBuilt = this.getToBeBuilt(computer, n4EclPrj, (IProgressMonitor)computeMonitor, contribution);
            try {
                if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
                    subMonitor.newChild(1, 0).worked(1);
                    return;
                }
                try {
                    IN4JSCore core = helper.core;
                    QueuedBuildData queuedBuildData = helper.queuedBuildData;
                    IBuilderState builderState = helper.builderState;
                    ResourceSet resourceSet = null;
                    try {
                        resourceSet = core.createResourceSet(Optional.of((Object)n4EclPrj));
                        if (!resourceSet.getLoadOptions().isEmpty()) {
                            resourceSet.getLoadOptions().clear();
                        }
                        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
                        if (resourceSet instanceof ResourceSetImpl) {
                            ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
                        }
                        BuildDataWithRequestRebuild buildData = new BuildDataWithRequestRebuild(project.getName(), resourceSet, toBeBuilt, queuedBuildData, false, BuildManagerAccess::needBuild);
                        monitor.setTaskName("Building '" + project.getName() + "'...");
                        SubMonitor buildMonitor = subMonitor.split(1, 2);
                        builderState.update((BuildData)buildData, (IProgressMonitor)buildMonitor);
                    }
                    finally {
                        if (resourceSet != null) {
                            boolean wasDeliver = resourceSet.eDeliver();
                            try {
                                resourceSet.eSetDeliver(false);
                                resourceSet.getResources().clear();
                                resourceSet.eAdapters().clear();
                            }
                            finally {
                                resourceSet.eSetDeliver(wasDeliver);
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    String message = "Error occurred while " + this.toString().toLowerCase() + "ing external library " + project.getName() + ".";
                    LOGGER.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            finally {
                measurement.close();
            }
        }
    }
}

