/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.external.ExternalLibrariesActionsHelper;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.preferences.external.BuiltInLibrariesLabelProvider;
import org.eclipse.n4js.ui.preferences.external.ButtonFactoryUtil;
import org.eclipse.n4js.ui.preferences.external.CleanAllNpmsButtonListener;
import org.eclipse.n4js.ui.preferences.external.ExternalLibraryTreeContentProvider;
import org.eclipse.n4js.ui.preferences.external.InstallNpmDependencyButtonListener;
import org.eclipse.n4js.ui.preferences.external.NpmNameAndVersionValidatorHelper;
import org.eclipse.n4js.ui.preferences.external.RereigsterAllNpmsButtonListener;
import org.eclipse.n4js.ui.preferences.external.UninstallNpmDependencyButtonListener;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.viewer.TreeViewerBuilder;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExternalLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = ExternalLibraryPreferencePage.class.getName();
    static final Map<URI, String> BUILT_IN_LIBS = (Map)ExternalLibrariesActivator.EXTERNAL_LIBRARIES_SUPPLIER.get();
    @Inject
    private ExternalLibraryPreferenceStore store;
    @Inject
    private Provider<ExternalLibraryTreeContentProvider> contentProvider;
    @Inject
    private NpmNameAndVersionValidatorHelper validatorHelper;
    @Inject
    private LibraryManager libManager;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private ExternalLibrariesActionsHelper externalLibrariesActionsHelper;
    @Inject
    private N4JSProjectExplorerHelper projectExplorerhelper;
    private TreeViewer viewer;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.setSize(new Point(600, 600));
        BuiltInLibrariesLabelProvider labelProvider = new BuiltInLibrariesLabelProvider(this.projectExplorerhelper);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
        control.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).create());
        this.viewer = (TreeViewer)new TreeViewerBuilder(Collections.singletonList(""), (IContentProvider)this.contentProvider.get()).setVirtual(true).setHeaderVisible(false).setUseHashlookup(true).setHasBorder(true).setColumnWeights(Ints.asList((int[])new int[]{1})).setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider)).build(control);
        this.setViewerInput();
        Composite subComposite = new Composite(control, 0);
        subComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        subComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 128).create());
        final Button install = ButtonFactoryUtil.createEnabledPushButton(subComposite, "Install npm...", "Runs 'npm install' with the given package and version. Uses 'yarn add' in a yarn workspace.", (SelectionListener)new InstallNpmDependencyButtonListener(this::updateLocations, this.libManager, this.validatorHelper, this.semverHelper, this.statusHelper, this::getSelectedNodeModulesURI));
        final Button uninstall = ButtonFactoryUtil.createEnabledPushButton(subComposite, "Uninstall npm...", "Runs 'npm uninstall' with the given package and version. Uses 'yarn remove' in a yarn workspace.", (SelectionListener)new UninstallNpmDependencyButtonListener(this::updateLocations, this.libManager, this.validatorHelper, this.statusHelper, this::getSelectedNpm));
        this.createPlaceHolderLabel(subComposite);
        this.createPlaceHolderLabel(subComposite);
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Re-Build node_modules", "Cleans the type information from the IDE and then re-build the type information of all node_modules.", (SelectionListener)new RereigsterAllNpmsButtonListener(this::reregisterNpms, this.statusHelper));
        ButtonFactoryUtil.createEnabledPushButton(subComposite, "Clean node_modules", "Runs 'npm clean' on all node_modules folders. Uses 'yarn clean' in a yarn workspace.", (SelectionListener)new CleanAllNpmsButtonListener(this::cleanNpms, this.statusHelper));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                install.setEnabled(false);
                uninstall.setEnabled(false);
                Object selectedItem = ExternalLibraryPreferencePage.this.getSelectedItem();
                if (selectedItem instanceof URI) {
                    install.setEnabled(true);
                }
                if (selectedItem instanceof N4JSProject) {
                    uninstall.setEnabled(true);
                }
            }
        });
        control.requestLayout();
        return control;
    }

    private Object getSelectedItem() {
        Tree tree = this.viewer.getTree();
        Object[] selection = tree.getSelection();
        if (!Arrays2.isEmpty((Object[])selection) && 1 == selection.length) {
            URI uri;
            Object data = selection[0].getData();
            if (data instanceof URI && ExternalLibraryPreferenceModel.isNodeModulesLocation((URI)(uri = (URI)data))) {
                return data;
            }
            if (data instanceof N4JSProject) {
                return data;
            }
        }
        return null;
    }

    private IN4JSProject getSelectedNpm() {
        return (IN4JSProject)this.getSelectedItem();
    }

    private URI getSelectedNodeModulesURI() {
        return (URI)this.getSelectedItem();
    }

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    public boolean performCancel() {
        this.store.invalidate();
        return true;
    }

    public boolean performOk() {
        MultiStatus multistatus = this.statusHelper.createMultiStatus("Status of importing target platform.");
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, monitor -> {
                IStatus status = this.store.save(monitor);
                if (!status.isOK()) {
                    this.setMessage(status.getMessage(), 3);
                    multistatus.merge(status);
                } else {
                    ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exc) {
            multistatus.merge(this.statusHelper.createError("Error while building external libraries.", (Throwable)exc));
        }
        if (multistatus.isOK()) {
            return super.performOk();
        }
        return false;
    }

    private void setViewerInput() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            UIUtils.getDisplay().asyncExec(() -> ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations()));
        }
    }

    private Control createPlaceHolderLabel(Composite parent) {
        return new Label(parent, 0);
    }

    private MultiStatus cleanNpms(IProgressMonitor monitor, MultiStatus multistatus) {
        try {
            try {
                multistatus.merge(this.externalLibrariesActionsHelper.maintenanceDeleteNpms(monitor));
            }
            catch (Exception e) {
                String msg = "Error when cleaning external libraries.";
                multistatus.merge(this.statusHelper.createError(msg, (Throwable)e));
                ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
            }
        }
        finally {
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
        return multistatus;
    }

    private MultiStatus reregisterNpms(IProgressMonitor monitor, MultiStatus multistatus) {
        try {
            try {
                IStatus status = this.libManager.registerAllExternalProjects(monitor);
                multistatus.merge(status);
            }
            catch (Exception e) {
                String msg = "Error when re-registering external libraries.";
                multistatus.merge(this.statusHelper.createError(msg, (Throwable)e));
                ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
            }
        }
        finally {
            ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
        }
        return multistatus;
    }

    private void updateLocations() {
        ExternalLibraryPreferencePage.updateInput(this.viewer, this.store.getLocations());
    }

    private static void updateInput(TreeViewer viewer, Object input) {
        UIUtils.getDisplay().asyncExec(() -> {
            Object[] expandedElements = viewer.getExpandedElements();
            Object[] expandedTreePaths = viewer.getExpandedTreePaths();
            viewer.setInput(input);
            viewer.getControl().notifyListeners(13, null);
            if (!Arrays2.isEmpty((Object[])expandedElements)) {
                viewer.setExpandedElements(expandedElements);
            }
            if (!Arrays2.isEmpty((Object[])expandedTreePaths)) {
                viewer.setExpandedTreePaths((TreePath[])expandedTreePaths);
            }
        });
    }
}

