/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classes;

import org.eclipse.n4js.ui.wizard.classes.N4JSClassWizardModel;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSClassifierWizardModelValidator;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModelValidator;
import org.eclipse.xtext.resource.IEObjectDescription;

public class N4JSClassWizardModelValidator
extends N4JSClassifierWizardModelValidator<N4JSClassWizardModel> {
    private static final String THE_SUPER_CLASS_CANNOT_BE_FOUND = "The super class cannot be found.";

    @Override
    protected void run() throws WorkspaceWizardModelValidator.ValidationException {
        super.run();
        this.validateSuperClass();
    }

    protected void validateSuperClass() throws WorkspaceWizardModelValidator.ValidationException {
        ClassifierReference superClassRef = ((N4JSClassWizardModel)this.getModel()).getSuperClass();
        if (!superClassRef.getFullSpecifier().isEmpty()) {
            IEObjectDescription classDescription;
            if (!this.isValidClass(superClassRef)) {
                throw new WorkspaceWizardModelValidator.ValidationException(THE_SUPER_CLASS_CANNOT_BE_FOUND);
            }
            if (superClassRef.uri == null && (classDescription = this.getClassifierObjectDescriptionForFQN(superClassRef.getFullSpecifier())) != null) {
                superClassRef.uri = classDescription.getEObjectURI();
            }
        }
    }
}

