/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.n4js.jsdoc2spec.SpecElementRef;
import org.eclipse.n4js.jsdoc2spec.SpecTestInfo;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;

public class SpecInfo {
    public final SpecElementRef specElementRef;
    private final SortedSet<SpecTestInfo> relatedTypeTests;
    private final Map<TMember, SortedSet<SpecTestInfo>> relatedMemberTests;

    public SpecInfo(IdentifiableElement identifiableElement) {
        this.specElementRef = new SpecElementRef(identifiableElement);
        this.relatedTypeTests = new TreeSet<SpecTestInfo>();
        this.relatedMemberTests = new HashMap<TMember, SortedSet<SpecTestInfo>>();
    }

    public SpecInfo(String reqid) {
        this.specElementRef = new SpecElementRef(reqid);
        this.relatedTypeTests = new TreeSet<SpecTestInfo>();
        this.relatedMemberTests = new HashMap<TMember, SortedSet<SpecTestInfo>>();
    }

    public void addTypeTestInfo(SpecTestInfo testInfo) {
        this.relatedTypeTests.add(testInfo);
    }

    public void addMemberTestInfo(TMember member, SpecTestInfo testInfo) {
        SortedSet<SpecTestInfo> testsForMember = this.relatedMemberTests.get(member);
        if (testsForMember == null) {
            testsForMember = new TreeSet<SpecTestInfo>();
            this.relatedMemberTests.put(member, testsForMember);
        }
        testsForMember.add(testInfo);
    }

    public SortedSet<SpecTestInfo> getTestsForType() {
        return this.relatedTypeTests;
    }

    public SortedSet<SpecTestInfo> getTestsForMember(TMember member) {
        SortedSet<SpecTestInfo> testsForMember = this.relatedMemberTests.get(member);
        if (testsForMember == null) {
            return Collections.emptySortedSet();
        }
        return testsForMember;
    }

    public Map<TMember, SortedSet<SpecTestInfo>> getTestsForInheritedMembers() {
        HashMap<TMember, SortedSet<SpecTestInfo>> m = new HashMap<TMember, SortedSet<SpecTestInfo>>();
        for (Map.Entry<TMember, SortedSet<SpecTestInfo>> e : this.relatedMemberTests.entrySet()) {
            TMember member = e.getKey();
            if (member.getContainingType() == this.specElementRef.identifiableElement || member.isPolyfilled()) continue;
            m.put(member, e.getValue());
        }
        return m;
    }

    public String toString() {
        return "SpecInfo for " + this.specElementRef;
    }
}

