/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.n4js.ui.console.ConsoleMessages;
import org.eclipse.n4js.ui.console.JSStackTraceLocationText;
import org.eclipse.n4js.ui.internal.N4JSGracefulActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TestResultHyperlink
implements IHyperlink {
    private final IRegion region;
    private final JSStackTraceLocationText locationText;
    private final String hyperlinkText;

    public TestResultHyperlink(IRegion region, JSStackTraceLocationText locationText) {
        this.region = region;
        this.locationText = locationText;
        this.hyperlinkText = String.valueOf(locationText.getSimpleName()) + ":" + locationText.line + ":" + locationText.column;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public void open() {
        File file = new File(this.locationText.fileName);
        if (file.exists()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                this.revealLocationInFile(editorPart);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void revealLocationInFile(IEditorPart editorPart) throws CoreException {
        if (editorPart instanceof ITextEditor && this.locationText.line > 0) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput editorInput = editorPart.getEditorInput();
            provider.connect((Object)editorInput);
            IDocument document = provider.getDocument((Object)editorInput);
            try {
                IRegion regionOfLine = document.getLineInformation(this.locationText.line - 1);
                textEditor.selectAndReveal(regionOfLine.getOffset(), regionOfLine.getLength());
                int startOffset = regionOfLine.getOffset() + this.locationText.column - 1;
                int length = regionOfLine.getLength() - this.locationText.column;
                if (startOffset >= document.getLength()) {
                    startOffset = document.getLength() - 1;
                }
                if (length + startOffset >= document.getLength()) {
                    length = document.getLength() - startOffset - 1;
                }
                textEditor.setHighlightRange(startOffset, length, true);
            }
            catch (BadLocationException e) {
                MessageDialog.openInformation((Shell)N4JSGracefulActivator.getActiveWorkbenchShell(), (String)ConsoleMessages.msgInvalidLineNumberTitle(), (String)ConsoleMessages.msgInvalidLineNumberIn((Object)String.valueOf(this.locationText.line), (Object)this.locationText.fileName));
            }
            provider.disconnect((Object)editorInput);
        }
    }
}

