/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.HlcExternalIndexSynchronizer;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.packagejson.PackageJsonResourceDescriptionExtension;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.validation.helper.FolderContainmentHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.Pair;

@ImplementedBy(value=HlcExternalIndexSynchronizer.class)
public abstract class ExternalIndexSynchronizer {
    @Inject
    protected IN4JSCore core;
    @Inject
    protected ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    protected ShadowingInfoHelper shadowingInfoHelper;
    @Inject
    protected FolderContainmentHelper containmentHelper;
    @Inject
    protected ExternalLibraryPreferenceStore libraryPreferenceStore;
    @Inject
    protected NpmLogger logger;

    public abstract void synchronizeNpms(IProgressMonitor var1);

    public abstract void synchronizeNpms(IProgressMonitor var1, Collection<LibraryChange> var2);

    public abstract void reindexAllExternalProjects(IProgressMonitor var1);

    public final Map<String, Pair<URI, String>> findNpmsInFolder(ProjectStateOperation operation) {
        HashMap<String, Pair<URI, String>> npmsFolder = new HashMap<String, Pair<URI, String>>();
        List<Object> prjs = Collections.emptyList();
        switch (operation) {
            case NONE: {
                prjs = this.externalLibraryWorkspace.getProjectsIncludingUnnecessary();
                break;
            }
            case PEEK: {
                prjs = this.externalLibraryWorkspace.computeProjectsIncludingUnnecessary();
                break;
            }
            case UPDATE: {
                this.externalLibraryWorkspace.updateState();
                prjs = this.externalLibraryWorkspace.getProjectsIncludingUnnecessary();
            }
        }
        for (org.eclipse.xtext.util.Pair pair : prjs) {
            URI location = (URI)pair.getFirst();
            IN4JSProject project = (IN4JSProject)this.core.findProject(location).orNull();
            if (project != null && this.shadowingInfoHelper.isShadowedProject(project)) continue;
            ProjectDescription projectDescription = (ProjectDescription)pair.getSecond();
            VersionNumber version = projectDescription.getProjectVersion();
            String name = projectDescription.getProjectName();
            if (version == null) continue;
            npmsFolder.putIfAbsent(name, (Pair<URI, String>)Pair.of((Object)location, (Object)version.toString()));
        }
        return npmsFolder;
    }

    public Map<String, Pair<URI, String>> findNpmsInIndex() {
        HashMap<String, Pair<URI, String>> discoveredNpmsInIndex = new HashMap<String, Pair<URI, String>>();
        ResourceSet resourceSet = this.core.createResourceSet((Optional<IN4JSProject>)Optional.absent());
        IResourceDescriptions index = this.core.getXtextIndex(resourceSet);
        for (IResourceDescription resourceDescription : index.getAllResourceDescriptions()) {
            boolean isExternal = resourceDescription.getURI().isFile();
            if (!isExternal) continue;
            this.addToIndex(discoveredNpmsInIndex, resourceDescription);
        }
        return discoveredNpmsInIndex;
    }

    public boolean isInIndex(N4JSExternalProject project) {
        return this.isInIndex((URI)project.getIProject().getProjectDescriptionLocation().orNull());
    }

    public boolean isInIndex(URI projectLocation) {
        ResourceSet resourceSet = this.core.createResourceSet((Optional<IN4JSProject>)Optional.absent());
        IResourceDescriptions index = this.core.getXtextIndex(resourceSet);
        IResourceDescription resourceDescription = index.getResourceDescription(projectLocation);
        return resourceDescription != null;
    }

    public void checkAndClearIndex(IProgressMonitor monitor) {
        Collection<LibraryChange> changeSet = this.identifyChangeSet(Collections.emptyList(), ProjectStateOperation.UPDATE);
        this.cleanRemovedProjectsFromIndex(monitor, changeSet);
    }

    private void cleanRemovedProjectsFromIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet) {
        monitor.setTaskName("Deregister removed projects...");
        HashSet<URI> cleanProjects = new HashSet<URI>();
        for (LibraryChange libChange : changeSet) {
            if (libChange.type != LibraryChange.LibraryChangeType.Removed) continue;
            cleanProjects.add(libChange.location);
        }
        ExternalLibraryWorkspace.RegisterResult cleanResult = this.externalLibraryWorkspace.deregisterProjects(monitor, cleanProjects);
        this.printRegisterResults(cleanResult, "deregistered");
    }

    protected final Collection<LibraryChange> identifyChangeSet(Collection<LibraryChange> forcedChangeSet, ProjectStateOperation operation) {
        int synchronizeStatusCode = this.libraryPreferenceStore.synchronizeNodeModulesFolders().getCode();
        if (synchronizeStatusCode == 1) {
            operation = ProjectStateOperation.NONE;
        }
        LinkedHashSet<LibraryChange> changes = new LinkedHashSet<LibraryChange>(forcedChangeSet);
        Map<String, Pair<URI, String>> npmsOfIndex = this.findNpmsInIndex();
        Map<String, Pair<URI, String>> npmsOfFolder = this.findNpmsInFolder(operation);
        HashSet<String> differences = new HashSet<String>();
        differences.addAll(npmsOfIndex.keySet());
        differences.addAll(npmsOfFolder.keySet());
        Sets.SetView intersection = Sets.intersection(npmsOfIndex.keySet(), npmsOfFolder.keySet());
        differences.removeAll((Collection<?>)intersection);
        Iterator iterator = differences.iterator();
        while (iterator.hasNext()) {
            String version;
            URI location;
            String diff;
            String name = diff = (String)iterator.next();
            LibraryChange change = null;
            if (npmsOfFolder.containsKey(diff) && this.externalLibraryWorkspace.isNecessary(location = (URI)npmsOfFolder.get(name).getKey())) {
                version = (String)npmsOfFolder.get(name).getValue();
                change = new LibraryChange(LibraryChange.LibraryChangeType.Added, location, name, version);
            }
            if (npmsOfIndex.containsKey(diff)) {
                location = (URI)npmsOfIndex.get(name).getKey();
                version = (String)npmsOfIndex.get(name).getValue();
                change = new LibraryChange(LibraryChange.LibraryChangeType.Removed, location, name, version);
            }
            if (change == null) continue;
            changes.add(change);
        }
        for (String name : intersection) {
            boolean versionsChanged;
            String versionIndex = (String)npmsOfIndex.get(name).getValue();
            String versionFolder = (String)npmsOfFolder.get(name).getValue();
            URI locationIndex = (URI)npmsOfIndex.get(name).getKey();
            URI locationFolder = (URI)npmsOfFolder.get(name).getKey();
            boolean shadowingChanged = !locationFolder.equals(locationIndex);
            boolean bl = versionsChanged = versionIndex != null && !versionIndex.equals(versionFolder);
            if (!shadowingChanged && !versionsChanged) continue;
            changes.add(new LibraryChange(LibraryChange.LibraryChangeType.Removed, locationIndex, name, versionIndex));
            changes.add(new LibraryChange(LibraryChange.LibraryChangeType.Added, locationFolder, name, versionFolder));
        }
        return changes;
    }

    private void addToIndex(Map<String, Pair<URI, String>> npmsIndex, IResourceDescription resourceDescription) {
        URI nestedLocation = resourceDescription.getURI();
        java.net.URI rootLocationJNU = this.externalLibraryWorkspace.getRootLocationForResourceOrInfer(nestedLocation);
        if (rootLocationJNU == null) {
            this.logger.logInfo("Could not find location for: " + nestedLocation.toString() + ".\n Please rebuild external libraries!");
            return;
        }
        URI rootLocation = URI.createURI((String)rootLocationJNU.toString());
        String name = this.getPackageName(nestedLocation, URI.createURI((String)rootLocation.toString()));
        URI packageLocation = this.createProjectLocation(rootLocation, name);
        String version = this.getVersion(resourceDescription, nestedLocation, name, packageLocation);
        if (!npmsIndex.containsKey(name) || version != null) {
            npmsIndex.put(name, (Pair<URI, String>)Pair.of((Object)packageLocation, (Object)version));
        }
    }

    private String getVersion(IResourceDescription resourceDescription, URI nestedLocation, String name, URI packageLocation) {
        IEObjectDescription pDescription;
        String nameFromPackageJSON;
        if (!this.isProjectDescriptionFile(nestedLocation, packageLocation)) {
            return null;
        }
        Iterable pds = resourceDescription.getExportedObjectsByType(JSONPackage.eINSTANCE.getJSONDocument());
        Iterator pdsIter = pds.iterator();
        if (pdsIter.hasNext() && ((nameFromPackageJSON = PackageJsonResourceDescriptionExtension.getProjectName(pDescription = (IEObjectDescription)pdsIter.next())) == null || name.equals(nameFromPackageJSON))) {
            String version = pDescription.getUserData("projectVersion");
            return version;
        }
        return null;
    }

    private boolean isProjectDescriptionFile(URI resourceLocation, URI packageLocation) {
        boolean isProjectDescriptionFile = true;
        isProjectDescriptionFile &= resourceLocation.lastSegment().equals("package.json");
        return isProjectDescriptionFile &= resourceLocation.equals(packageLocation.appendSegment("package.json"));
    }

    private String getPackageName(URI nestedLocation, URI workspaceLocation) {
        URI relativeLocation;
        if (!this.containmentHelper.isContained(nestedLocation, workspaceLocation)) {
            throw new IllegalArgumentException("Cannot determine package name of " + nestedLocation + ": The nested location is not contained in the given workspace location " + workspaceLocation);
        }
        if (!workspaceLocation.hasTrailingPathSeparator()) {
            workspaceLocation = workspaceLocation.appendSegment("");
        }
        if ((relativeLocation = nestedLocation.deresolve(workspaceLocation)).segmentCount() == 0) {
            throw new IllegalArgumentException("Malformed package location " + nestedLocation + ": Expected at least one segment in addition to workspace location " + workspaceLocation + ".");
        }
        if (relativeLocation.segment(0).startsWith("@")) {
            if (relativeLocation.segmentCount() < 2) {
                throw new IllegalArgumentException("Malformed package location: " + nestedLocation);
            }
            return String.valueOf(relativeLocation.segment(0)) + File.separator + relativeLocation.segment(1);
        }
        return relativeLocation.segment(0);
    }

    private URI createProjectLocation(URI workspaceLocation, String projectName) {
        if (workspaceLocation.hasTrailingPathSeparator()) {
            workspaceLocation = workspaceLocation.trimSegments(1);
        }
        return workspaceLocation.appendSegments(URI.createURI((String)projectName).segments());
    }

    protected void printRegisterResults(ExternalLibraryWorkspace.RegisterResult rr, String jobName) {
        SortedSet<String> prjNames;
        if (!rr.externalProjectsDone.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.externalProjectsDone);
            this.logger.logInfo("External libraries " + jobName + ": " + String.join((CharSequence)", ", prjNames));
        }
        if (!rr.wipedProjects.isEmpty()) {
            prjNames = new TreeSet<String>();
            for (URI location : rr.wipedProjects) {
                String projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location);
                prjNames.add(projectName);
            }
            this.logger.logInfo("Projects deregistered: " + String.join((CharSequence)", ", prjNames));
        }
        if (!rr.affectedWorkspaceProjects.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.affectedWorkspaceProjects);
            this.logger.logInfo("Workspace projects affected: " + String.join((CharSequence)", ", prjNames));
        }
    }

    private SortedSet<String> getProjectNamesFromLocations(Collection<URI> projectLocations) {
        TreeSet<String> prjNames = new TreeSet<String>();
        for (URI location : projectLocations) {
            IN4JSProject p = (IN4JSProject)this.core.findProject(location).orNull();
            prjNames.add(p.getProjectName());
        }
        return prjNames;
    }

    public static enum ProjectStateOperation {
        NONE,
        PEEK,
        UPDATE;

    }
}

