/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui;

import com.google.common.base.Strings;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class XpectRunConfiguration {
    public static final String XT_FILE_TO_RUN = "XT_FILE_TO_RUN";
    public static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    final String configName;
    final String xtFileToRun;
    File workingDirectory;
    ILaunchConfigurationType configurationType;

    protected XpectRunConfiguration(String configName, String xtFileToRun) {
        this.xtFileToRun = Strings.isNullOrEmpty((String)xtFileToRun) ? "" : xtFileToRun;
        this.configName = configName;
    }

    public ILaunchConfiguration toLaunchConfiguration() throws CoreException {
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.configurationType);
        boolean configurationHasChanged = false;
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (this.configName.equals(config.getName()) && !(configurationHasChanged = this.hasConfigurationChanged(config))) {
                return config;
            }
            ++n2;
        }
        IContainer container = null;
        ILaunchConfigurationWorkingCopy workingCopy = this.configurationType.newInstance(container, this.configName);
        workingCopy.setAttribute(XT_FILE_TO_RUN, this.xtFileToRun);
        workingCopy.setAttribute(WORKING_DIRECTORY, this.workingDirectory.getAbsolutePath());
        return workingCopy.doSave();
    }

    private boolean hasConfigurationChanged(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(XT_FILE_TO_RUN, "") != this.xtFileToRun | config.getAttribute(WORKING_DIRECTORY, "") != this.workingDirectory.getAbsolutePath();
    }

    public static XpectRunConfiguration fromLaunchConfiguration(ILaunchConfiguration launchConfig) throws CoreException {
        String xtFileToRun = launchConfig.getAttribute(XT_FILE_TO_RUN, "");
        String name = launchConfig.getName();
        XpectRunConfiguration runConfig = new XpectRunConfiguration(name, xtFileToRun);
        runConfig.setConfigurationType(launchConfig.getType());
        String strWorkingDir = launchConfig.getAttribute(WORKING_DIRECTORY, "");
        File workingDir = null;
        if (!Strings.isNullOrEmpty((String)strWorkingDir)) {
            workingDir = new File(strWorkingDir);
        }
        runConfig.setWorkingDirectory(workingDir);
        return runConfig;
    }

    public static XpectRunConfiguration createToRunXtFile(String configName, String xtFileToRun) {
        return new XpectRunConfiguration(configName, xtFileToRun);
    }

    public boolean isRunXtFile() {
        return !Strings.isNullOrEmpty((String)this.xtFileToRun);
    }

    public String getXtFileToRun() {
        return this.xtFileToRun;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public ILaunchConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(ILaunchConfigurationType configurationType) {
        this.configurationType = configurationType;
    }
}

