/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.fileextensions.FileExtensionTypeHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.containers.N4JSProjectsStateHelper;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;
import org.eclipse.n4js.ui.internal.OwnResourceValidatorAwareValidatingEditorCallback;
import org.eclipse.n4js.ui.internal.ResourceUIValidatorExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.containers.AbstractAllContainersState;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.validation.CheckMode;

@Singleton
public class N4JSAllContainersState
extends AbstractAllContainersState {
    private static final Logger LOGGER = Logger.getLogger(N4JSAllContainersState.class);
    private static final String PLATFORM_RESOURCE_SCHEME = "platform:/resource";
    @Inject
    private N4JSProjectsStateHelper projectsHelper;
    @Inject
    private FileExtensionTypeHelper fileExtensionTypeHelper;
    @Inject
    private IN4JSCore core;
    @Inject
    private OwnResourceValidatorAwareValidatingEditorCallback editorCallback;
    @Inject
    private ResourceUIValidatorExtension validatorExtension;
    @Inject
    private ExternalLibraryBuilder externalLibraryBuilder;

    protected String doInitHandle(URI uri) {
        String handle = this.projectsHelper.initHandle(uri);
        return handle;
    }

    protected Collection<URI> doInitContainedURIs(String containerHandle) {
        Collection<URI> initContainedURIs = this.projectsHelper.initContainedURIs(containerHandle);
        return initContainedURIs;
    }

    protected List<String> doInitVisibleHandles(String handle) {
        List<String> visibleHandles = this.projectsHelper.initVisibleHandles(handle);
        return visibleHandles;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.updateProjectState(event);
        super.resourceChanged(event);
    }

    private void updateProjectState(IResourceChangeEvent event) {
        if (event.getDelta() != null) {
            IResourceDelta eventDelta = event.getDelta();
            try {
                eventDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource == null) {
                            return true;
                        }
                        IPath path = resource.getFullPath();
                        int pathLength = path.segmentCount();
                        if (pathLength <= 2) {
                            N4JSAllContainersState.this.updateProjectState(delta);
                        }
                        return pathLength == 0 || resource instanceof IProject;
                    }
                });
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Failed to process IResourceDelta", (Throwable)e);
            }
        }
    }

    private void updateProjectState(IResourceDelta delta) {
        if (delta.getKind() == 1 || delta.getKind() == 2) {
            if ("package.json".equals(delta.getFullPath().lastSegment())) {
                this.projectsHelper.clearProjectCache();
                return;
            }
            if (delta.getResource() instanceof IProject) {
                this.projectsHelper.clearProjectCache();
                return;
            }
            if (delta.getResource() instanceof IFolder && this.isSourceContainerModification(delta)) {
                this.tryValidateProjectDescriptionFile(delta);
                this.tryValidateProjectDescriptionInEditor(delta);
                this.projectsHelper.clearProjectCache(delta);
                return;
            }
            return;
        }
        if (delta.getKind() == 4 && delta.getResource() instanceof IProject) {
            if ((delta.getFlags() & 0x4000) != 0) {
                this.projectsHelper.clearProjectCache();
                return;
            }
            return;
        }
        if (this.packageJSONFileHasBeenChanged(delta)) {
            this.projectsHelper.clearProjectCache(delta);
            return;
        }
    }

    protected boolean isAffectingContainerState(IResourceDelta delta) {
        if (delta.getKind() == 1 || delta.getKind() == 2) {
            String fileExtension = delta.getFullPath().getFileExtension();
            if (fileExtension != null && this.fileExtensionTypeHelper.isTypable(fileExtension)) {
                return true;
            }
            if ("package.json".equals(delta.getFullPath().lastSegment())) {
                return true;
            }
            if (delta.getResource() instanceof IProject) {
                return true;
            }
            return delta.getResource() instanceof IFolder && this.isSourceContainerModification(delta);
        }
        if (delta.getKind() == 4 && delta.getResource() instanceof IProject) {
            if ((delta.getFlags() & 0x80000) != 0) {
                return true;
            }
            return (delta.getFlags() & 0x4000) != 0;
        }
        return this.packageJSONFileHasBeenChanged(delta);
    }

    private void tryValidateProjectDescriptionFile(IResourceDelta delta) {
        URI projectDescriptionLocation;
        String fullPath = delta.getFullPath().toString();
        URI folderUri = URI.createPlatformResourceURI((String)fullPath, (boolean)true);
        IN4JSProject project = (IN4JSProject)this.core.findProject(folderUri).orNull();
        if (project != null && project.exists() && (projectDescriptionLocation = (URI)project.getProjectDescriptionLocation().orNull()) != null) {
            IFile packageJSON = delta.getResource().getProject().getFile("package.json");
            ResourceSet resourceSet = this.core.createResourceSet(Optional.of((Object)project));
            Resource resource = resourceSet.getResource(projectDescriptionLocation, true);
            Job job = Job.create((String)("Update validation markers for " + resource.getURI()), monitor -> {
                ISchedulingRule rule = this.externalLibraryBuilder.getRule();
                try {
                    Job.getJobManager().beginRule(rule, monitor);
                    this.validatorExtension.updateValidationMarkers(packageJSON, resource, CheckMode.ALL, (IProgressMonitor)new NullProgressMonitor());
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
                return Status.OK_STATUS;
            });
            job.setPriority(10);
            job.schedule();
        }
    }

    private void tryValidateProjectDescriptionInEditor(IResourceDelta delta) {
        if (PlatformUI.isWorkbenchRunning()) {
            Runnable validateInEditorRunnable = () -> {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPart part;
                        IEditorReference editorRef = iEditorReferenceArray[n2];
                        if (this.isEditorForProjectDescriptionResource(editorRef, delta.getResource()) && (part = editorRef.getPart(true)) instanceof XtextEditor) {
                            this.editorCallback.afterSave((XtextEditor)part);
                            return;
                        }
                        ++n2;
                    }
                }
            };
            Display.getDefault().asyncExec(validateInEditorRunnable);
        }
    }

    private boolean isEditorForProjectDescriptionResource(IEditorReference editorRef, IResource resource) {
        IFile packageJSON = resource.getProject().getFile("package.json");
        if (!packageJSON.exists()) {
            return false;
        }
        try {
            IEditorInput input = editorRef.getEditorInput();
            if (input instanceof IFileEditorInput) {
                return ((IFileEditorInput)input).getFile().equals((Object)packageJSON);
            }
        }
        catch (PartInitException e) {
            LOGGER.warn((Object)("Error while trying to get editor input for editor reference: " + editorRef), (Throwable)e);
        }
        return false;
    }

    private boolean isSourceContainerModification(IResourceDelta delta) {
        String fullPathStr = delta.getFullPath().toString();
        URI folderUri = URI.createPlatformResourceURI((String)fullPathStr, (boolean)true);
        IN4JSProject project = (IN4JSProject)this.core.findProject(folderUri).orNull();
        if (project != null && project.exists()) {
            return FluentIterable.from((Iterable)project.getSourceContainers()).transform(container -> container.getLocation()).filter(uri -> uri.isPlatformResource()).transform(uri -> uri.toString()).transform(uri -> uri.replaceFirst(PLATFORM_RESOURCE_SCHEME, "")).firstMatch(uri -> uri.equals(fullPathStr)).isPresent();
        }
        return false;
    }

    private boolean packageJSONFileHasBeenChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && delta.getResource().getType() == 1 && "package.json".equalsIgnoreCase(delta.getFullPath().lastSegment());
    }
}

