/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.dialog.ModuleSpecifierSelectionDialog;
import org.eclipse.n4js.ui.dialog.ProjectSelectionDialog;
import org.eclipse.n4js.ui.dialog.SourceFolderSelectionDialog;
import org.eclipse.n4js.ui.wizard.components.WizardComponentContainer;
import org.eclipse.n4js.ui.wizard.components.WizardComponentDataConverters;
import org.eclipse.n4js.ui.wizard.contentproposal.ModuleSpecifierContentProposalProviderFactory;
import org.eclipse.n4js.ui.wizard.contentproposal.ProjectContentProposalProvider;
import org.eclipse.n4js.ui.wizard.contentproposal.SimpleImageContentProposalLabelProvider;
import org.eclipse.n4js.ui.wizard.contentproposal.SourceFolderContentProposalProviderFactory;
import org.eclipse.n4js.ui.wizard.workspace.SuffixText;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModelValidator;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardPageForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class WorkspaceWizardPage<M extends WorkspaceWizardModel>
extends WizardPage
implements WizardComponentContainer {
    private static final String CONTENT_ASSIST_ECLIPSE_COMMAND_ID = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private static final Image CONTENT_PROPOSAL_DECORATION_IMAGE = (Image)ImageDescriptorCache.ImageRef.SMART_LIGHTBULB.asImage().orNull();
    private M model;
    private DataBindingContext databindingContext;
    protected WorkspaceWizardPageForm workspaceWizardControl;
    private Image contentProposalDecorationImage;
    @Inject
    private Provider<ProjectSelectionDialog> projectSelectionDialogProvider;
    @Inject
    private Provider<SourceFolderSelectionDialog> sourceFolderSelectionDialogProvider;
    @Inject
    private ProjectContentProposalProvider projectContentProposalProvider;
    @Inject
    private SourceFolderContentProposalProviderFactory sourceFolderContentProviderFactory;
    @Inject
    private ModuleSpecifierContentProposalProviderFactory moduleSpecifierContentProviderFactory;
    private ContentProposalAdapter sourceFolderContentProposalAdapter;
    private ContentProposalAdapter moduleSpecifierContentProposalAdapter;

    protected WorkspaceWizardPage() {
        super(WorkspaceWizardPage.class.getName());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.workspaceWizardControl = new WorkspaceWizardPageForm(parent, 4);
        if (this.contentProposalDecorationImage == null || this.contentProposalDecorationImage.isDisposed()) {
            this.contentProposalDecorationImage = CONTENT_PROPOSAL_DECORATION_IMAGE;
        }
        this.setupBindings(this.workspaceWizardControl);
        this.setupBrowseDialogs(this.workspaceWizardControl);
        this.setupContentProposal(this.workspaceWizardControl);
        this.createComponents(this);
        this.workspaceWizardControl.setBackground(parent.getBackground());
        this.setControl((Control)this.workspaceWizardControl);
    }

    public void openModuleSpecifierDialog(Shell shell) {
        ModuleSpecifierSelectionDialog dialog = new ModuleSpecifierSelectionDialog(shell, ((WorkspaceWizardModel)this.model).getProject().append(((WorkspaceWizardModel)this.model).getSourceFolder()));
        if (!((WorkspaceWizardModel)this.model).getModuleSpecifier().isEmpty()) {
            String initialSelectionSpecifier = ((WorkspaceWizardModel)this.model).getModuleSpecifier();
            dialog.setInitialSelection(initialSelectionSpecifier);
        }
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof String) {
            Path specifierPath = new Path((String)result);
            ((WorkspaceWizardModel)this.model).setModuleSpecifier(specifierPath.removeFileExtension().toString());
        }
    }

    public void openProjectDialog(Shell shell) {
        ProjectSelectionDialog dialog = (ProjectSelectionDialog)((Object)this.projectSelectionDialogProvider.get());
        dialog.open();
        Object firstResult = dialog.getFirstResult();
        if (firstResult instanceof IProject) {
            ((WorkspaceWizardModel)this.model).setProject((IPath)new Path(((IProject)firstResult).getName()));
        }
    }

    public void openSourceFolderBrowseDialog(Shell shell) {
        SourceFolderSelectionDialog dialog = (SourceFolderSelectionDialog)((Object)this.sourceFolderSelectionDialogProvider.get());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(((WorkspaceWizardModel)this.model).getProject().segment(0));
        dialog.setInput(project);
        dialog.setInitialSelections(new Object[]{((WorkspaceWizardModel)this.model).getSourceFolder().removeTrailingSeparator().toString()});
        dialog.open();
        String firstResult = dialog.getFirstResult();
        if (firstResult instanceof String) {
            ((WorkspaceWizardModel)this.model).setSourceFolder((IPath)new Path(firstResult));
        }
    }

    private void setupBindings(WorkspaceWizardPageForm wizardForm) {
        this.databindingContext = new DataBindingContext();
        final WorkspaceWizardModelValidator<M> validator = this.getValidator();
        IObservableValue projectModelValue = BeanProperties.value(WorkspaceWizardModel.class, (String)"project").observe(this.model);
        ISWTObservableValue projectUI = WidgetProperties.text((int)24).observe((Widget)wizardForm.getProjectText());
        this.databindingContext.bindValue((IObservableValue)projectUI, projectModelValue, new WizardComponentDataConverters.StringToPathConverter().updatingValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        IObservableValue sourceFolderModelValue = BeanProperties.value(WorkspaceWizardModel.class, (String)"sourceFolder").observe(this.model);
        ISWTObservableValue sourceFolderUI = WidgetProperties.text((int)24).observe((Widget)wizardForm.getSourceFolderText());
        this.databindingContext.bindValue((IObservableValue)sourceFolderUI, sourceFolderModelValue, new WizardComponentDataConverters.StringToPathConverter().updatingValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        IObservableValue projectValidModelValue = BeanProperties.value(WorkspaceWizardModelValidator.class, (String)"projectValid").observe(validator);
        ISWTObservableValue sourceFolderBrowseEnabled = WidgetProperties.enabled().observe((Widget)wizardForm.getSourceFolderBrowseButton());
        this.databindingContext.bindValue((IObservableValue)sourceFolderBrowseEnabled, projectValidModelValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        IObservableValue moduleSpecifierModelValue = BeanProperties.value(WorkspaceWizardModel.class, (String)"moduleSpecifier").observe(this.model);
        IObservableValue moduleSpecifierUI = BeanProperties.value(SuffixText.class, (String)"text").observe((Object)wizardForm.getModuleSpecifierText());
        this.databindingContext.bindValue(moduleSpecifierUI, moduleSpecifierModelValue);
        ISWTObservableValue moduleSpecifierBrowseEnabled = WidgetProperties.enabled().observe((Widget)wizardForm.getModuleSpecifierBrowseButton());
        IObservableValue sourceFolderValidValue = BeanProperties.value(WorkspaceWizardModelValidator.class, (String)"sourceFolderValid").observe(validator);
        IObservableValue projectValidValue = BeanProperties.value(WorkspaceWizardModelValidator.class, (String)"projectValid").observe(validator);
        WizardComponentDataConverters.ConditionalConverter moduleSpecifierBrowseableConverter = new WizardComponentDataConverters.ConditionalConverter(){

            @Override
            public boolean validate(Object object) {
                return validator.getSourceFolderValid() && validator.getProjectValid();
            }
        };
        this.databindingContext.bindValue((IObservableValue)moduleSpecifierBrowseEnabled, projectValidValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), moduleSpecifierBrowseableConverter.updatingValueStrategy());
        this.databindingContext.bindValue((IObservableValue)moduleSpecifierBrowseEnabled, sourceFolderValidValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), moduleSpecifierBrowseableConverter.updatingValueStrategy());
    }

    private void setupBrowseDialogs(final WorkspaceWizardPageForm wizardForm) {
        wizardForm.getProjectBrowseButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceWizardPage.this.openProjectDialog(wizardForm.getShell());
            }
        });
        wizardForm.getSourceFolderBrowseButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceWizardPage.this.openSourceFolderBrowseDialog(wizardForm.getShell());
            }
        });
        wizardForm.getModuleSpecifierBrowseButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceWizardPage.this.openModuleSpecifierDialog(wizardForm.getShell());
            }
        });
    }

    private void setupContentProposal(WorkspaceWizardPageForm wizardForm) {
        KeyStroke keyInitiator = this.getActiveContentAssistBinding();
        if (keyInitiator == null) {
            return;
        }
        ContentProposalAdapter projectAdapter = new ContentProposalAdapter((Control)wizardForm.getProjectText(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.projectContentProposalProvider, keyInitiator, null);
        projectAdapter.setProposalAcceptanceStyle(2);
        ImageDescriptor projectSymbol = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        projectAdapter.setLabelProvider((ILabelProvider)new SimpleImageContentProposalLabelProvider(projectSymbol));
        this.createContentProposalDecoration((Control)wizardForm.getProjectText());
        this.sourceFolderContentProposalAdapter = new ContentProposalAdapter((Control)wizardForm.getSourceFolderText(), (IControlContentAdapter)new TextContentAdapter(), null, keyInitiator, null);
        this.sourceFolderContentProposalAdapter.setProposalAcceptanceStyle(2);
        this.sourceFolderContentProposalAdapter.setLabelProvider((ILabelProvider)new SimpleImageContentProposalLabelProvider((ImageDescriptor)ImageDescriptorCache.ImageRef.SRC_FOLDER.asImageDescriptor().orNull()));
        this.createContentProposalDecoration((Control)wizardForm.getSourceFolderText());
        this.moduleSpecifierContentProposalAdapter = new ContentProposalAdapter((Control)wizardForm.getModuleSpecifierText().getInternalText(), (IControlContentAdapter)new TextContentAdapter(), null, keyInitiator, null);
        wizardForm.getModuleSpecifierText().createDecoration(this.contentProposalDecorationImage);
        ((WorkspaceWizardModel)this.model).addPropertyChangeListener(evt -> {
            if (evt.getPropertyName() == "project" || evt.getPropertyName() == "sourceFolder") {
                this.updateProposalContext();
            }
        });
        this.updateProposalContext();
        this.moduleSpecifierContentProposalAdapter.setProposalAcceptanceStyle(2);
        this.moduleSpecifierContentProposalAdapter.setLabelProvider((ILabelProvider)new ModuleSpecifierContentProposalProviderFactory.ModuleSpecifierProposalLabelProvider());
    }

    private KeyStroke getActiveContentAssistBinding() {
        KeyStroke[] strokes;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] activeBindingsFor = bindingService.getActiveBindingsFor(CONTENT_ASSIST_ECLIPSE_COMMAND_ID);
        if (activeBindingsFor.length > 0 && activeBindingsFor[0] instanceof KeySequence && (strokes = ((KeySequence)activeBindingsFor[0]).getKeyStrokes()).length == 1) {
            return strokes[0];
        }
        return null;
    }

    private ControlDecoration createContentProposalDecoration(Control control) {
        ControlDecoration decoration = new ControlDecoration(control, 16512);
        decoration.setImage(this.contentProposalDecorationImage);
        decoration.setShowOnlyOnFocus(true);
        return decoration;
    }

    private void updateProposalContext() {
        IPath projectPath = ((WorkspaceWizardModel)this.model).getProject();
        IPath sourceFolderPath = ((WorkspaceWizardModel)this.model).getSourceFolder();
        if (projectPath.isEmpty()) {
            this.sourceFolderContentProposalAdapter.setContentProposalProvider(null);
            this.moduleSpecifierContentProposalAdapter.setContentProposalProvider(null);
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.toString());
        if (project == null || !project.exists()) {
            this.sourceFolderContentProposalAdapter.setContentProposalProvider(null);
            this.moduleSpecifierContentProposalAdapter.setContentProposalProvider(null);
        } else {
            IFolder sourceFolder = sourceFolderPath.segmentCount() != 0 ? project.getFolder(sourceFolderPath) : null;
            this.sourceFolderContentProposalAdapter.setContentProposalProvider(this.sourceFolderContentProviderFactory.createProviderForProject(project));
            if (sourceFolder != null && sourceFolder.exists()) {
                this.moduleSpecifierContentProposalAdapter.setContentProposalProvider(this.moduleSpecifierContentProviderFactory.createProviderForPath(sourceFolder.getFullPath()));
            } else {
                this.moduleSpecifierContentProposalAdapter.setContentProposalProvider(null);
            }
        }
    }

    public void setModel(M model) {
        this.model = model;
        this.getValidator().setModel(this.model);
        ((WorkspaceWizardModel)this.model).addPropertyChangeListener(evt -> {
            WorkspaceWizardModelValidator.ValidationResult validationResult = this.getValidator().validate();
        });
    }

    public M getModel() {
        return this.model;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setInitialFocus();
        }
    }

    protected boolean setInitialFocus() {
        if (((WorkspaceWizardModel)this.model).getProject().toString().isEmpty()) {
            this.workspaceWizardControl.getProjectText().setFocus();
        } else if (((WorkspaceWizardModel)this.model).getSourceFolder().toString().isEmpty()) {
            this.workspaceWizardControl.getSourceFolderText().setFocus();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public DataBindingContext getDataBindingContext() {
        return this.databindingContext;
    }

    public void dispose() {
        super.dispose();
        if (this.databindingContext != null) {
            this.databindingContext.dispose();
        }
    }

    @Override
    public Composite getComposite() {
        return this.workspaceWizardControl;
    }

    public abstract WorkspaceWizardModelValidator<M> getValidator();

    public abstract void createComponents(WizardComponentContainer var1);
}

