/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MemberAccessModifier implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    PRIVATE(1, "private", "private"),
    PROJECT(2, "project", "project"),
    PROTECTED_INTERNAL(3, "protectedInternal", "protectedInternal"),
    PROTECTED(4, "protected", "protected"),
    PUBLIC_INTERNAL(5, "publicInternal", "publicInternal"),
    PUBLIC(6, "public", "public");

    public static final int UNDEFINED_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROJECT_VALUE = 2;
    public static final int PROTECTED_INTERNAL_VALUE = 3;
    public static final int PROTECTED_VALUE = 4;
    public static final int PUBLIC_INTERNAL_VALUE = 5;
    public static final int PUBLIC_VALUE = 6;
    private static final MemberAccessModifier[] VALUES_ARRAY;
    public static final List<MemberAccessModifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MemberAccessModifier[]{UNDEFINED, PRIVATE, PROJECT, PROTECTED_INTERNAL, PROTECTED, PUBLIC_INTERNAL, PUBLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MemberAccessModifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemberAccessModifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemberAccessModifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemberAccessModifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemberAccessModifier get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROJECT;
            }
            case 3: {
                return PROTECTED_INTERNAL;
            }
            case 4: {
                return PROTECTED;
            }
            case 5: {
                return PUBLIC_INTERNAL;
            }
            case 6: {
                return PUBLIC;
            }
        }
        return null;
    }

    private MemberAccessModifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

