/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.text.Format;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;

public abstract class NumberToNumberConverter<T extends Number>
extends Converter<Object, T> {
    private Format numberFormat;
    private boolean primitive;
    private String outOfRangeMessage;

    protected NumberToNumberConverter(Format numberFormat, Class<?> fromType, Class<?> toType) {
        super(fromType, toType);
        this.numberFormat = numberFormat;
        this.primitive = toType.isPrimitive();
    }

    @Override
    public final T convert(Object fromObject) {
        if (fromObject == null) {
            if (this.primitive) {
                throw new IllegalArgumentException("Parameter 'fromObject' cannot be null.");
            }
            return null;
        }
        if (!(fromObject instanceof Number)) {
            throw new IllegalArgumentException("Parameter 'fromObject' must be of type Number.");
        }
        Number number = (Number)fromObject;
        T result = this.doConvert(number);
        if (result != null) {
            return result;
        }
        NumberToNumberConverter numberToNumberConverter = this;
        synchronized (numberToNumberConverter) {
            if (this.outOfRangeMessage == null) {
                this.outOfRangeMessage = StringToNumberParser.createOutOfRangeMessage((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, this.numberFormat);
            }
            throw new IllegalArgumentException(this.outOfRangeMessage);
        }
    }

    protected abstract T doConvert(Number var1);

    public Format getNumberFormat() {
        return this.numberFormat;
    }
}

