/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.parser;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.PropertyNameKind;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.DefaultEcoreElementFactory;
import org.eclipse.xtext.xtext.RuleNames;

@Singleton
public class PropertyNameAwareElementFactory
extends DefaultEcoreElementFactory {
    private String stringRuleName;
    private String identifierRuleName;
    private String numberRuleName;

    @Inject
    private void readRuleNames(N4JSGrammarAccess grammarAccess, RuleNames ruleNames) {
        this.stringRuleName = ruleNames.getQualifiedName((AbstractRule)grammarAccess.getSTRINGRule());
        this.identifierRuleName = ruleNames.getQualifiedName((AbstractRule)grammarAccess.getIdentifierNameRule());
        this.numberRuleName = ruleNames.getQualifiedName((AbstractRule)grammarAccess.getNumericLiteralAsStringRule());
    }

    public void set(EObject object, String feature, Object value, String ruleName, INode node) throws N4JSValueConverterException {
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(feature);
        if (structuralFeature == null) {
            throw new IllegalArgumentException(String.valueOf(object.eClass().getName()) + "." + feature + " does not exist");
        }
        try {
            Object tokenValue = this.getTokenValue(value, ruleName, node);
            this.checkNullForPrimitiveFeatures(structuralFeature, tokenValue, node);
            object.eSet(structuralFeature, tokenValue);
            this.setPropertyNameKind(object, feature, ruleName);
            this.setRawStringValue(object, feature, value);
        }
        catch (ValueConverterWithValueException e) {
            Object tokenValue = e.getValue();
            this.checkNullForPrimitiveFeatures(structuralFeature, tokenValue, node);
            object.eSet(structuralFeature, tokenValue);
            this.setPropertyNameKind(object, feature, ruleName);
            this.setRawStringValue(object, feature, value);
            throw e;
        }
        catch (ValueConverterException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_NPE(), "VCO_NPE", node, e);
        }
        catch (Exception e) {
            throw new ValueConverterException(null, node, e);
        }
    }

    private void setRawStringValue(EObject object, String feature, Object value) {
        EClass eClass = object.eClass();
        if (eClass == N4JSPackage.Literals.STRING_LITERAL && N4JSPackage.Literals.STRING_LITERAL__VALUE.getName().equals(feature)) {
            StringLiteral casted = (StringLiteral)object;
            casted.setRawValue((String)this.getTokenAsStringIfPossible(value));
        } else if (eClass == N4JSPackage.Literals.TEMPLATE_SEGMENT && N4JSPackage.Literals.TEMPLATE_SEGMENT__VALUE.getName().equals(feature)) {
            TemplateSegment casted = (TemplateSegment)object;
            String rawValueFromSource = (String)this.getTokenAsStringIfPossible(value);
            String rawValueNormalized = PropertyNameAwareElementFactory.normalizeTemplateSegmentRawValue(rawValueFromSource);
            casted.setRawValue(rawValueNormalized);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyNameKind(EObject object, String feature, String ruleName) {
        if (!(object instanceof LiteralOrComputedPropertyName)) return;
        LiteralOrComputedPropertyName nameDecl = (LiteralOrComputedPropertyName)object;
        if ("literalName".equals(feature)) {
            if (this.identifierRuleName.equals(ruleName)) {
                nameDecl.setKind(PropertyNameKind.IDENTIFIER);
                return;
            } else if (this.stringRuleName.equals(ruleName)) {
                nameDecl.setKind(PropertyNameKind.STRING);
                return;
            } else {
                if (!this.numberRuleName.equals(ruleName)) throw new IllegalArgumentException(ruleName);
                nameDecl.setKind(PropertyNameKind.NUMBER);
            }
            return;
        } else {
            if (!"expression".equals(feature)) return;
            nameDecl.setKind(PropertyNameKind.COMPUTED);
        }
    }

    private Object getTokenValue(Object tokenOrValue, String ruleName, INode node) throws N4JSValueConverterException {
        Object value = this.getTokenAsStringIfPossible(tokenOrValue);
        if ((value == null || value instanceof CharSequence) && ruleName != null) {
            value = this.getConverterService().toValue(value == null ? null : value.toString(), ruleName, node);
        }
        return value;
    }

    private void checkNullForPrimitiveFeatures(EStructuralFeature structuralFeature, Object tokenValue, INode node) {
        if (tokenValue == null && structuralFeature.getEType().getInstanceClass().isPrimitive()) {
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_NULL_FEATURE(structuralFeature.getName()), "VCO_NULL_FEATURE", node, null);
        }
    }

    private static String normalizeTemplateSegmentRawValue(String rawSourceCode) {
        if (!(rawSourceCode == null || rawSourceCode.startsWith("`") && rawSourceCode.length() != 1)) {
            return "}" + rawSourceCode;
        }
        return rawSourceCode;
    }
}

