/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSNamespaceImportTypesBuilder {
    public void relinkNamespaceTypes(Script script, TModule target, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            Map<String, ModuleNamespaceVirtualType> namespaceTypesByName = this.getExistingNamespaceTypesByName(target);
            List _list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
            for (ImportDeclaration importDeclaration : _list) {
                NamespaceImportSpecifier namespaceImport = this.getNamespaceImportSpecifier(importDeclaration);
                if (namespaceImport == null) continue;
                Object _eGet = importDeclaration.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), false);
                TModule importedModule = (TModule)_eGet;
                ModuleNamespaceVirtualType existingNamespaceType = namespaceTypesByName.get(namespaceImport.getAlias());
                if (existingNamespaceType != null) {
                    this.relinkNamespaceType(existingNamespaceType, namespaceImport, importedModule);
                    continue;
                }
                EList _internalTypes = target.getInternalTypes();
                ModuleNamespaceVirtualType _createModuleNamespaceVirtualType = this.createModuleNamespaceVirtualType(namespaceImport, importedModule);
                _internalTypes.add((Object)_createModuleNamespaceVirtualType);
            }
        }
    }

    public ModuleNamespaceVirtualType createModuleNamespaceVirtualType(NamespaceImportSpecifier importSpecifier, TModule importedModule) {
        ModuleNamespaceVirtualType type = TypesFactory.eINSTANCE.createModuleNamespaceVirtualType();
        type.setName(importSpecifier.getAlias());
        type.setModule(importedModule);
        type.setDeclaredDynamic(importSpecifier.isDeclaredDynamic());
        type.setAstElement((EObject)importSpecifier);
        importSpecifier.setDefinedType((Type)type);
        return type;
    }

    public NamespaceImportSpecifier getNamespaceImportSpecifier(ImportDeclaration importDeclaration) {
        boolean _not;
        List namespaceImportSpecifiers = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)importDeclaration.getImportSpecifiers(), NamespaceImportSpecifier.class));
        boolean _isEmpty = namespaceImportSpecifiers.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return (NamespaceImportSpecifier)IterableExtensions.head((Iterable)namespaceImportSpecifiers);
        }
        return null;
    }

    private void relinkNamespaceType(ModuleNamespaceVirtualType namespaceType, NamespaceImportSpecifier namespaceImportSpecifier, TModule importedModule) {
        namespaceType.setModule(importedModule);
        namespaceType.setAstElement((EObject)namespaceImportSpecifier);
        namespaceImportSpecifier.setDefinedType((Type)namespaceType);
    }

    private Map<String, ModuleNamespaceVirtualType> getExistingNamespaceTypesByName(TModule module) {
        EList _exposedInternalTypes;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        HashMap<String, ModuleNamespaceVirtualType> namespaceTypesByName = new HashMap<String, ModuleNamespaceVirtualType>();
        EList _internalTypes = module.getInternalTypes();
        boolean bl = _tripleNotEquals = _internalTypes != null;
        if (_tripleNotEquals) {
            Consumer<ModuleNamespaceVirtualType> _function = type -> namespaceTypesByName.put(type.getName(), (ModuleNamespaceVirtualType)type);
            Iterables.filter((Iterable)module.getInternalTypes(), ModuleNamespaceVirtualType.class).forEach(_function);
        }
        boolean bl2 = _tripleNotEquals_1 = (_exposedInternalTypes = module.getExposedInternalTypes()) != null;
        if (_tripleNotEquals_1) {
            Consumer<ModuleNamespaceVirtualType> _function_1 = type -> namespaceTypesByName.put(type.getName(), (ModuleNamespaceVirtualType)type);
            Iterables.filter((Iterable)module.getExposedInternalTypes(), ModuleNamespaceVirtualType.class).forEach(_function_1);
        }
        return namespaceTypesByName;
    }
}

