/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4idl.versioning.VersionHelper;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.VersionedReference;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4IDLValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private VersionHelper versionHelper;
    @Inject
    private JavaScriptVariantHelper variantHelper;
    @Inject
    private N4JSElementKeywordProvider elementKeywordProvider;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkVersion(VersionedReference ref) {
        if (ref == null) {
            return;
        }
        EObject context = ref.eContainer();
        if (context != null) {
            boolean _greaterThan;
            boolean _not;
            int _xifexpression = 0;
            BigDecimal _requestedVersion = ref.getRequestedVersion();
            boolean _tripleEquals = _requestedVersion == null;
            _xifexpression = _tripleEquals ? 0 : ref.getRequestedVersion().intValue();
            int requestedVersion = _xifexpression;
            Optional<Integer> maxVersion = this.versionHelper.computeMaximumVersion(context);
            boolean _isPresent = maxVersion.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                return;
            }
            Integer _get = (Integer)maxVersion.get();
            boolean bl2 = _greaterThan = requestedVersion > _get;
            if (_greaterThan) {
                String message = IssueCodes.getMessageForIDL_INVALID_VERSION(requestedVersion, maxVersion.get());
                this.addIssue(message, context, ref.eContainingFeature(), "IDL_INVALID_VERSION", new String[0]);
            }
        }
    }

    @Check
    public void checkExplicitVersionDeclaration(VersionedReference ref) {
        boolean _not_1;
        boolean _not;
        boolean _allowVersionedTypes = this.variantHelper.allowVersionedTypes((EObject)ref);
        boolean bl = _not = !_allowVersionedTypes;
        if (_not) {
            return;
        }
        boolean _isVersionAwareContext = VersionUtils.isVersionAwareContext((EObject)ref);
        boolean bl2 = _not_1 = !_isVersionAwareContext;
        if (_not_1) {
            String message = IssueCodes.getMessageForIDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED();
            this.addIssue(message, (EObject)ref, (EStructuralFeature)TypeRefsPackage.Literals.VERSIONED_REFERENCE__REQUESTED_VERSION, "IDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED", new String[0]);
        }
    }

    @Check
    public void checkTypeDeclaration(N4TypeDeclaration n4TypeDeclaration) {
        boolean _not;
        boolean _allowVersionedTypes = this.variantHelper.allowVersionedTypes((EObject)n4TypeDeclaration);
        boolean bl = _not = !_allowVersionedTypes;
        if (_not) {
            return;
        }
        if (n4TypeDeclaration instanceof VersionedElement) {
            if (!((VersionedElement)n4TypeDeclaration).hasDeclaredVersion() && !VersionUtils.hasVersionAwarenessAnnotation((AnnotableElement)n4TypeDeclaration)) {
                String message = IssueCodes.getMessageForIDL_VERSIONED_ELEMENT_MISSING_VERSION(this.elementKeywordProvider.keyword(n4TypeDeclaration), n4TypeDeclaration.getName());
                this.addIssue(message, (EObject)n4TypeDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "IDL_VERSIONED_ELEMENT_MISSING_VERSION", new String[0]);
            }
            if (((VersionedElement)n4TypeDeclaration).hasDeclaredVersion() && VersionUtils.hasVersionAwarenessAnnotation((AnnotableElement)n4TypeDeclaration)) {
                this.addIssue(IssueCodes.getMessageForIDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION(), (EObject)n4TypeDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "IDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION", new String[0]);
            }
        }
    }

    @Check
    public void checkVersionedElements(VersionedElement versionedElement) {
        boolean _isVersioned;
        boolean _not;
        boolean _allowVersionedTypes = this.variantHelper.allowVersionedTypes((EObject)versionedElement);
        boolean bl = _not = !_allowVersionedTypes;
        if (_not && (_isVersioned = VersionUtils.isVersioned((EObject)versionedElement))) {
            this.addIssueForUnsupportedVersionedTypes((EObject)versionedElement);
        }
    }

    @Check
    public void checkVersionedReferencesSupported(VersionedReference versionedReference) {
        if (!this.variantHelper.allowVersionedTypes((EObject)versionedReference) && versionedReference.hasRequestedVersion()) {
            this.addIssueForUnsupportedVersionedTypes((EObject)versionedReference);
        }
    }

    private void addIssueForUnsupportedVersionedTypes(EObject element) {
        String variantName = this.variantHelper.getVariantName(element);
        this.addIssue(IssueCodes.getMessageForIDL_VERSIONED_TYPES_NOT_SUPPORTED(variantName), element, "IDL_VERSIONED_TYPES_NOT_SUPPORTED");
    }

    @Check
    public void checkTopLevelElements(Script script) {
        boolean _not;
        boolean _allowTopLevelStatements = this.variantHelper.allowTopLevelStatements((EObject)script);
        boolean bl = _not = !_allowTopLevelStatements;
        if (_not) {
            Consumer<ScriptElement> _function = it -> this.handleScriptElement((ScriptElement)it);
            script.getScriptElements().stream().forEach(_function);
        }
    }

    private void handleScriptElement(ScriptElement element) {
        if (this.isStatement((EObject)element) && element.eContainer().eContainer() == null) {
            boolean _isConstVariableDeclaration = this.isConstVariableDeclaration((EObject)element);
            if (_isConstVariableDeclaration) {
                return;
            }
            String variantName = this.variantHelper.getVariantName((EObject)element);
            this.addIssue(IssueCodes.getMessageForAST_TOP_LEVEL_STATEMENTS(variantName), (EObject)element, "AST_TOP_LEVEL_STATEMENTS");
        }
    }

    private boolean isConstVariableDeclaration(EObject element) {
        return element instanceof VariableStatement && Objects.equal((Object)((VariableStatement)element).getVarStmtKeyword(), (Object)VariableStatementKeyword.CONST);
    }

    private boolean isStatement(EObject element) {
        return element instanceof Statement && !(element instanceof FunctionDeclaration);
    }
}

