/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Region;

public class AntModelProblem
extends Region
implements IProblem {
    public static final int NO_PROBLEM = -1;
    public static final int SEVERITY_WARNING = 0;
    public static final int SEVERITY_ERROR = 1;
    public static final int SEVERITY_FATAL_ERROR = 2;
    private String fMessage;
    private String fEscapedMessage;
    private int fSeverity;
    private int fAdjustedLength = -1;
    private int fLineNumber = -1;

    public AntModelProblem(String message, int severity, int offset, int length, int lineNumber) {
        super(offset, length);
        this.fMessage = message;
        this.fEscapedMessage = this.getEscaped(message);
        this.fSeverity = severity;
        this.fLineNumber = lineNumber;
    }

    @Override
    public String getMessage() {
        return this.fEscapedMessage;
    }

    @Override
    public boolean isError() {
        return this.fSeverity == 1 || this.fSeverity == 2;
    }

    @Override
    public boolean isWarning() {
        return this.fSeverity == 0;
    }

    public int getLength() {
        if (this.fAdjustedLength != -1) {
            return this.fAdjustedLength;
        }
        return super.getLength();
    }

    public void setLength(int adjustedLength) {
        this.fAdjustedLength = adjustedLength;
    }

    @Override
    public int getLineNumber() {
        return this.fLineNumber;
    }

    private void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = this.getReplacement(c);
        if (replacement != null) {
            buffer.append(replacement);
        } else {
            buffer.append(c);
        }
    }

    private String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            this.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @Override
    public String getUnmodifiedMessage() {
        return this.fMessage;
    }

    public static int getSeverity(String preferenceKey) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        String severityLevel = store.getString(preferenceKey);
        if (severityLevel.length() == 0 || severityLevel.equals("error")) {
            return 1;
        }
        if (severityLevel.equals("warning")) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        boolean equal = super.equals(o);
        if (equal) {
            return ((AntModelProblem)o).getUnmodifiedMessage().equals(this.getUnmodifiedMessage());
        }
        return false;
    }
}

