/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.smith.ui.CFGraphProvider;
import org.eclipse.n4js.smith.ui.graph.CFNode;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.Graph;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.ITextRegion;

public class CFGraph
extends Graph<CFGraphProvider> {
    final ILocationInFileProvider locFileProvider;
    final XtextEditor editor;
    final StyledText styledText;
    final NavigableMap<CFNode, ControlFlowElement> nodeMap = new TreeMap<CFNode, ControlFlowElement>(new CFEComparator());
    private CFGraphProvider gProvider;
    private boolean layoutDone = false;

    public CFGraph() {
        this.locFileProvider = new DefaultLocationInFileProvider();
        this.editor = EditorUtils.getActiveXtextEditor();
        this.styledText = this.editor.getInternalSourceViewer().getTextWidget();
    }

    @Override
    public void build(CFGraphProvider provider, Object input) {
        this.clear();
        this.nodeMap.clear();
        this.gProvider = provider;
        Collection<ControlFlowElement> cfes = this.gProvider.getElements(input);
        for (ControlFlowElement cfe : cfes) {
            if (cfe instanceof Script) continue;
            if (FGUtils.isCFContainer((EObject)cfe)) {
                CFNode entryNode = this.gProvider.getEntryNode(cfe);
                CFNode exitNode = this.gProvider.getExitNode(cfe);
                this.nodeMap.put(entryNode, entryNode.getControlFlowElement());
                this.nodeMap.put(exitNode, exitNode.getControlFlowElement());
                this.nodes.add(entryNode);
                this.nodes.add(exitNode);
                List<Edge> succs = this.gProvider.getConnectedEdges(entryNode, null);
                this.edges.addAll(succs);
                continue;
            }
            CFNode node = this.gProvider.getNode(cfe);
            this.nodes.add(node);
            this.nodeMap.put(node, cfe);
            List<Edge> succs = this.gProvider.getConnectedEdges(node, null);
            this.edges.addAll(succs);
        }
    }

    @Override
    public void layout(GC gc) {
        if (this.layoutDone) {
            return;
        }
        int lastLine = 0;
        int posInLine = 70;
        int lineCounter = 0;
        int entryLineCounter = 0;
        Set entries = this.nodeMap.entrySet();
        Iterator entriesIt = entries.iterator();
        CFNode lastNode = null;
        while (entriesIt.hasNext()) {
            boolean lineChange;
            Map.Entry entry = entriesIt.next();
            CFNode node = (CFNode)entry.getKey();
            ControlFlowElement cfe = (ControlFlowElement)entry.getValue();
            int line = this.getLineEnd(cfe);
            boolean bl = lineChange = lastLine != line;
            if (lineChange) {
                boolean isContainer;
                posInLine = 70;
                boolean lastIsEntry = lastNode != null && lastNode.isEntry;
                boolean lastIsExit = lastNode != null && lastNode.isExit;
                boolean bl2 = isContainer = node.isEntry || node.isExit;
                if (!(lastIsEntry || lastIsExit || isContainer)) {
                    ++lineCounter;
                }
                if (lastIsExit || node.isEntry) {
                    lineCounter += 2;
                }
                if (node.isExit && entryLineCounter == lineCounter) {
                    ++lineCounter;
                }
            }
            node.x = node.isEntry || node.isExit ? 0 : posInLine;
            node.y = lineCounter * 100;
            node.trim(gc);
            posInLine = (int)((float)posInLine + (node.width + 50.0f));
            lastNode = node;
            lastLine = line;
            if (!node.isEntry) continue;
            entryLineCounter = lineCounter;
        }
        this.layoutDone = true;
    }

    private int getOffsetStart(ControlFlowElement cfe) {
        ITextRegion tr = this.locFileProvider.getFullTextRegion((EObject)cfe);
        return tr.getOffset();
    }

    private int getOffsetEnd(ControlFlowElement cfe) {
        ITextRegion tr = this.locFileProvider.getFullTextRegion((EObject)cfe);
        return tr.getOffset() + tr.getLength();
    }

    private int getLineStart(ControlFlowElement cfe) {
        int line = this.styledText.getLineAtOffset(this.getOffsetStart(cfe));
        return line;
    }

    private int getLineEnd(ControlFlowElement cfe) {
        int line = this.styledText.getLineAtOffset(this.getOffsetEnd(cfe));
        return line;
    }

    private class CFEComparator
    implements Comparator<CFNode> {
        private CFEComparator() {
        }

        @Override
        public int compare(CFNode cfn1, CFNode cfn2) {
            int line2;
            ControlFlowElement cfe1 = cfn1.getControlFlowElement();
            ControlFlowElement cfe2 = cfn2.getControlFlowElement();
            int line1 = cfn1.isEntry ? CFGraph.this.getLineStart(cfe1) : CFGraph.this.getLineEnd(cfe1);
            int offset = line1 - (line2 = cfn2.isEntry ? CFGraph.this.getLineStart(cfe2) : CFGraph.this.getLineEnd(cfe2));
            if (offset == 0) {
                offset = cfn1.nodeIdx - cfn2.nodeIdx;
            }
            return offset;
        }
    }
}

