/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.PriorityQueue;

abstract class DocValuesFieldUpdates {
    protected static final int PAGE_SIZE = 1024;
    final String field;
    final DocValuesType type;
    final long delGen;
    protected boolean finished;
    protected final int maxDoc;

    public static Iterator mergedIterator(Iterator[] subs) {
        if (subs.length == 1) {
            return subs[0];
        }
        final PriorityQueue<Iterator> queue = new PriorityQueue<Iterator>(subs.length){

            @Override
            protected boolean lessThan(Iterator a, Iterator b) {
                int cmp = Integer.compare(a.doc(), b.doc());
                if (cmp == 0) {
                    cmp = Long.compare(b.delGen(), a.delGen());
                    assert (cmp != 0);
                }
                return cmp < 0;
            }
        };
        for (Iterator sub : subs) {
            if (sub.nextDoc() == Integer.MAX_VALUE) continue;
            queue.add(sub);
        }
        if (queue.size() == 0) {
            return null;
        }
        return new Iterator(){
            private int doc;
            private boolean first = true;

            @Override
            public int nextDoc() {
                block6: {
                    if (!this.first) {
                        while (true) {
                            if (queue.size() == 0) {
                                this.doc = Integer.MAX_VALUE;
                                break block6;
                            }
                            int newDoc = ((Iterator)queue.top()).doc();
                            if (newDoc != this.doc) {
                                assert (newDoc > this.doc) : "doc=" + this.doc + " newDoc=" + newDoc;
                                this.doc = newDoc;
                                break block6;
                            }
                            if (((Iterator)queue.top()).nextDoc() == Integer.MAX_VALUE) {
                                queue.pop();
                                continue;
                            }
                            queue.updateTop();
                        }
                    }
                    this.doc = ((Iterator)queue.top()).doc();
                    this.first = false;
                }
                return this.doc;
            }

            @Override
            public int doc() {
                return this.doc;
            }

            @Override
            public Object value() {
                return ((Iterator)queue.top()).value();
            }

            @Override
            public long delGen() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected DocValuesFieldUpdates(int maxDoc, long delGen, String field, DocValuesType type) {
        this.maxDoc = maxDoc;
        this.delGen = delGen;
        this.field = field;
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null");
        }
        this.type = type;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public abstract void add(int var1, Object var2);

    public abstract Iterator iterator();

    public abstract void finish();

    public abstract boolean any();

    public abstract long ramBytesUsed();

    public abstract int size();

    static abstract class Iterator {
        Iterator() {
        }

        abstract int nextDoc();

        abstract int doc();

        abstract Object value();

        abstract long delGen();
    }
}

